/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.FilteredArtifactCollection;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitTransitiveDepsWriterTaskKt;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000f0\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0006H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017H\u0096\u0002J\u0016\u0010\u0018\u001a\u0010\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u000f0\u000f0\u0019H\u0016R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/dependency/FilteredArtifactCollection;", "Lorg/gradle/api/artifacts/ArtifactCollection;", "project", "Lorg/gradle/api/Project;", "mainArtifact", "excludeDirectoryFiles", "Lorg/gradle/api/file/FileCollection;", "(Lorg/gradle/api/Project;Lorg/gradle/api/artifacts/ArtifactCollection;Lorg/gradle/api/file/FileCollection;)V", "fileCollection", "filterResolver", "Lcom/android/build/gradle/internal/dependency/FilteredArtifactCollection$FilterResolver;", "forEach", "", "action", "Ljava/util/function/Consumer;", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "getArtifactFiles", "getArtifacts", "", "getFailures", "", "", "iterator", "", "spliterator", "Ljava/util/Spliterator;", "kotlin.jvm.PlatformType", "FilterResolver", "gradle"})
public final class FilteredArtifactCollection
implements ArtifactCollection {
    private final FileCollection fileCollection;
    private final FilterResolver filterResolver;

    @NotNull
    public FileCollection getArtifactFiles() {
        return this.fileCollection;
    }

    @NotNull
    public Set<ResolvedArtifactResult> getArtifacts() {
        return this.filterResolver.getArtifactResults();
    }

    @NotNull
    public Collection<Throwable> getFailures() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)this.filterResolver.getMainArtifacts().getFailures());
        ImmutableList immutableList = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"builder.build()");
        return (Collection)immutableList;
    }

    @NotNull
    public Iterator<ResolvedArtifactResult> iterator() {
        Iterator<ResolvedArtifactResult> iterator = this.getArtifacts().iterator();
        if (iterator == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableIterator<org.gradle.api.artifacts.result.ResolvedArtifactResult>");
        }
        return TypeIntrinsics.asMutableIterator(iterator);
    }

    @NotNull
    public Spliterator<ResolvedArtifactResult> spliterator() {
        return this.getArtifacts().spliterator();
    }

    public void forEach(@NotNull Consumer<? super ResolvedArtifactResult> action) {
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        this.getArtifacts().forEach(action);
    }

    public FilteredArtifactCollection(@NotNull Project project, @NotNull ArtifactCollection mainArtifact, @NotNull FileCollection excludeDirectoryFiles) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)mainArtifact, (String)"mainArtifact");
        Intrinsics.checkParameterIsNotNull((Object)excludeDirectoryFiles, (String)"excludeDirectoryFiles");
        this.filterResolver = new FilterResolver(mainArtifact, excludeDirectoryFiles, project);
        ConfigurableFileCollection configurableFileCollection = project.files(new Object[]{this.filterResolver});
        Object[] objectArray = new Object[1];
        FileCollection fileCollection = mainArtifact.getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"mainArtifact.artifactFiles");
        objectArray[0] = fileCollection.getBuildDependencies();
        ConfigurableFileCollection configurableFileCollection2 = configurableFileCollection.builtBy(objectArray).builtBy(new Object[]{excludeDirectoryFiles.getBuildDependencies()});
        Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection2, (String)"project.files(filterReso\u2026yFiles.buildDependencies)");
        this.fileCollection = (FileCollection)configurableFileCollection2;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00020\u0001B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0002H\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/dependency/FilteredArtifactCollection$FilterResolver;", "Ljava/util/concurrent/Callable;", "Lorg/gradle/api/provider/Provider;", "", "Ljava/io/File;", "mainArtifacts", "Lorg/gradle/api/artifacts/ArtifactCollection;", "excludeDirectoryFiles", "Lorg/gradle/api/file/FileCollection;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/artifacts/ArtifactCollection;Lorg/gradle/api/file/FileCollection;Lorg/gradle/api/Project;)V", "getMainArtifacts", "()Lorg/gradle/api/artifacts/ArtifactCollection;", "call", "computeFilteredArtifacts", "", "", "getArtifactResults", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "gradle"})
    private static final class FilterResolver
    implements Callable<Provider<Collection<? extends File>>> {
        @NotNull
        private final ArtifactCollection mainArtifacts;
        private final FileCollection excludeDirectoryFiles;
        private final Project project;

        @NotNull
        public final Set<ResolvedArtifactResult> getArtifactResults() {
            Set<String> filteredArtifacts = this.computeFilteredArtifacts();
            if (filteredArtifacts.isEmpty()) {
                Set set = this.mainArtifacts.getArtifacts();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"mainArtifacts.artifacts");
                return set;
            }
            Set set = this.mainArtifacts.getArtifacts();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"mainArtifacts.artifacts");
            return SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)set), (Function1)((Function1)new Function1<ResolvedArtifactResult, Boolean>(filteredArtifacts){
                final /* synthetic */ Set $filteredArtifacts;

                public final boolean invoke(ResolvedArtifactResult it) {
                    ResolvedArtifactResult resolvedArtifactResult = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifactResult, (String)"it");
                    return !this.$filteredArtifacts.contains(FeatureSplitTransitiveDepsWriterTaskKt.compIdToString(resolvedArtifactResult));
                }
                {
                    this.$filteredArtifacts = set;
                    super(1);
                }
            })));
        }

        @Override
        @NotNull
        public Provider<Collection<File>> call() {
            Set<String> excludedArtifacts = this.computeFilteredArtifacts();
            if (excludedArtifacts.isEmpty()) {
                Provider provider = this.project.getProviders().provider((Callable)new Callable<Collection<? extends File>>(this){
                    final /* synthetic */ FilterResolver this$0;

                    public final Set<File> call() {
                        FileCollection fileCollection = this.this$0.getMainArtifacts().getArtifactFiles();
                        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"mainArtifacts.artifactFiles");
                        return fileCollection.getFiles();
                    }
                    {
                        this.this$0 = filterResolver;
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)provider, (String)"project.providers.provid\u2026cts.artifactFiles.files})");
                return provider;
            }
            Provider provider = this.project.getProviders().provider((Callable)new Callable<Collection<? extends File>>(this, excludedArtifacts){
                final /* synthetic */ FilterResolver this$0;
                final /* synthetic */ Set $excludedArtifacts;

                @NotNull
                public final Set<File> call() {
                    Set set = this.this$0.getMainArtifacts().getArtifacts();
                    Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"mainArtifacts.artifacts");
                    return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)set), (Function1)((Function1)new Function1<ResolvedArtifactResult, Boolean>(this){
                        final /* synthetic */ call.2 this$0;

                        public final boolean invoke(ResolvedArtifactResult it) {
                            Set set = this.this$0.$excludedArtifacts;
                            ResolvedArtifactResult resolvedArtifactResult = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifactResult, (String)"it");
                            return !set.contains(FeatureSplitTransitiveDepsWriterTaskKt.compIdToString(resolvedArtifactResult));
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    })), (Function1)FilterResolver.call.2.INSTANCE));
                }
                {
                    this.this$0 = filterResolver;
                    this.$excludedArtifacts = set;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)provider, (String)"project.providers.provid\u2026map { it.file }.toSet()})");
            return provider;
        }

        private final Set<String> computeFilteredArtifacts() {
            Set<String> set = this.excludeDirectoryFiles.getFiles().stream().map(computeFilteredArtifacts.1.INSTANCE).flatMap(computeFilteredArtifacts.2.INSTANCE).collect(Collectors.toSet());
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"excludeDirectoryFiles\n  \u2026llectors.toSet<String>())");
            return set;
        }

        @NotNull
        public final ArtifactCollection getMainArtifacts() {
            return this.mainArtifacts;
        }

        public FilterResolver(@NotNull ArtifactCollection mainArtifacts, @NotNull FileCollection excludeDirectoryFiles, @NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)mainArtifacts, (String)"mainArtifacts");
            Intrinsics.checkParameterIsNotNull((Object)excludeDirectoryFiles, (String)"excludeDirectoryFiles");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            this.mainArtifacts = mainArtifacts;
            this.excludeDirectoryFiles = excludeDirectoryFiles;
            this.project = project;
        }
    }
}

