/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;

public class LanguageSplitOptions {
    private boolean enable = false;
    private boolean auto = false;
    private Set<String> include;
    private final DeprecationReporter deprecationReporter;

    @Inject
    public LanguageSplitOptions(DeprecationReporter deprecationReporter) {
        this.deprecationReporter = deprecationReporter;
    }

    public Set<String> getInclude() {
        return this.include;
    }

    public void setInclude(List<String> list) {
        this.include = Sets.newHashSet(list);
    }

    public void include(String ... includes) {
        if (this.include == null) {
            this.include = Sets.newHashSet((Object[])includes);
            return;
        }
        this.include.addAll(Arrays.asList(includes));
    }

    public Set<String> getApplicationFilters() {
        return this.include == null || !this.enable ? new HashSet() : this.include;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setAuto(boolean auto) {
        this.deprecationReporter.reportObsoleteUsage("LanguageSplitOptions.auto", DeprecationReporter.DeprecationTarget.AUTO_SPLITS_OR_RES_CONFIG);
        this.auto = auto;
    }

    public boolean isAuto() {
        return this.auto;
    }
}

