/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.SdkConstants;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.res.Aapt2MavenUtils;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.BundleTaskUtil;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.tools.build.bundletool.commands.BuildApksCommand;
import com.android.tools.build.bundletool.model.Aapt2Command;
import com.android.utils.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0003+,-B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010)\u001a\u00020*H\u0007R&\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR&\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R*\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0005\u001a\u0004\u0018\u00010\u00128\u0007@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R*\u0010\u0018\u001a\u0004\u0018\u00010\u00122\b\u0010\u0005\u001a\u0004\u0018\u00010\u00128\u0007@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R*\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u001b8\u0007@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R*\u0010!\u001a\u0004\u0018\u00010\u00122\b\u0010\u0005\u001a\u0004\u0018\u00010\u00128\u0007@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0015\"\u0004\b#\u0010\u0017R&\u0010$\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u001b8\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001e\"\u0004\b&\u0010 R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/android/build/gradle/internal/tasks/BundleToApkTask;", "Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "<set-?>", "Lorg/gradle/api/file/FileCollection;", "aapt2FromMaven", "getAapt2FromMaven", "()Lorg/gradle/api/file/FileCollection;", "setAapt2FromMaven", "(Lorg/gradle/api/file/FileCollection;)V", "Lcom/android/build/api/artifact/BuildableArtifact;", "bundle", "getBundle", "()Lcom/android/build/api/artifact/BuildableArtifact;", "setBundle", "(Lcom/android/build/api/artifact/BuildableArtifact;)V", "", "keyAlias", "getKeyAlias", "()Ljava/lang/String;", "setKeyAlias", "(Ljava/lang/String;)V", "keyPassword", "getKeyPassword", "setKeyPassword", "Ljava/io/File;", "keystoreFile", "getKeystoreFile", "()Ljava/io/File;", "setKeystoreFile", "(Ljava/io/File;)V", "keystorePassword", "getKeystorePassword", "setKeystorePassword", "outputFile", "getOutputFile", "setOutputFile", "workers", "Lcom/android/ide/common/workers/WorkerExecutorFacade;", "generateApk", "", "BundleToolRunnable", "ConfigAction", "Params", "gradle"})
public class BundleToApkTask
extends AndroidVariantTask {
    @NotNull
    private BuildableArtifact bundle;
    @NotNull
    private FileCollection aapt2FromMaven;
    @NotNull
    private File outputFile;
    @Nullable
    private File keystoreFile;
    @Nullable
    private String keystorePassword;
    @Nullable
    private String keyAlias;
    @Nullable
    private String keyPassword;
    private final WorkerExecutorFacade workers;

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public final BuildableArtifact getBundle() {
        BuildableArtifact buildableArtifact = this.bundle;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundle");
        }
        return buildableArtifact;
    }

    private final void setBundle(BuildableArtifact buildableArtifact) {
        this.bundle = buildableArtifact;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public final FileCollection getAapt2FromMaven() {
        FileCollection fileCollection = this.aapt2FromMaven;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aapt2FromMaven");
        }
        return fileCollection;
    }

    private final void setAapt2FromMaven(FileCollection fileCollection) {
        this.aapt2FromMaven = fileCollection;
    }

    @OutputFile
    @NotNull
    public final File getOutputFile() {
        File file = this.outputFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputFile");
        }
        return file;
    }

    private final void setOutputFile(File file) {
        this.outputFile = file;
    }

    @InputFile
    @Optional
    @Nullable
    public final File getKeystoreFile() {
        return this.keystoreFile;
    }

    private final void setKeystoreFile(File file) {
        this.keystoreFile = file;
    }

    @Input
    @Optional
    @Nullable
    public final String getKeystorePassword() {
        return this.keystorePassword;
    }

    private final void setKeystorePassword(String string) {
        this.keystorePassword = string;
    }

    @Input
    @Optional
    @Nullable
    public final String getKeyAlias() {
        return this.keyAlias;
    }

    private final void setKeyAlias(String string) {
        this.keyAlias = string;
    }

    @Input
    @Optional
    @Nullable
    public final String getKeyPassword() {
        return this.keyPassword;
    }

    private final void setKeyPassword(String string) {
        this.keyPassword = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void generateApk() {
        Closeable closeable = (Closeable)this.workers;
        Throwable throwable = null;
        try {
            WorkerExecutorFacade it = (WorkerExecutorFacade)closeable;
            BuildableArtifact buildableArtifact = this.bundle;
            if (buildableArtifact == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bundle");
            }
            File file = BuildableArtifactUtil.singleFile(buildableArtifact);
            FileCollection fileCollection = this.aapt2FromMaven;
            if (fileCollection == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"aapt2FromMaven");
            }
            File file2 = new File(fileCollection.getSingleFile(), SdkConstants.FN_AAPT2);
            File file3 = this.outputFile;
            if (file3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"outputFile");
            }
            it.submit(BundleToolRunnable.class, (Serializable)new Params(file, file2, file3, this.keystoreFile, this.keystorePassword, this.keyAlias, this.keyPassword));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Inject
    public BundleToApkTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkParameterIsNotNull((Object)workerExecutor, (String)"workerExecutor");
        this.workers = Workers.getWorker$default(Workers.INSTANCE, workerExecutor, null, 2, null);
    }

    @NotNull
    public static final /* synthetic */ File access$getOutputFile$p(BundleToApkTask $this) {
        File file = $this.outputFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputFile");
        }
        return file;
    }

    @NotNull
    public static final /* synthetic */ BuildableArtifact access$getBundle$p(BundleToApkTask $this) {
        BuildableArtifact buildableArtifact = $this.bundle;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundle");
        }
        return buildableArtifact;
    }

    @NotNull
    public static final /* synthetic */ FileCollection access$getAapt2FromMaven$p(BundleToApkTask $this) {
        FileCollection fileCollection = $this.aapt2FromMaven;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aapt2FromMaven");
        }
        return fileCollection;
    }

    @Nullable
    public static final /* synthetic */ File access$getKeystoreFile$p(BundleToApkTask $this) {
        return $this.keystoreFile;
    }

    @Nullable
    public static final /* synthetic */ String access$getKeystorePassword$p(BundleToApkTask $this) {
        return $this.keystorePassword;
    }

    @Nullable
    public static final /* synthetic */ String access$getKeyAlias$p(BundleToApkTask $this) {
        return $this.keyAlias;
    }

    @Nullable
    public static final /* synthetic */ String access$getKeyPassword$p(BundleToApkTask $this) {
        return $this.keyPassword;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\bH\u00c6\u0003JW\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0013\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\n\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006$"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleToApkTask$Params;", "Ljava/io/Serializable;", "bundleFile", "Ljava/io/File;", "aapt2File", "outputFile", "keystoreFile", "keystorePassword", "", "keyAlias", "keyPassword", "(Ljava/io/File;Ljava/io/File;Ljava/io/File;Ljava/io/File;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAapt2File", "()Ljava/io/File;", "getBundleFile", "getKeyAlias", "()Ljava/lang/String;", "getKeyPassword", "getKeystoreFile", "getKeystorePassword", "getOutputFile", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "", "hashCode", "", "toString", "gradle"})
    private static final class Params
    implements Serializable {
        @NotNull
        private final File bundleFile;
        @NotNull
        private final File aapt2File;
        @NotNull
        private final File outputFile;
        @Nullable
        private final File keystoreFile;
        @Nullable
        private final String keystorePassword;
        @Nullable
        private final String keyAlias;
        @Nullable
        private final String keyPassword;

        @NotNull
        public final File getBundleFile() {
            return this.bundleFile;
        }

        @NotNull
        public final File getAapt2File() {
            return this.aapt2File;
        }

        @NotNull
        public final File getOutputFile() {
            return this.outputFile;
        }

        @Nullable
        public final File getKeystoreFile() {
            return this.keystoreFile;
        }

        @Nullable
        public final String getKeystorePassword() {
            return this.keystorePassword;
        }

        @Nullable
        public final String getKeyAlias() {
            return this.keyAlias;
        }

        @Nullable
        public final String getKeyPassword() {
            return this.keyPassword;
        }

        public Params(@NotNull File bundleFile, @NotNull File aapt2File, @NotNull File outputFile, @Nullable File keystoreFile, @Nullable String keystorePassword, @Nullable String keyAlias, @Nullable String keyPassword) {
            Intrinsics.checkParameterIsNotNull((Object)bundleFile, (String)"bundleFile");
            Intrinsics.checkParameterIsNotNull((Object)aapt2File, (String)"aapt2File");
            Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
            this.bundleFile = bundleFile;
            this.aapt2File = aapt2File;
            this.outputFile = outputFile;
            this.keystoreFile = keystoreFile;
            this.keystorePassword = keystorePassword;
            this.keyAlias = keyAlias;
            this.keyPassword = keyPassword;
        }

        @NotNull
        public final File component1() {
            return this.bundleFile;
        }

        @NotNull
        public final File component2() {
            return this.aapt2File;
        }

        @NotNull
        public final File component3() {
            return this.outputFile;
        }

        @Nullable
        public final File component4() {
            return this.keystoreFile;
        }

        @Nullable
        public final String component5() {
            return this.keystorePassword;
        }

        @Nullable
        public final String component6() {
            return this.keyAlias;
        }

        @Nullable
        public final String component7() {
            return this.keyPassword;
        }

        @NotNull
        public final Params copy(@NotNull File bundleFile, @NotNull File aapt2File, @NotNull File outputFile, @Nullable File keystoreFile, @Nullable String keystorePassword, @Nullable String keyAlias, @Nullable String keyPassword) {
            Intrinsics.checkParameterIsNotNull((Object)bundleFile, (String)"bundleFile");
            Intrinsics.checkParameterIsNotNull((Object)aapt2File, (String)"aapt2File");
            Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
            return new Params(bundleFile, aapt2File, outputFile, keystoreFile, keystorePassword, keyAlias, keyPassword);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Params copy$default(Params params, File file, File file2, File file3, File file4, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                file = params.bundleFile;
            }
            if ((n & 2) != 0) {
                file2 = params.aapt2File;
            }
            if ((n & 4) != 0) {
                file3 = params.outputFile;
            }
            if ((n & 8) != 0) {
                file4 = params.keystoreFile;
            }
            if ((n & 0x10) != 0) {
                string = params.keystorePassword;
            }
            if ((n & 0x20) != 0) {
                string2 = params.keyAlias;
            }
            if ((n & 0x40) != 0) {
                string3 = params.keyPassword;
            }
            return params.copy(file, file2, file3, file4, string, string2, string3);
        }

        public String toString() {
            return "Params(bundleFile=" + this.bundleFile + ", aapt2File=" + this.aapt2File + ", outputFile=" + this.outputFile + ", keystoreFile=" + this.keystoreFile + ", keystorePassword=" + this.keystorePassword + ", keyAlias=" + this.keyAlias + ", keyPassword=" + this.keyPassword + ")";
        }

        public int hashCode() {
            File file = this.bundleFile;
            File file2 = this.aapt2File;
            File file3 = this.outputFile;
            File file4 = this.keystoreFile;
            String string = this.keystorePassword;
            String string2 = this.keyAlias;
            String string3 = this.keyPassword;
            return ((((((file != null ? ((Object)file).hashCode() : 0) * 31 + (file2 != null ? ((Object)file2).hashCode() : 0)) * 31 + (file3 != null ? ((Object)file3).hashCode() : 0)) * 31 + (file4 != null ? ((Object)file4).hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Params)) break block3;
                    Params params = (Params)object;
                    if (!Intrinsics.areEqual((Object)this.bundleFile, (Object)params.bundleFile) || !Intrinsics.areEqual((Object)this.aapt2File, (Object)params.aapt2File) || !Intrinsics.areEqual((Object)this.outputFile, (Object)params.outputFile) || !Intrinsics.areEqual((Object)this.keystoreFile, (Object)params.keystoreFile) || !Intrinsics.areEqual((Object)this.keystorePassword, (Object)params.keystorePassword) || !Intrinsics.areEqual((Object)this.keyAlias, (Object)params.keyAlias) || !Intrinsics.areEqual((Object)this.keyPassword, (Object)params.keyPassword)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleToApkTask$BundleToolRunnable;", "Ljava/lang/Runnable;", "params", "Lcom/android/build/gradle/internal/tasks/BundleToApkTask$Params;", "(Lcom/android/build/gradle/internal/tasks/BundleToApkTask$Params;)V", "run", "", "gradle"})
    private static final class BundleToolRunnable
    implements Runnable {
        private final Params params;

        @Override
        public void run() {
            FileUtils.deleteIfExists((File)this.params.getOutputFile());
            BuildApksCommand.Builder builder = BuildApksCommand.builder().setBundlePath(this.params.getBundleFile().toPath()).setOutputFile(this.params.getOutputFile().toPath()).setAapt2Command(Aapt2Command.createFromExecutablePath((Path)this.params.getAapt2File().toPath()));
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"BuildApksCommand\n       \u2026rams.aapt2File.toPath()))");
            BuildApksCommand.Builder command = BundleTaskUtil.setSigningConfiguration(builder, this.params.getKeystoreFile(), this.params.getKeystorePassword(), this.params.getKeyAlias(), this.params.getKeyPassword());
            command.build().execute();
        }

        @Inject
        public BundleToolRunnable(@NotNull Params params) {
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            this.params = params;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleToApkTask$ConfigAction;", "Lcom/android/build/gradle/internal/scope/TaskConfigAction;", "Lcom/android/build/gradle/internal/tasks/BundleToApkTask;", "scope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "execute", "", "task", "getName", "", "getType", "Ljava/lang/Class;", "gradle"})
    public static final class ConfigAction
    implements TaskConfigAction<BundleToApkTask> {
        private final VariantScope scope;

        @Override
        @NotNull
        public String getName() {
            return this.scope.getTaskName("makeApkFromBundleFor");
        }

        @Override
        @NotNull
        public Class<BundleToApkTask> getType() {
            return BundleToApkTask.class;
        }

        @Override
        public void execute(@NotNull BundleToApkTask task) {
            block0: {
                CoreSigningConfig coreSigningConfig;
                CoreSigningConfig it;
                Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
                task.setVariantName(this.scope.getFullVariantName());
                task.outputFile = this.scope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.APKS_FROM_BUNDLE, (Task)task, "bundle.apks");
                task.bundle = this.scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.BUNDLE);
                GlobalScope globalScope = this.scope.getGlobalScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"scope.globalScope");
                task.aapt2FromMaven = Aapt2MavenUtils.getAapt2FromMaven(globalScope);
                GradleVariantConfiguration gradleVariantConfiguration = this.scope.getVariantConfiguration();
                Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"scope.variantConfiguration");
                CoreSigningConfig coreSigningConfig2 = gradleVariantConfiguration.getSigningConfig();
                if (coreSigningConfig2 == null) break block0;
                CoreSigningConfig coreSigningConfig3 = it = (coreSigningConfig = coreSigningConfig2);
                Intrinsics.checkExpressionValueIsNotNull((Object)coreSigningConfig3, (String)"it");
                task.keystoreFile = coreSigningConfig3.getStoreFile();
                task.keystorePassword = it.getStorePassword();
                task.keyAlias = it.getKeyAlias();
                task.keyPassword = it.getKeyPassword();
            }
        }

        public ConfigAction(@NotNull VariantScope scope) {
            Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
            this.scope = scope;
        }
    }
}

