/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.build.gradle.internal.CompileOptions;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.utils.ILogger;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.compile.AbstractCompile;

public class AbstractCompilesUtil {
    public static final String ANDROID_APT_PLUGIN_NAME = "com.neenbedankt.android-apt";

    public static void configureLanguageLevel(AbstractCompile compileTask, CompileOptions compileOptions, String compileSdkVersion, VariantScope.Java8LangSupport java8LangSupport) {
        AbstractCompilesUtil.setDefaultJavaVersion(compileOptions, compileSdkVersion, java8LangSupport);
        compileTask.setSourceCompatibility(compileOptions.getSourceCompatibility().toString());
        compileTask.setTargetCompatibility(compileOptions.getTargetCompatibility().toString());
    }

    public static void setDefaultJavaVersion(CompileOptions compileOptions, String compileSdkVersion, VariantScope.Java8LangSupport java8LangSupport) {
        compileOptions.setDefaultJavaVersion(AbstractCompilesUtil.chooseDefaultJavaVersion(compileSdkVersion, System.getProperty("java.specification.version"), java8LangSupport));
    }

    static JavaVersion chooseDefaultJavaVersion(String compileSdkVersion, String currentJdkVersion, VariantScope.Java8LangSupport java8LangSupport) {
        Integer compileSdkLevel;
        AndroidVersion hash = AndroidTargetHash.getVersionFromHash((String)compileSdkVersion);
        Integer n = compileSdkLevel = hash == null ? null : Integer.valueOf(hash.getFeatureLevel());
        JavaVersion javaVersionToUse = compileSdkLevel == null ? JavaVersion.VERSION_1_6 : (0 < compileSdkLevel && compileSdkLevel <= 20 ? JavaVersion.VERSION_1_6 : (21 <= compileSdkLevel && compileSdkLevel < 24 ? JavaVersion.VERSION_1_7 : JavaVersion.VERSION_1_7));
        JavaVersion jdkVersion = JavaVersion.toVersion((Object)currentJdkVersion);
        if (jdkVersion.compareTo((Enum)javaVersionToUse) < 0) {
            Logging.getLogger(AbstractCompilesUtil.class).warn("Default language level for compileSdkVersion '{}' is {}, but the JDK used is {}, so the JDK language level will be used.", new Object[]{compileSdkVersion, javaVersionToUse, jdkVersion});
            javaVersionToUse = jdkVersion;
        }
        return javaVersionToUse;
    }

    public static boolean isIncremental(Project project, VariantScope variantScope, CompileOptions compileOptions, Configuration processorConfiguration, ILogger log) {
        boolean incremental = true;
        if (compileOptions.getIncremental() != null) {
            incremental = compileOptions.getIncremental();
            log.verbose("Incremental flag set to %1$b in DSL", new Object[]{incremental});
        } else {
            boolean hasAnnotationProcessor;
            boolean bl = hasAnnotationProcessor = processorConfiguration != null && !processorConfiguration.getAllDependencies().isEmpty();
            if (variantScope.getGlobalScope().getExtension().getDataBinding().isEnabled() || hasAnnotationProcessor || project.getPlugins().hasPlugin("me.tatarka.retrolambda")) {
                incremental = false;
                log.verbose("Incremental Java compilation disabled in variant %1$s as you are using an incompatible plugin", new Object[]{variantScope.getVariantConfiguration().getFullName()});
            }
        }
        return incremental;
    }
}

