/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.dsl.Splits;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.SplitList;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidBuilderTask;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.gradle.api.Task;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class SplitsDiscovery
extends AndroidBuilderTask {
    BuildableArtifact mergedResourcesFolders;
    Set<String> densityFilters;
    boolean densityAuto;
    Set<String> languageFilters;
    boolean languageAuto;
    Set<String> abiFilters;
    boolean resConfigAuto;
    Collection<String> resourceConfigs;
    File persistedList;

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public BuildableArtifact getMergedResourcesFolders() {
        return this.mergedResourcesFolders;
    }

    @Input
    @Optional
    public Set<String> getDensityFilters() {
        return this.densityFilters;
    }

    @Input
    @Optional
    public boolean isDensityAuto() {
        return this.densityAuto;
    }

    @Input
    @Optional
    public Set<String> getLanguageFilters() {
        return this.languageFilters;
    }

    @Input
    @Optional
    public boolean isLanguageAuto() {
        return this.languageAuto;
    }

    @Input
    @Optional
    public Set<String> getAbiFilters() {
        return this.abiFilters;
    }

    @Input
    public boolean isResConfigAuto() {
        return this.resConfigAuto;
    }

    @Input
    public Collection<String> getResourceConfigs() {
        return this.resourceConfigs;
    }

    @OutputFile
    public File getPersistedList() {
        return this.persistedList;
    }

    @TaskAction
    void taskAction() throws IOException {
        Set mergedResourcesFolderFiles = this.mergedResourcesFolders != null ? this.mergedResourcesFolders.getFiles() : null;
        Collection<String> resConfigs = this.resourceConfigs;
        if (this.resConfigAuto) {
            resConfigs = this.discoverListOfResourceConfigsNotDensities();
        }
        SplitList.save(this.getPersistedList(), this.getFilters(mergedResourcesFolderFiles, DiscoverableFilterType.DENSITY), this.getFilters(mergedResourcesFolderFiles, DiscoverableFilterType.LANGUAGE), this.getFilters((Iterable<File>)ImmutableList.of(), DiscoverableFilterType.ABI), resConfigs.stream().map(SplitList.Filter::new).collect(Collectors.toList()));
    }

    private List<SplitList.Filter> getFilters(Iterable<File> resourceFolders, DiscoverableFilterType filterType) {
        HashSet<String> filtersList = new HashSet<String>();
        if (filterType.isAuto(this)) {
            Preconditions.checkNotNull(resourceFolders, (Object)"Merged resources must be supplied to perform automatic discovery of splits.");
            filtersList.addAll(SplitsDiscovery.getAllFilters(resourceFolders, filterType.folderPrefix));
            if (filterType == DiscoverableFilterType.LANGUAGE) {
                return SplitsDiscovery.mergeFiltersByRootLanguage(filtersList);
            }
        } else {
            filtersList.addAll(filterType.getConfiguredFilters(this));
        }
        return filtersList.stream().map(SplitList.Filter::new).collect(Collectors.toList());
    }

    public List<String> discoverListOfResourceConfigsNotDensities() {
        Preconditions.checkNotNull((Object)this.mergedResourcesFolders, (Object)"Merged resources must be supplied to perform automatic discovery of resource configs.");
        return new ArrayList<String>(SplitsDiscovery.getAllFilters((Iterable<File>)this.mergedResourcesFolders, DiscoverableFilterType.LANGUAGE.folderPrefix));
    }

    private static List<String> getAllFilters(Iterable<File> resourceFolders, String ... prefixes) {
        ArrayList<String> providedResFolders = new ArrayList<String>();
        for (File resFolder : resourceFolders) {
            File[] subResFolders = resFolder.listFiles();
            if (subResFolders == null) continue;
            for (File subResFolder : subResFolders) {
                for (String prefix : prefixes) {
                    if (!subResFolder.getName().startsWith(prefix)) continue;
                    providedResFolders.add(SplitsDiscovery.getFilter(subResFolder, prefix));
                }
            }
        }
        return providedResFolders;
    }

    private static List<SplitList.Filter> mergeFiltersByRootLanguage(Collection<String> filters) {
        return filters.stream().collect(Collectors.groupingBy(SplitsDiscovery::getRootLanguage, Collectors.collectingAndThen(Collectors.toCollection(TreeSet::new), sortedStrings -> String.join((CharSequence)",", sortedStrings)))).entrySet().stream().map(entry -> new SplitList.Filter((String)entry.getValue(), (String)entry.getKey())).collect(Collectors.toList());
    }

    private static String getRootLanguage(String fullFilter) {
        return fullFilter.split("\\P{Alpha}")[0];
    }

    private static String getFilter(File file, String prefix) {
        int firstUnderscore;
        if (file.isDirectory()) {
            return file.getName().substring(prefix.length());
        }
        if (file.isFile() && file.getName().endsWith(".flat") && (firstUnderscore = file.getName().indexOf(95)) > -1) {
            return file.getName().substring(prefix.length(), firstUnderscore);
        }
        return "";
    }

    public static final class ConfigAction
    extends TaskConfigAction<SplitsDiscovery> {
        private final VariantScope variantScope;

        public ConfigAction(VariantScope variantScope) {
            this.variantScope = variantScope;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("splitsDiscoveryTask");
        }

        @Override
        public Class<SplitsDiscovery> getType() {
            return SplitsDiscovery.class;
        }

        @Override
        public void execute(SplitsDiscovery task) {
            task.setVariantName(this.variantScope.getFullVariantName());
            Splits splits = this.variantScope.getGlobalScope().getExtension().getSplits();
            task.persistedList = this.variantScope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.SPLIT_LIST, (Task)task, "split-list.gson");
            if (splits.getDensity().isEnable()) {
                task.densityFilters = splits.getDensityFilters();
                task.densityAuto = splits.getDensity().isAuto();
            }
            if (splits.getLanguage().isEnable()) {
                task.languageFilters = splits.getLanguageFilters();
                task.languageAuto = splits.getLanguage().isAuto();
            }
            if (splits.getAbi().isEnable()) {
                task.abiFilters = splits.getAbiFilters();
            }
            task.resourceConfigs = this.variantScope.getVariantConfiguration().getMergedFlavor().getResourceConfigurations();
            boolean bl = task.resConfigAuto = task.resourceConfigs.size() == 1 && ((String)Iterables.getOnlyElement(task.resourceConfigs)).equals("auto");
            if (task.densityAuto || task.languageAuto || task.resConfigAuto) {
                task.mergedResourcesFolders = this.variantScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.MERGED_RES);
            }
        }
    }

    private static enum DiscoverableFilterType {
        DENSITY("drawable-"){

            @Override
            Collection<String> getConfiguredFilters(SplitsDiscovery task) {
                return task.getDensityFilters() != null ? task.getDensityFilters() : ImmutableList.of();
            }

            @Override
            boolean isAuto(SplitsDiscovery task) {
                return task.isDensityAuto();
            }
        }
        ,
        LANGUAGE("values-"){

            @Override
            Collection<String> getConfiguredFilters(SplitsDiscovery task) {
                return task.getLanguageFilters() != null ? task.getLanguageFilters() : ImmutableList.of();
            }

            @Override
            boolean isAuto(SplitsDiscovery task) {
                return task.isLanguageAuto();
            }
        }
        ,
        ABI(""){

            @Override
            Collection<String> getConfiguredFilters(SplitsDiscovery task) {
                return task.getAbiFilters() != null ? task.getAbiFilters() : ImmutableList.of();
            }

            @Override
            boolean isAuto(SplitsDiscovery task) {
                return false;
            }
        };

        private final String folderPrefix;

        private DiscoverableFilterType(String folderPrefix) {
            this.folderPrefix = folderPrefix;
        }

        abstract Collection<String> getConfiguredFilters(SplitsDiscovery var1);

        abstract boolean isAuto(SplitsDiscovery var1);
    }
}

