/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.AnchorOutputType;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Objects;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.testing.JUnitXmlReport;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestTaskReports;

public class AndroidUnitTest
extends Test {
    private String sdkPlatformDirPath;
    private BuildableArtifact mergedManifest;
    private BuildableArtifact resCollection;
    private BuildableArtifact assetsCollection;

    @InputFiles
    @Optional
    public BuildableArtifact getResCollection() {
        return this.resCollection;
    }

    @InputFiles
    @Optional
    public BuildableArtifact getAssetsCollection() {
        return this.assetsCollection;
    }

    @Input
    public String getSdkPlatformDirPath() {
        return this.sdkPlatformDirPath;
    }

    @InputFiles
    public BuildableArtifact getMergedManifest() {
        return this.mergedManifest;
    }

    public static class ConfigAction
    extends TaskConfigAction<AndroidUnitTest> {
        private final VariantScope scope;

        public ConfigAction(VariantScope scope) {
            this.scope = (VariantScope)Preconditions.checkNotNull((Object)scope);
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("test");
        }

        @Override
        public Class<AndroidUnitTest> getType() {
            return AndroidUnitTest.class;
        }

        @Override
        public void execute(AndroidUnitTest runTestsTask) {
            TestVariantData variantData = (TestVariantData)this.scope.getVariantData();
            BaseVariantData testedVariantData = (BaseVariantData)((Object)variantData.getTestedVariantData());
            runTestsTask.systemProperty("java.awt.headless", "true");
            runTestsTask.setGroup("verification");
            runTestsTask.setDescription("Run unit tests for the " + testedVariantData.getVariantConfiguration().getFullName() + " build.");
            runTestsTask.setTestClassesDirs((FileCollection)this.scope.getArtifacts().getFinalArtifactFiles(AnchorOutputType.ALL_CLASSES).get());
            boolean includeAndroidResources = this.scope.getGlobalScope().getExtension().getTestOptions().getUnitTests().isIncludeAndroidResources();
            runTestsTask.setClasspath((FileCollection)this.computeClasspath(includeAndroidResources));
            runTestsTask.sdkPlatformDirPath = this.scope.getGlobalScope().getAndroidBuilder().getTarget().getLocation();
            VariantScope testedScope = testedVariantData.getScope();
            if (includeAndroidResources) {
                runTestsTask.assetsCollection = testedScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.MERGED_ASSETS);
                boolean enableBinaryResources = this.scope.getGlobalScope().getProjectOptions().get(BooleanOption.ENABLE_UNIT_TEST_BINARY_RESOURCES);
                if (enableBinaryResources) {
                    runTestsTask.resCollection = this.scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.APK_FOR_LOCAL_TEST);
                } else {
                    runTestsTask.resCollection = this.scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.MERGED_RES);
                }
            }
            runTestsTask.mergedManifest = testedScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.MERGED_MANIFESTS);
            TestTaskReports testTaskReports = runTestsTask.getReports();
            JUnitXmlReport xmlReport = testTaskReports.getJunitXml();
            xmlReport.setDestination(new File(this.scope.getGlobalScope().getTestResultsFolder(), runTestsTask.getName()));
            DirectoryReport htmlReport = testTaskReports.getHtml();
            htmlReport.setDestination(new File(this.scope.getGlobalScope().getTestReportFolder(), runTestsTask.getName()));
            this.scope.getGlobalScope().getExtension().getTestOptions().getUnitTests().applyConfiguration(runTestsTask);
        }

        private ConfigurableFileCollection computeClasspath(boolean includeAndroidResources) {
            ConfigurableFileCollection collection = this.scope.getGlobalScope().getProject().files(new Object[0]);
            BuildArtifactsHolder artifacts = this.scope.getArtifacts();
            if (includeAndroidResources) {
                collection.from(new Object[]{artifacts.getFinalArtifactFiles(InternalArtifactType.UNIT_TEST_CONFIG_DIRECTORY)});
            }
            collection.from(new Object[]{artifacts.getFinalArtifactFiles(AnchorOutputType.ALL_CLASSES).get()});
            collection.from(new Object[]{artifacts.getFinalArtifactFiles(InternalArtifactType.JAVA_RES)});
            collection.from(new Object[]{this.scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CLASSES)});
            collection.from(new Object[]{this.scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.JAVA_RES)});
            VariantScope testedScope = Objects.requireNonNull(this.scope.getTestedVariantData()).getScope();
            if (testedScope.getArtifacts().hasArtifact(InternalArtifactType.COMPILE_ONLY_NOT_NAMESPACED_R_CLASS_JAR)) {
                collection.from(new Object[]{testedScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.COMPILE_ONLY_NOT_NAMESPACED_R_CLASS_JAR)});
            }
            collection.from(new Object[]{this.scope.getGlobalScope().getProject().files(new Object[]{this.scope.getGlobalScope().getAndroidBuilder().computeAdditionalAndRequestedOptionalLibraries()})});
            collection.from(new Object[]{this.scope.getGlobalScope().getArtifacts().getFinalArtifactFiles(InternalArtifactType.MOCKABLE_JAR)});
            return collection;
        }
    }
}

