/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.crash;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.crash.PluginExceptionReport;
import com.android.builder.model.Version;
import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.crash.CrashReport;
import com.android.tools.analytics.crash.CrashReporter;
import com.android.tools.analytics.crash.GoogleCrashReporter;
import com.android.utils.ILogger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0007H\u0007J\u001a\u0010\u000f\u001a\u00020\t2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/crash/PluginCrashReporter;", "", "()V", "reporter", "Lcom/android/tools/analytics/crash/CrashReporter;", "getCrashReporter", "analyticsSettings", "Lcom/android/tools/analytics/AnalyticsSettings;", "forTest", "", "maybeReportException", "ex", "", "maybeReportExceptionForTest", "settings", "maybeReportExceptionImpl", "gradle"})
public final class PluginCrashReporter {
    private static final CrashReporter reporter;
    public static final PluginCrashReporter INSTANCE;

    @JvmStatic
    public static final boolean maybeReportException(@NotNull Throwable ex) {
        Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
        return INSTANCE.maybeReportExceptionImpl(reporter, ex);
    }

    public final boolean maybeReportExceptionForTest(@NotNull Throwable ex, @NotNull AnalyticsSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        CrashReporter crashReporter = this.getCrashReporter(settings, true);
        return this.maybeReportExceptionImpl(crashReporter, ex);
    }

    private final CrashReporter getCrashReporter(AnalyticsSettings analyticsSettings, boolean forTest) {
        CrashReporter crashReporter;
        if (analyticsSettings.getOptedIn()) {
            String string = Version.ANDROID_GRADLE_PLUGIN_VERSION;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Version.ANDROID_GRADLE_PLUGIN_VERSION");
            boolean isDebugBuild = StringsKt.endsWith$default((String)string, (String)"-dev", (boolean)false, (int)2, null);
            crashReporter = (CrashReporter)new GoogleCrashReporter(false, isDebugBuild || forTest);
        } else {
            crashReporter = null;
        }
        return crashReporter;
    }

    static /* bridge */ /* synthetic */ CrashReporter getCrashReporter$default(PluginCrashReporter pluginCrashReporter, AnalyticsSettings analyticsSettings, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return pluginCrashReporter.getCrashReporter(analyticsSettings, bl);
    }

    private final boolean maybeReportExceptionImpl(CrashReporter reporter, Throwable ex) {
        if (reporter == null) {
            return false;
        }
        PluginExceptionReport pluginExceptionReport = PluginExceptionReport.Companion.create(ex);
        if (pluginExceptionReport != null) {
            PluginExceptionReport pluginExceptionReport2;
            PluginExceptionReport it = pluginExceptionReport2 = pluginExceptionReport;
            reporter.submit((CrashReport)it);
            return true;
        }
        return false;
    }

    private PluginCrashReporter() {
    }

    static {
        PluginCrashReporter pluginCrashReporter;
        INSTANCE = pluginCrashReporter = new PluginCrashReporter();
        LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(PluginCrashReporter.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)loggerWrapper, (String)"LoggerWrapper.getLogger(\u2026rashReporter::class.java)");
        reporter = PluginCrashReporter.getCrashReporter$default(pluginCrashReporter, AnalyticsSettings.Companion.getInstance((ILogger)loggerWrapper), false, 2, null);
    }
}

