/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.core.VariantConfiguration;
import com.android.build.gradle.internal.dependency.ArtifactCollectionWithExtraArtifact;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.ModuleMetadata;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSetMetadata;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.AnnotationProcessingTaskConfigAction;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.dexing.DexingType;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.ProductFlavor;
import com.android.ide.common.build.ApkData;
import com.android.ide.common.build.ApkInfo;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.ManifestProvider;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlDocument;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.internal.component.local.model.OpaqueComponentArtifactIdentifier;

@CacheableTask
public class ProcessApplicationManifest
extends ManifestProcessorTask {
    private Supplier<String> minSdkVersion;
    private Supplier<String> targetSdkVersion;
    private Supplier<Integer> maxSdkVersion;
    private VariantConfiguration<CoreBuildType, CoreProductFlavor, CoreProductFlavor> variantConfiguration;
    private ArtifactCollection manifests;
    private BuildableArtifact autoNamespacedManifests;
    private ArtifactCollection featureManifests;
    private FileCollection microApkManifest;
    private BuildableArtifact compatibleScreensManifest;
    private FileCollection packageManifest;
    private BuildableArtifact apkList;
    private Supplier<EnumSet<ManifestMerger2.Invoker.Feature>> optionalFeatures;
    private OutputScope outputScope;
    private Supplier<String> featureNameSupplier = null;

    @Override
    protected void doFullTaskAction() throws IOException {
        BuildElements compatibleScreenManifests = ExistingBuildElements.from((ArtifactType)InternalArtifactType.COMPATIBLE_SCREEN_MANIFEST, this.compatibleScreensManifest);
        ModuleMetadata moduleMetadata = null;
        if (this.packageManifest != null && !this.packageManifest.isEmpty()) {
            moduleMetadata = ModuleMetadata.load(this.packageManifest.getSingleFile());
            boolean isDebuggable = this.optionalFeatures.get().contains(ManifestMerger2.Invoker.Feature.DEBUGGABLE);
            if (moduleMetadata.getDebuggable() != isDebuggable) {
                String moduleType = this.variantConfiguration.getType().isHybrid() ? "Instant App Feature" : "Dynamic Feature";
                String errorMessage = String.format("%1$s '%2$s' (build type '%3$s') %4$s debuggable,\nand the corresponding build type in the base application %5$s debuggable.\nRecommendation: \n   in  %6$s\n   set android.buildTypes.%3$s.debuggable = %7$s", moduleType, this.getProject().getPath(), this.variantConfiguration.getBuildType().getName(), isDebuggable ? "is" : "is not", moduleMetadata.getDebuggable() ? "is" : "is not", this.getProject().getBuildFile(), moduleMetadata.getDebuggable() ? "true" : "false");
                throw new InvalidUserDataException(errorMessage);
            }
        }
        ImmutableList.Builder mergedManifestOutputs = ImmutableList.builder();
        ImmutableList.Builder irMergedManifestOutputs = ImmutableList.builder();
        for (ApkData apkData : this.outputScope.getApkDatas()) {
            BuildOutput compatibleScreenManifestForSplit = compatibleScreenManifests.element((ApkInfo)apkData);
            File manifestOutputFile = new File(((Directory)this.getManifestOutputDirectory().get()).getAsFile(), FileUtils.join((String[])new String[]{apkData.getDirName(), "AndroidManifest.xml"}));
            File instantRunManifestOutputFile = FileUtils.join((File)this.getInstantRunManifestOutputDirectory(), (String[])new String[]{apkData.getDirName(), "AndroidManifest.xml"});
            MergingReport mergingReport = this.getBuilder().mergeManifestsForApplication(this.getMainManifest(), this.getManifestOverlays(), this.computeFullProviderList(compatibleScreenManifestForSplit), this.getNavigationFiles(), this.getFeatureName(), moduleMetadata == null ? this.getPackageOverride() : moduleMetadata.getApplicationId(), moduleMetadata == null ? apkData.getVersionCode() : Integer.parseInt(moduleMetadata.getVersionCode()), moduleMetadata == null ? apkData.getVersionName() : moduleMetadata.getVersionName(), this.getMinSdkVersion(), this.getTargetSdkVersion(), this.getMaxSdkVersion(), manifestOutputFile.getAbsolutePath(), null, instantRunManifestOutputFile.getAbsolutePath(), ManifestMerger2.MergeType.APPLICATION, this.variantConfiguration.getManifestPlaceholders(), this.getOptionalFeatures(), this.getReportFile());
            XmlDocument mergedXmlDocument = mergingReport.getMergedXmlDocument(MergingReport.MergedManifestKind.MERGED);
            ImmutableMap properties = mergedXmlDocument != null ? ImmutableMap.of((Object)"packageId", (Object)mergedXmlDocument.getPackageName(), (Object)"split", (Object)mergedXmlDocument.getSplitName(), (Object)"minSdkVersion", (Object)mergedXmlDocument.getMinSdkVersion()) : ImmutableMap.of();
            mergedManifestOutputs.add((Object)new BuildOutput((ArtifactType)InternalArtifactType.MERGED_MANIFESTS, (ApkInfo)apkData, manifestOutputFile, (Map<String, String>)properties));
            irMergedManifestOutputs.add((Object)new BuildOutput((ArtifactType)InternalArtifactType.INSTANT_RUN_MERGED_MANIFESTS, (ApkInfo)apkData, instantRunManifestOutputFile, (Map<String, String>)properties));
        }
        new BuildElements((Collection<BuildOutput>)mergedManifestOutputs.build()).save(((Directory)this.getManifestOutputDirectory().get()).getAsFile());
        new BuildElements((Collection<BuildOutput>)irMergedManifestOutputs.build()).save(this.getInstantRunManifestOutputDirectory());
    }

    @Override
    @Internal
    public File getAaptFriendlyManifestOutputFile() {
        return null;
    }

    @Optional
    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getMainManifest() {
        return this.variantConfiguration.getMainManifest();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public List<File> getManifestOverlays() {
        return this.variantConfiguration.getManifestOverlays();
    }

    @Input
    @Optional
    public String getPackageOverride() {
        return this.variantConfiguration.getIdOverride();
    }

    @Input
    public List<Integer> getVersionCodes() {
        return this.outputScope.getApkDatas().stream().map(ApkData::getVersionCode).collect(Collectors.toList());
    }

    @Input
    @Optional
    public List<String> getVersionNames() {
        return this.outputScope.getApkDatas().stream().map(ApkData::getVersionName).collect(Collectors.toList());
    }

    @Input
    @Optional
    public String getManifestPlaceholders() {
        return ProcessApplicationManifest.serializeMap(this.variantConfiguration.getManifestPlaceholders());
    }

    private List<ManifestProvider> computeFullProviderList(BuildOutput compatibleScreenManifestForSplit) {
        Object microManifest;
        Set artifacts = this.manifests.getArtifacts();
        ArrayList providers = Lists.newArrayListWithCapacity((int)(artifacts.size() + 2));
        for (ResolvedArtifactResult artifact : artifacts) {
            providers.add(new ConfigAction.ManifestProviderImpl(artifact.getFile(), ProcessApplicationManifest.getArtifactName(artifact)));
        }
        if (this.microApkManifest != null && ((File)(microManifest = this.microApkManifest.getSingleFile())).isFile()) {
            providers.add(new ConfigAction.ManifestProviderImpl((File)microManifest, "Wear App sub-manifest"));
        }
        if (compatibleScreenManifestForSplit != null) {
            providers.add(new ConfigAction.ManifestProviderImpl(compatibleScreenManifestForSplit.getOutputFile(), "Compatible-Screens sub-manifest"));
        }
        if (this.autoNamespacedManifests != null) {
            for (File autoNamespacedManifest : this.autoNamespacedManifests.getFiles()) {
                providers.add(new ConfigAction.ManifestProviderImpl(autoNamespacedManifest, ProcessApplicationManifest.getNameFromAutoNamespacedManifest(autoNamespacedManifest)));
            }
        }
        if (this.featureManifests != null) {
            Set featureArtifacts = this.featureManifests.getArtifacts();
            for (ResolvedArtifactResult artifact : featureArtifacts) {
                File directory = artifact.getFile();
                BuildElements splitOutputs = ExistingBuildElements.from((ArtifactType)InternalArtifactType.MERGED_MANIFESTS, directory);
                if (splitOutputs.isEmpty()) {
                    throw new GradleException("Could not load manifest from " + directory);
                }
                providers.add(new ConfigAction.ManifestProviderImpl(splitOutputs.iterator().next().getOutputFile(), ProcessApplicationManifest.getArtifactName(artifact)));
            }
        }
        return providers;
    }

    @Internal
    private static String getNameFromAutoNamespacedManifest(File manifest) {
        String manifestSuffix = "_AndroidManifest.xml";
        String fileName = manifest.getName();
        if (!fileName.endsWith("_AndroidManifest.xml")) {
            throw new RuntimeException("Invalid auto-namespaced manifest file: " + manifest.getAbsolutePath());
        }
        return fileName.substring(0, fileName.length() - "_AndroidManifest.xml".length());
    }

    @Internal
    public static String getArtifactName(ResolvedArtifactResult artifact) {
        ComponentIdentifier id = artifact.getId().getComponentIdentifier();
        if (id instanceof ProjectComponentIdentifier) {
            return ((ProjectComponentIdentifier)id).getProjectPath();
        }
        if (id instanceof ModuleComponentIdentifier) {
            ModuleComponentIdentifier mID = (ModuleComponentIdentifier)id;
            return mID.getGroup() + ":" + mID.getModule() + ":" + mID.getVersion();
        }
        if (id instanceof OpaqueComponentArtifactIdentifier) {
            return id.getDisplayName();
        }
        if (id instanceof ArtifactCollectionWithExtraArtifact.ExtraComponentIdentifier) {
            return id.getDisplayName();
        }
        throw new RuntimeException("Unsupported type of ComponentIdentifier");
    }

    @Input
    @Optional
    public String getMinSdkVersion() {
        return this.minSdkVersion.get();
    }

    @Input
    @Optional
    public String getTargetSdkVersion() {
        return this.targetSdkVersion.get();
    }

    @Input
    @Optional
    public Integer getMaxSdkVersion() {
        return this.maxSdkVersion.get();
    }

    @Internal
    public EnumSet<ManifestMerger2.Invoker.Feature> getOptionalFeatures() {
        return this.optionalFeatures.get();
    }

    @Input
    public List<String> getOptionalFeaturesString() {
        return this.getOptionalFeatures().stream().map(Enum::toString).collect(Collectors.toList());
    }

    @Internal
    public VariantConfiguration getVariantConfiguration() {
        return this.variantConfiguration;
    }

    public void setVariantConfiguration(VariantConfiguration<CoreBuildType, CoreProductFlavor, CoreProductFlavor> variantConfiguration) {
        this.variantConfiguration = variantConfiguration;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getManifests() {
        return this.manifests.getArtifactFiles();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public List<File> getNavigationFiles() {
        return this.variantConfiguration.getNavigationFiles();
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getFeatureManifests() {
        if (this.featureManifests == null) {
            return null;
        }
        return this.featureManifests.getArtifactFiles();
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getMicroApkManifest() {
        return this.microApkManifest;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public BuildableArtifact getCompatibleScreensManifest() {
        return this.compatibleScreensManifest;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getPackageManifest() {
        return this.packageManifest;
    }

    @Input
    @Optional
    public String getFeatureName() {
        return this.featureNameSupplier != null ? this.featureNameSupplier.get() : null;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public BuildableArtifact getApkList() {
        return this.apkList;
    }

    private static EnumSet<ManifestMerger2.Invoker.Feature> getOptionalFeatures(VariantScope variantScope, boolean isAdvancedProfilingOn) {
        ArrayList<ManifestMerger2.Invoker.Feature> features = new ArrayList<ManifestMerger2.Invoker.Feature>();
        VariantType variantType = variantScope.getType();
        if (variantType.isHybrid()) {
            features.add(ManifestMerger2.Invoker.Feature.TARGET_SANDBOX_VERSION);
        }
        if (variantType.isFeatureSplit()) {
            features.add(ManifestMerger2.Invoker.Feature.ADD_FEATURE_SPLIT_ATTRIBUTE);
        }
        if (variantType.isInstantAppFeatureSplit()) {
            features.add(ManifestMerger2.Invoker.Feature.ADD_INSTANT_APP_FEATURE_SPLIT_INFO);
        }
        if (variantScope.isTestOnly()) {
            features.add(ManifestMerger2.Invoker.Feature.TEST_ONLY);
        }
        if (((CoreBuildType)variantScope.getVariantConfiguration().getBuildType()).isDebuggable()) {
            features.add(ManifestMerger2.Invoker.Feature.DEBUGGABLE);
            if (isAdvancedProfilingOn) {
                features.add(ManifestMerger2.Invoker.Feature.ADVANCED_PROFILING);
            }
        }
        if (variantScope.getInstantRunBuildContext().isInInstantRunMode()) {
            features.add(ManifestMerger2.Invoker.Feature.INSTANT_RUN_REPLACEMENT);
        }
        if (variantScope.getVariantConfiguration().getDexingType() == DexingType.LEGACY_MULTIDEX) {
            if (variantScope.getGlobalScope().getProjectOptions().get(BooleanOption.USE_ANDROID_X)) {
                features.add(ManifestMerger2.Invoker.Feature.ADD_ANDROIDX_MULTIDEX_APPLICATION_IF_NO_NAME);
            } else {
                features.add(ManifestMerger2.Invoker.Feature.ADD_SUPPORT_MULTIDEX_APPLICATION_IF_NO_NAME);
            }
        }
        return features.isEmpty() ? EnumSet.noneOf(ManifestMerger2.Invoker.Feature.class) : EnumSet.copyOf(features);
    }

    public static class ConfigAction
    extends AnnotationProcessingTaskConfigAction<ProcessApplicationManifest> {
        protected final VariantScope variantScope;
        protected final boolean isAdvancedProfilingOn;
        private Provider<Directory> manifestOutputFolder;

        public ConfigAction(VariantScope scope, boolean isAdvancedProfilingOn) {
            super(scope, scope.getTaskName("process", "Manifest"), ProcessApplicationManifest.class);
            this.variantScope = scope;
            this.isAdvancedProfilingOn = isAdvancedProfilingOn;
        }

        @Override
        public void execute(ProcessApplicationManifest processManifestTask) {
            super.execute(processManifestTask);
            BaseVariantData variantData = this.variantScope.getVariantData();
            GradleVariantConfiguration config2 = variantData.getVariantConfiguration();
            GlobalScope globalScope = this.variantScope.getGlobalScope();
            AndroidBuilder androidBuilder = globalScope.getAndroidBuilder();
            VariantType variantType = this.variantScope.getType();
            Preconditions.checkState((!variantType.isTestComponent() ? 1 : 0) != 0);
            processManifestTask.setAndroidBuilder(androidBuilder);
            processManifestTask.setVariantName(config2.getFullName());
            processManifestTask.outputScope = variantData.getOutputScope();
            processManifestTask.setVariantConfiguration(config2);
            Project project = globalScope.getProject();
            processManifestTask.manifests = this.variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.MANIFEST);
            if (this.variantScope.getArtifacts().hasArtifact(InternalArtifactType.NAMESPACED_MANIFESTS)) {
                processManifestTask.autoNamespacedManifests = this.variantScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.NAMESPACED_MANIFESTS);
            }
            if (this.variantScope.getTaskContainer().getMicroApkTask() != null && ((CoreBuildType)config2.getBuildType()).isEmbedMicroApp()) {
                processManifestTask.microApkManifest = (FileCollection)project.files(new Object[]{this.variantScope.getMicroApkManifestFile()});
            }
            BuildArtifactsHolder artifacts = this.variantScope.getArtifacts();
            processManifestTask.compatibleScreensManifest = artifacts.getFinalArtifactFiles(InternalArtifactType.COMPATIBLE_SCREEN_MANIFEST);
            processManifestTask.minSdkVersion = TaskInputHelper.memoize(() -> {
                ApiVersion minSdk = config2.getMergedFlavor().getMinSdkVersion();
                return minSdk == null ? null : minSdk.getApiString();
            });
            processManifestTask.targetSdkVersion = TaskInputHelper.memoize(() -> {
                ApiVersion targetSdk = config2.getMergedFlavor().getTargetSdkVersion();
                return targetSdk == null ? null : targetSdk.getApiString();
            });
            processManifestTask.maxSdkVersion = TaskInputHelper.memoize(() -> ((ProductFlavor)config2.getMergedFlavor()).getMaxSdkVersion());
            processManifestTask.setInstantRunManifestOutputDirectory(artifacts.appendArtifact((ArtifactType)InternalArtifactType.INSTANT_RUN_MERGED_MANIFESTS, (Task)processManifestTask, "instant-run"));
            File reportFile = FileUtils.join((File)this.variantScope.getGlobalScope().getOutputsDir(), (String[])new String[]{"logs", "manifest-merger-" + this.variantScope.getVariantConfiguration().getBaseName() + "-report.txt"});
            processManifestTask.setReportFile(reportFile);
            processManifestTask.optionalFeatures = TaskInputHelper.memoize(() -> ProcessApplicationManifest.getOptionalFeatures(this.variantScope, this.isAdvancedProfilingOn));
            processManifestTask.apkList = artifacts.getFinalArtifactFiles(InternalArtifactType.APK_LIST);
            if (variantType.isBaseModule()) {
                processManifestTask.packageManifest = this.variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.METADATA_VALUES, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.METADATA_BASE_MODULE_DECLARATION);
                processManifestTask.featureManifests = this.variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.METADATA_VALUES, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.METADATA_FEATURE_MANIFEST);
            } else if (variantType.isFeatureSplit()) {
                processManifestTask.featureNameSupplier = FeatureSetMetadata.getInstance().getFeatureNameSupplierForTask(this.variantScope, (Task)processManifestTask);
                processManifestTask.packageManifest = this.variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.FEATURE_APPLICATION_ID_DECLARATION);
            }
            this.variantScope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.MANIFEST_MERGE_REPORT, (Collection<? extends Object>)ImmutableList.of((Object)reportFile), (Task)processManifestTask);
            if (variantType.isFeatureSplit()) {
                artifacts.appendArtifact((ArtifactType)InternalArtifactType.METADATA_FEATURE_MANIFEST, artifacts.getFinalArtifactFiles(InternalArtifactType.MERGED_MANIFESTS));
            }
            artifacts.appendArtifact((ArtifactType)InternalArtifactType.MANIFEST_METADATA, artifacts.getFinalArtifactFiles(InternalArtifactType.MERGED_MANIFESTS));
            this.variantScope.getTaskContainer().setProcessManifestTask(processManifestTask);
        }

        public static class ManifestProviderImpl
        implements ManifestProvider {
            private final File manifest;
            private final String name;

            public ManifestProviderImpl(File manifest, String name) {
                this.manifest = manifest;
                this.name = name;
            }

            public File getManifest() {
                return this.manifest;
            }

            public String getName() {
                return this.name;
            }
        }
    }
}

