/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.BuildInfoWriterTask;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunVerifierStatus;
import com.android.build.gradle.internal.scope.InstantRunVariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.factory.EagerTaskCreationAction;
import com.android.builder.packaging.PackagingUtils;
import com.android.utils.FileUtils;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import java.io.File;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.TaskAction;

public class BuildInfoLoaderTask
extends AndroidVariantTask {
    File pastBuildsFolder;
    File buildInfoFile;
    File tmpBuildInfoFile;
    Logger logger;
    InstantRunBuildContext buildContext;

    @TaskAction
    public void executeAction() {
        try {
            if (this.buildInfoFile.exists()) {
                this.buildContext.loadFromXmlFile(this.buildInfoFile);
            } else {
                this.buildContext.setVerifierStatus(InstantRunVerifierStatus.INITIAL_BUILD);
            }
            long token = this.buildContext.getSecretToken();
            if (token == 0L) {
                token = PackagingUtils.computeApplicationHash((File)this.getProject().getBuildDir());
                this.buildContext.setSecretToken(token);
            }
            if (this.tmpBuildInfoFile.exists()) {
                this.buildContext.mergeFromFile(this.tmpBuildInfoFile);
                FileUtils.delete((File)this.tmpBuildInfoFile);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Exception while loading build-info.xml : %s", Throwables.getStackTraceAsString((Throwable)e)));
        }
        try {
            InstantRunBuildContext.Build lastBuild = this.buildContext.getLastBuild();
            if (lastBuild == null) {
                return;
            }
            File backupFolder = new File(this.pastBuildsFolder, String.valueOf(lastBuild.getBuildId()));
            FileUtils.mkdirs((File)backupFolder);
            for (InstantRunBuildContext.Artifact artifact : lastBuild.getArtifacts()) {
                if (artifact.isAccumulative()) continue;
                File oldLocation = artifact.getLocation();
                if (!oldLocation.isFile()) {
                    return;
                }
                File newLocation = new File(backupFolder, oldLocation.getName());
                if (this.logger.isEnabled(LogLevel.DEBUG)) {
                    this.logger.debug(String.format("File moved from %1$s to %2$s", oldLocation.getPath(), newLocation.getPath()));
                }
                Files.copy((File)oldLocation, (File)newLocation);
                artifact.setLocation(newLocation);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Exception while doing past iteration backup : %s", e.getMessage()));
        }
    }

    public static class CreationAction
    extends EagerTaskCreationAction<BuildInfoLoaderTask> {
        private final String taskName;
        private final InstantRunVariantScope variantScope;
        private final Logger logger;

        public CreationAction(InstantRunVariantScope scope, Logger logger) {
            this.taskName = scope.getTransformVariantScope().getTaskName("buildInfo", "Loader");
            this.variantScope = scope;
            this.logger = logger;
        }

        @Override
        public String getName() {
            return this.taskName;
        }

        @Override
        public Class<BuildInfoLoaderTask> getType() {
            return BuildInfoLoaderTask.class;
        }

        @Override
        public void execute(BuildInfoLoaderTask task) {
            task.setDescription("InstantRun task to load and backup previous iterations artifacts");
            task.setVariantName(this.variantScope.getFullVariantName());
            task.buildInfoFile = BuildInfoWriterTask.CreationAction.getBuildInfoFile(this.variantScope);
            task.tmpBuildInfoFile = BuildInfoWriterTask.CreationAction.getTmpBuildInfoFile(this.variantScope);
            task.pastBuildsFolder = this.variantScope.getInstantRunPastIterationsFolder();
            task.buildContext = this.variantScope.getInstantRunBuildContext();
            task.logger = this.logger;
        }
    }
}

