/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.ProguardFiles;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.factory.EagerTaskCreationAction;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;

public class CheckProguardFiles
extends DefaultTask {
    private List<File> proguardFiles;

    @TaskAction
    public void run() {
        HashMap<File, ProguardFiles.ProguardFile> oldFiles = new HashMap<File, ProguardFiles.ProguardFile>();
        oldFiles.put(ProguardFiles.getDefaultProguardFile(ProguardFiles.ProguardFile.OPTIMIZE.fileName, this.getProject()).getAbsoluteFile(), ProguardFiles.ProguardFile.OPTIMIZE);
        oldFiles.put(ProguardFiles.getDefaultProguardFile(ProguardFiles.ProguardFile.DONT_OPTIMIZE.fileName, this.getProject()).getAbsoluteFile(), ProguardFiles.ProguardFile.DONT_OPTIMIZE);
        for (File file : this.proguardFiles) {
            if (!oldFiles.containsKey(file.getAbsoluteFile())) continue;
            String name = ((ProguardFiles.ProguardFile)((Object)oldFiles.get((Object)file.getAbsoluteFile()))).fileName;
            throw new InvalidUserDataException(name + " should not be used together with the new postprocessing DSL. The new DSL includes sensible settings by default, you can override this using `postprocessing { proguardFiles = []}`");
        }
    }

    @InputFiles
    public List<File> getProguardFiles() {
        return this.proguardFiles;
    }

    public static class CreationAction
    extends EagerTaskCreationAction<CheckProguardFiles> {
        private final VariantScope scope;

        public CreationAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("check", "ProguardFiles");
        }

        @Override
        public Class<CheckProguardFiles> getType() {
            return CheckProguardFiles.class;
        }

        @Override
        public void execute(CheckProguardFiles task) {
            task.proguardFiles = this.scope.getProguardFiles();
        }
    }
}

