/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.incremental.FileType;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.tasks.PackageAndroidArtifact;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.builder.utils.FileCache;
import com.google.wireless.android.sdk.stats.GradleBuildProjectMetrics;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.tasks.Internal;

public class PackageApplication
extends PackageAndroidArtifact {
    InternalArtifactType expectedOutputType;

    @Override
    @Internal
    protected InternalArtifactType getInternalArtifactType() {
        return this.expectedOutputType;
    }

    @Override
    @Internal
    protected boolean isIncremental() {
        return true;
    }

    @Override
    void recordMetrics(File apkOutputFile, File resourcesApFile) {
        Long resourcesApSize;
        long metricsStartTime = System.nanoTime();
        GradleBuildProjectMetrics.Builder metrics = GradleBuildProjectMetrics.newBuilder();
        Long apkSize = PackageApplication.getSize(apkOutputFile);
        if (apkSize != null) {
            metrics.setApkSize(apkSize.longValue());
        }
        if ((resourcesApSize = PackageApplication.getSize(resourcesApFile)) != null) {
            metrics.setResourcesApSize(resourcesApSize.longValue());
        }
        metrics.setMetricsTimeNs(System.nanoTime() - metricsStartTime);
        ProcessProfileWriter.getProject((String)this.getProject().getPath()).setMetrics(metrics);
    }

    @Internal
    private static Long getSize(File file) {
        if (file == null) {
            return null;
        }
        try {
            return Files.size(file.toPath());
        }
        catch (IOException e) {
            return null;
        }
    }

    public static class InstantRunResourcesCreationAction
    extends PackageAndroidArtifact.CreationAction<PackageApplication> {
        private final File mOutputFile;

        public InstantRunResourcesCreationAction(File outputFile, VariantScope scope, InternalArtifactType inputResourceFilesType, BuildableArtifact manifests, InternalArtifactType manifestType, FileCache fileCache, OutputScope outputScope) {
            super(scope, outputFile.getParentFile(), inputResourceFilesType, manifests, manifestType, fileCache, outputScope);
            this.mOutputFile = outputFile;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("packageInstantRunResources");
        }

        @Override
        public Class<PackageApplication> getType() {
            return PackageApplication.class;
        }

        @Override
        protected void configure(PackageApplication packageApplication) {
            packageApplication.expectedOutputType = InternalArtifactType.INSTANT_RUN_PACKAGED_RESOURCES;
            packageApplication.instantRunFileType = FileType.RESOURCES;
            ConfigurableFileCollection emptyCollection = this.variantScope.getGlobalScope().getProject().files(new Object[0]);
            packageApplication.dexFolders = emptyCollection;
            packageApplication.jniFolders = emptyCollection;
            packageApplication.javaResourceFiles = emptyCollection;
            packageApplication.apkList = this.variantScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.APK_LIST);
            packageApplication.setSigningConfig(null);
            packageApplication.outputFileProvider = split -> this.mOutputFile;
        }
    }

    public static class StandardCreationAction
    extends PackageAndroidArtifact.CreationAction<PackageApplication> {
        private final InternalArtifactType expectedOutputType;

        public StandardCreationAction(VariantScope packagingScope, File outputDirectory, InternalArtifactType inputResourceFilesType, BuildableArtifact manifests, InternalArtifactType manifestType, OutputScope outputScope, FileCache fileCache, InternalArtifactType expectedOutputType) {
            super(packagingScope, outputDirectory, inputResourceFilesType, manifests, manifestType, fileCache, outputScope);
            this.expectedOutputType = expectedOutputType;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("package");
        }

        @Override
        public Class<PackageApplication> getType() {
            return PackageApplication.class;
        }

        @Override
        protected void configure(PackageApplication task) {
            super.configure(task);
            task.expectedOutputType = this.expectedOutputType;
        }
    }
}

