/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.factory.LazyTaskCreationAction;
import com.android.builder.model.SourceProvider;
import java.io.File;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskProvider;

public class ProcessJavaResCreationAction
extends LazyTaskCreationAction<Sync> {
    private VariantScope scope;
    private final File destinationDir;

    public ProcessJavaResCreationAction(VariantScope scope, File destinationDir) {
        this.scope = scope;
        this.destinationDir = destinationDir;
    }

    @Override
    public String getName() {
        return this.scope.getTaskName("process", "JavaRes");
    }

    @Override
    public Class<Sync> getType() {
        return Sync.class;
    }

    @Override
    public void handleProvider(TaskProvider<? extends Sync> taskProvider) {
        super.handleProvider(taskProvider);
        this.scope.getTaskContainer().setProcessJavaResourcesTask(taskProvider);
    }

    @Override
    public void configure(Sync task) {
        for (SourceProvider sourceProvider : this.scope.getVariantConfiguration().getSortedSourceProviders()) {
            task.from(new Object[]{((AndroidSourceSet)sourceProvider).getResources().getSourceFiles()});
        }
        task.setDestinationDir(this.destinationDir);
        task.dependsOn(new Object[]{this.scope.getTaskContainer().getPreBuildTask()});
    }
}

