/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunVerifierStatus;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.factory.LazyTaskCreationAction;
import com.android.ide.common.build.ApkInfo;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;

public class CheckManifestInInstantRunMode
extends AndroidVariantTask {
    private static final Logger LOG = Logging.getLogger(CheckManifestInInstantRunMode.class);
    private InstantRunBuildContext buildContext;
    private File manifestCheckerDir;
    private BuildableArtifact instantRunManifests;
    private BuildableArtifact processedRes;
    private InternalArtifactType resInputType;

    @Input
    public InternalArtifactType getResourcesInputType() {
        return this.resInputType;
    }

    @InputFiles
    public BuildableArtifact getInstantRunManifests() {
        return this.instantRunManifests;
    }

    @InputFiles
    public BuildableArtifact getProcessedRes() {
        return this.processedRes;
    }

    @TaskAction
    public void checkManifestChanges() throws IOException {
        if (!this.buildContext.isInInstantRunMode()) {
            LOG.warn("CheckManifestInInstantRunMode configured in non instant run build, please file a bug.");
            return;
        }
        if (this.instantRunManifests.getFiles().isEmpty()) {
            String message = "No instant run specific merged manifests in InstantRun mode, please file a bug and disable InstantRun.";
            LOG.error(message);
            throw new RuntimeException(message);
        }
        if (this.instantRunManifests.getFiles().size() > 1) {
            String message = "Full Split are not supported in InstantRun mode, please disable InstantRun";
            LOG.error(message);
            throw new RuntimeException(message);
        }
        BuildElements processedResOutputs = ExistingBuildElements.from((ArtifactType)this.resInputType, this.processedRes);
        for (BuildOutput buildOutput : ExistingBuildElements.from((ArtifactType)InternalArtifactType.INSTANT_RUN_MERGED_MANIFESTS, this.instantRunManifests)) {
            ApkInfo apkInfo = buildOutput.getApkInfo();
            File mergedManifest = buildOutput.getOutputFile();
            LOG.info("CheckManifestInInstantRunMode : Merged manifest %1$s", (Object)mergedManifest);
            CheckManifestInInstantRunMode.runManifestChangeVerifier(this.buildContext, this.manifestCheckerDir, mergedManifest);
            BuildOutput processedResOutput = processedResOutputs.element(apkInfo);
            if (processedResOutput == null) {
                throw new RuntimeException("Cannot find processed resources for " + apkInfo + " split in " + Joiner.on((String)",").join(processedResOutputs.getElements()));
            }
            File resourcesApk = processedResOutput.getOutputFile();
            LOG.info("CheckManifestInInstantRunMode : Resource APK %1$s", (Object)resourcesApk);
            if (!resourcesApk.exists()) continue;
            CheckManifestInInstantRunMode.runManifestBinaryChangeVerifier(this.buildContext, this.manifestCheckerDir, resourcesApk);
        }
    }

    static void runManifestChangeVerifier(InstantRunBuildContext buildContext, File instantRunSupportDir, File manifestFileToPackage) throws IOException {
        File previousManifestFile = new File(instantRunSupportDir, "manifest.xml");
        if (previousManifestFile.exists()) {
            String previousManifest;
            String currentManifest = Files.asCharSource((File)manifestFileToPackage, (Charset)Charsets.UTF_8).read();
            if (!currentManifest.equals(previousManifest = Files.asCharSource((File)previousManifestFile, (Charset)Charsets.UTF_8).read())) {
                buildContext.setVerifierStatus(InstantRunVerifierStatus.MANIFEST_FILE_CHANGE);
                Files.copy((File)manifestFileToPackage, (File)previousManifestFile);
            }
        } else {
            Files.createParentDirs((File)previousManifestFile);
            Files.copy((File)manifestFileToPackage, (File)previousManifestFile);
            buildContext.setVerifierStatus(InstantRunVerifierStatus.INITIAL_BUILD);
        }
    }

    static void runManifestBinaryChangeVerifier(InstantRunBuildContext buildContext, File instantRunSupportDir, File resOutBaseNameFile) throws IOException {
        String currentIterationCRC = null;
        try (JarFile jarFile = new JarFile(resOutBaseNameFile);){
            ZipEntry entry = jarFile.getEntry("AndroidManifest.xml");
            if (entry != null) {
                currentIterationCRC = String.valueOf(entry.getCrc());
            }
        }
        File crcFile = new File(instantRunSupportDir, "manifest.crc");
        if (crcFile.exists() && currentIterationCRC != null) {
            String previousIterationCRC = Files.asCharSource((File)crcFile, (Charset)Charsets.UTF_8).readFirstLine();
            if (!currentIterationCRC.equals(previousIterationCRC)) {
                buildContext.setVerifierStatus(InstantRunVerifierStatus.BINARY_MANIFEST_FILE_CHANGE);
            }
        } else {
            buildContext.setVerifierStatus(InstantRunVerifierStatus.INITIAL_BUILD);
        }
        if (currentIterationCRC != null) {
            Files.createParentDirs((File)crcFile);
            Files.asCharSink((File)crcFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)currentIterationCRC);
        }
    }

    public static class CreationAction
    extends LazyTaskCreationAction<CheckManifestInInstantRunMode> {
        protected final VariantScope variantScope;

        public CreationAction(VariantScope variantScope) {
            this.variantScope = variantScope;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("checkManifestChanges");
        }

        @Override
        public Class<CheckManifestInInstantRunMode> getType() {
            return CheckManifestInInstantRunMode.class;
        }

        @Override
        public void configure(CheckManifestInInstantRunMode task) {
            task.instantRunManifests = this.variantScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.INSTANT_RUN_MERGED_MANIFESTS);
            task.resInputType = this.variantScope.getInstantRunBuildContext().useSeparateApkForResources() ? InternalArtifactType.INSTANT_RUN_MAIN_APK_RESOURCES : InternalArtifactType.PROCESSED_RES;
            task.processedRes = this.variantScope.getArtifacts().getFinalArtifactFiles(task.resInputType);
            task.buildContext = this.variantScope.getInstantRunBuildContext();
            task.manifestCheckerDir = this.variantScope.getManifestCheckerDir();
            task.setVariantName(this.variantScope.getFullVariantName());
        }
    }
}

