/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.api.AnnotationProcessorOptions;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidBuilderTask;
import com.android.build.gradle.internal.tasks.factory.LazyTaskCreationAction;
import com.android.utils.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class JavaPreCompileTask
extends AndroidBuilderTask {
    static final String DATA_BINDING_SPEC = "android.databinding.DataBinding";
    private static final String PROCESSOR_SERVICES = "META-INF/services/javax.annotation.processing.Processor";
    private File processorListFile;
    private String annotationProcessorConfigurationName;
    private ArtifactCollection annotationProcessorConfiguration;
    private ArtifactCollection compileClasspaths;
    private AnnotationProcessorOptions annotationProcessorOptions;
    private boolean isTestComponent;
    private boolean dataBindingEnabled;

    void init(File processorListFile, String annotationProcessorConfigurationName, ArtifactCollection annotationProcessorConfiguration, ArtifactCollection compileClasspaths, AnnotationProcessorOptions annotationProcessorOptions, boolean isTestComponent, boolean dataBindingEnabled) {
        this.processorListFile = processorListFile;
        this.annotationProcessorConfigurationName = annotationProcessorConfigurationName;
        this.annotationProcessorConfiguration = annotationProcessorConfiguration;
        this.compileClasspaths = compileClasspaths;
        this.annotationProcessorOptions = annotationProcessorOptions;
        this.isTestComponent = isTestComponent;
        this.dataBindingEnabled = dataBindingEnabled;
    }

    @OutputFile
    public File getProcessorListFile() {
        return this.processorListFile;
    }

    @Classpath
    public FileCollection getAnnotationProcessorConfiguration() {
        return this.annotationProcessorConfiguration.getArtifactFiles();
    }

    @Classpath
    public FileCollection getCompileClasspaths() {
        return this.compileClasspaths.getArtifactFiles();
    }

    @TaskAction
    public void preCompile() throws IOException {
        boolean grandfathered = this.annotationProcessorOptions.getIncludeCompileClasspath() != null;
        Collection<Object> compileProcessors = null;
        if (!grandfathered) {
            compileProcessors = JavaPreCompileTask.collectAnnotationProcessors(this.compileClasspaths);
            FileCollection annotationProcessors = this.annotationProcessorConfiguration.getArtifactFiles();
            if (!(compileProcessors = (Collection)compileProcessors.stream().filter(artifact -> !annotationProcessors.contains(artifact.getFile())).collect(Collectors.toList())).isEmpty()) {
                String message = "Annotation processors must be explicitly declared now.  The following dependencies on the compile classpath are found to contain annotation processor.  Please add them to the " + this.annotationProcessorConfigurationName + " configuration.\n  - " + Joiner.on((String)"\n  - ").join(JavaPreCompileTask.convertArtifactsToNames(compileProcessors)) + "\nAlternatively, set android.defaultConfig.javaCompileOptions.annotationProcessorOptions.includeCompileClasspath = true to continue with previous behavior.  Note that this option is deprecated and will be removed in the future.\nSee https://developer.android.com/r/tools/annotation-processor-error-message.html for more details.";
                if (this.isTestComponent) {
                    this.getLogger().warn(message);
                } else {
                    throw new RuntimeException(message);
                }
            }
        }
        HashSet classNames = Sets.newHashSet();
        if (Boolean.TRUE.equals(this.annotationProcessorOptions.getIncludeCompileClasspath())) {
            if (compileProcessors == null) {
                compileProcessors = JavaPreCompileTask.collectAnnotationProcessors(this.compileClasspaths);
            }
            classNames.addAll(JavaPreCompileTask.convertArtifactsToNames(compileProcessors));
        }
        classNames.addAll(JavaPreCompileTask.convertArtifactsToNames(JavaPreCompileTask.collectAnnotationProcessors(this.annotationProcessorConfiguration)));
        classNames.addAll(this.annotationProcessorOptions.getClassNames());
        if (this.dataBindingEnabled) {
            classNames.add(DATA_BINDING_SPEC);
        }
        FileUtils.deleteIfExists((File)this.processorListFile);
        Gson gson = new GsonBuilder().create();
        try (FileWriter writer = new FileWriter(this.processorListFile);){
            gson.toJson((Object)classNames, (Appendable)writer);
        }
    }

    private static List<ResolvedArtifactResult> collectAnnotationProcessors(ArtifactCollection configuration) {
        ArrayList processors = Lists.newArrayList();
        for (ResolvedArtifactResult artifact : configuration) {
            File file = artifact.getFile();
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                if (!new File(file, PROCESSOR_SERVICES).exists()) continue;
                processors.add(artifact);
                continue;
            }
            try {
                JarFile jarFile = new JarFile(file);
                Throwable throwable = null;
                try {
                    JarEntry entry = jarFile.getJarEntry(PROCESSOR_SERVICES);
                    if (entry == null) continue;
                    processors.add(artifact);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jarFile == null) continue;
                    if (throwable != null) {
                        try {
                            jarFile.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jarFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        return processors;
    }

    private static List<String> convertArtifactsToNames(Collection<ResolvedArtifactResult> files) {
        return files.stream().map(artifact -> artifact.getId().getDisplayName()).collect(Collectors.toList());
    }

    public static class CreationAction
    extends LazyTaskCreationAction<JavaPreCompileTask> {
        private final VariantScope scope;
        private File apList;

        public CreationAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("javaPreCompile");
        }

        @Override
        public Class<JavaPreCompileTask> getType() {
            return JavaPreCompileTask.class;
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            this.apList = this.scope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.ANNOTATION_PROCESSOR_LIST, taskName, "annotationProcessors.json");
        }

        @Override
        public void configure(JavaPreCompileTask task) {
            task.init(this.apList, this.scope.getVariantData().getType().isTestComponent() ? this.scope.getVariantData().getType().getPrefix() + "AnnotationProcessor" : "annotationProcessor", this.scope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.ANNOTATION_PROCESSOR, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.PROCESSED_JAR), this.scope.getJavaClasspathArtifacts(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactType.CLASSES, null), this.scope.getVariantConfiguration().getJavaCompileOptions().getAnnotationProcessorOptions(), this.scope.getVariantData().getType().isTestComponent(), false);
            task.setVariantName(this.scope.getFullVariantName());
            task.dependsOn(new Object[]{this.scope.getTaskContainer().getPreBuildTask()});
        }
    }
}

