/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.options.StringOption;
import com.android.bundle.Devices;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.tools.build.bundletool.commands.ExtractApksCommand;
import com.android.utils.FileUtils;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.Reader;
import java.io.Serializable;
import java.nio.file.Files;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gradle.api.Task;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u001a2\u00020\u0001:\u0004\u0019\u001a\u001b\u001cB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0007R&\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR*\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\f8\u0007@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R&\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractApksTask;", "Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "<set-?>", "Lcom/android/build/api/artifact/BuildableArtifact;", "apkSetArchive", "getApkSetArchive", "()Lcom/android/build/api/artifact/BuildableArtifact;", "setApkSetArchive", "(Lcom/android/build/api/artifact/BuildableArtifact;)V", "Ljava/io/File;", "deviceConfig", "getDeviceConfig", "()Ljava/io/File;", "setDeviceConfig", "(Ljava/io/File;)V", "outputDir", "getOutputDir", "setOutputDir", "workers", "Lcom/android/ide/common/workers/WorkerExecutorFacade;", "generateApk", "", "BundleToolRunnable", "Companion", "CreationAction", "Params", "gradle"})
public class ExtractApksTask
extends AndroidVariantTask {
    private final WorkerExecutorFacade workers;
    @NotNull
    private BuildableArtifact apkSetArchive;
    @Nullable
    private File deviceConfig;
    @NotNull
    private File outputDir;
    public static final Companion Companion = new Companion(null);

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public final BuildableArtifact getApkSetArchive() {
        BuildableArtifact buildableArtifact = this.apkSetArchive;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apkSetArchive");
        }
        return buildableArtifact;
    }

    private final void setApkSetArchive(BuildableArtifact buildableArtifact) {
        this.apkSetArchive = buildableArtifact;
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    @Nullable
    public final File getDeviceConfig() {
        return this.deviceConfig;
    }

    private final void setDeviceConfig(File file) {
        this.deviceConfig = file;
    }

    @OutputDirectory
    @NotNull
    public final File getOutputDir() {
        File file = this.outputDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        }
        return file;
    }

    private final void setOutputDir(File file) {
        this.outputDir = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void generateApk() {
        Closeable closeable = (Closeable)this.workers;
        Throwable throwable = null;
        try {
            WorkerExecutorFacade it = (WorkerExecutorFacade)closeable;
            BuildableArtifact buildableArtifact = this.apkSetArchive;
            if (buildableArtifact == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"apkSetArchive");
            }
            File file = BuildableArtifactUtil.singleFile(buildableArtifact);
            File file2 = this.deviceConfig;
            if (file2 == null) {
                throw (Throwable)new RuntimeException("Calling ExtractApk with no device config");
            }
            File file3 = this.outputDir;
            if (file3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
            }
            it.submit(BundleToolRunnable.class, (Serializable)new Params(file, file2, file3));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Inject
    public ExtractApksTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkParameterIsNotNull((Object)workerExecutor, (String)"workerExecutor");
        this.workers = Workers.getWorker$default(Workers.INSTANCE, workerExecutor, null, 2, null);
    }

    @NotNull
    public static final /* synthetic */ File access$getOutputDir$p(ExtractApksTask $this) {
        File file = $this.outputDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        }
        return file;
    }

    @NotNull
    public static final /* synthetic */ BuildableArtifact access$getApkSetArchive$p(ExtractApksTask $this) {
        BuildableArtifact buildableArtifact = $this.apkSetArchive;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apkSetArchive");
        }
        return buildableArtifact;
    }

    @Nullable
    public static final /* synthetic */ File access$getDeviceConfig$p(ExtractApksTask $this) {
        return $this.deviceConfig;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractApksTask$Params;", "Ljava/io/Serializable;", "apkSetArchive", "Ljava/io/File;", "deviceConfig", "outputDir", "(Ljava/io/File;Ljava/io/File;Ljava/io/File;)V", "getApkSetArchive", "()Ljava/io/File;", "getDeviceConfig", "getOutputDir", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "gradle"})
    private static final class Params
    implements Serializable {
        @NotNull
        private final File apkSetArchive;
        @NotNull
        private final File deviceConfig;
        @NotNull
        private final File outputDir;

        @NotNull
        public final File getApkSetArchive() {
            return this.apkSetArchive;
        }

        @NotNull
        public final File getDeviceConfig() {
            return this.deviceConfig;
        }

        @NotNull
        public final File getOutputDir() {
            return this.outputDir;
        }

        public Params(@NotNull File apkSetArchive, @NotNull File deviceConfig, @NotNull File outputDir) {
            Intrinsics.checkParameterIsNotNull((Object)apkSetArchive, (String)"apkSetArchive");
            Intrinsics.checkParameterIsNotNull((Object)deviceConfig, (String)"deviceConfig");
            Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
            this.apkSetArchive = apkSetArchive;
            this.deviceConfig = deviceConfig;
            this.outputDir = outputDir;
        }

        @NotNull
        public final File component1() {
            return this.apkSetArchive;
        }

        @NotNull
        public final File component2() {
            return this.deviceConfig;
        }

        @NotNull
        public final File component3() {
            return this.outputDir;
        }

        @NotNull
        public final Params copy(@NotNull File apkSetArchive, @NotNull File deviceConfig, @NotNull File outputDir) {
            Intrinsics.checkParameterIsNotNull((Object)apkSetArchive, (String)"apkSetArchive");
            Intrinsics.checkParameterIsNotNull((Object)deviceConfig, (String)"deviceConfig");
            Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
            return new Params(apkSetArchive, deviceConfig, outputDir);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Params copy$default(Params params, File file, File file2, File file3, int n, Object object) {
            if ((n & 1) != 0) {
                file = params.apkSetArchive;
            }
            if ((n & 2) != 0) {
                file2 = params.deviceConfig;
            }
            if ((n & 4) != 0) {
                file3 = params.outputDir;
            }
            return params.copy(file, file2, file3);
        }

        public String toString() {
            return "Params(apkSetArchive=" + this.apkSetArchive + ", deviceConfig=" + this.deviceConfig + ", outputDir=" + this.outputDir + ")";
        }

        public int hashCode() {
            File file = this.apkSetArchive;
            File file2 = this.deviceConfig;
            File file3 = this.outputDir;
            return ((file != null ? ((Object)file).hashCode() : 0) * 31 + (file2 != null ? ((Object)file2).hashCode() : 0)) * 31 + (file3 != null ? ((Object)file3).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Params)) break block3;
                    Params params = (Params)object;
                    if (!Intrinsics.areEqual((Object)this.apkSetArchive, (Object)params.apkSetArchive) || !Intrinsics.areEqual((Object)this.deviceConfig, (Object)params.deviceConfig) || !Intrinsics.areEqual((Object)this.outputDir, (Object)params.outputDir)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractApksTask$BundleToolRunnable;", "Ljava/lang/Runnable;", "params", "Lcom/android/build/gradle/internal/tasks/ExtractApksTask$Params;", "(Lcom/android/build/gradle/internal/tasks/ExtractApksTask$Params;)V", "run", "", "gradle"})
    private static final class BundleToolRunnable
    implements Runnable {
        private final Params params;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FileUtils.cleanOutputDir((File)this.params.getOutputDir());
            Devices.DeviceSpec.Builder builder = Devices.DeviceSpec.newBuilder();
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"DeviceSpec.newBuilder()");
            Devices.DeviceSpec.Builder builder2 = builder;
            Closeable closeable = Files.newBufferedReader(this.params.getDeviceConfig().toPath(), Charsets.UTF_8);
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)closeable;
                JsonFormat.parser().merge((Reader)it, (Message.Builder)builder2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            ExtractApksCommand.Builder command = ExtractApksCommand.builder().setApksArchivePath(this.params.getApkSetArchive().toPath()).setDeviceSpec(builder2.build()).setOutputDirectory(this.params.getOutputDir().toPath());
            command.build().execute();
        }

        @Inject
        public BundleToolRunnable(@NotNull Params params) {
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            this.params = params;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0007H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractApksTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/ExtractApksTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "name", "", "getName", "()Ljava/lang/String;", "outputDir", "Ljava/io/File;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "preConfigure", "taskName", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<ExtractApksTask> {
        private File outputDir;

        @Override
        @NotNull
        public String getName() {
            String string = Companion.getTaskName(this.getVariantScope());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getTaskName(variantScope)");
            return string;
        }

        @Override
        @NotNull
        public Class<ExtractApksTask> getType() {
            return ExtractApksTask.class;
        }

        @Override
        public void preConfigure(@NotNull String taskName) {
            Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
            super.preConfigure(taskName);
            this.outputDir = BuildArtifactsHolder.appendArtifact$default(this.getVariantScope().getArtifacts(), (ArtifactType)InternalArtifactType.EXTRACTED_APKS, taskName, null, 4, null);
        }

        @Override
        public void configure(@NotNull ExtractApksTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            File file = this.outputDir;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
            }
            task.outputDir = file;
            task.apkSetArchive = this.getVariantScope().getArtifacts().getFinalArtifactFiles(InternalArtifactType.APKS_FROM_BUNDLE);
            GlobalScope globalScope = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
            String devicePath = globalScope.getProjectOptions().get(StringOption.IDE_APK_SELECT_CONFIG);
            if (devicePath != null) {
                task.deviceConfig = new File(devicePath);
            }
        }

        public CreationAction(@NotNull VariantScope variantScope) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            super(variantScope);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractApksTask$Companion;", "", "()V", "getTaskName", "", "scope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "gradle"})
    public static final class Companion {
        @NotNull
        public final String getTaskName(@NotNull VariantScope scope) {
            Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
            return scope.getTaskName("extractApksFor");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

