/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.InternalScope;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.OriginalStream;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.AnchorOutputType;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.MergeConsumerProguardFilesTask;
import com.android.build.gradle.internal.tasks.PackageRenderscriptTask;
import com.android.build.gradle.internal.tasks.factory.PreConfigAction;
import com.android.build.gradle.internal.tasks.factory.TaskConfigAction;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.internal.transforms.LibraryAarJarsTransform;
import com.android.build.gradle.internal.transforms.LibraryBaseTransform;
import com.android.build.gradle.internal.transforms.LibraryIntermediateJarsTransform;
import com.android.build.gradle.internal.transforms.LibraryJniLibsTransform;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.internal.variant.VariantHelper;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.tasks.BuildArtifactReportTask;
import com.android.build.gradle.tasks.BundleAar;
import com.android.build.gradle.tasks.ExtractAnnotations;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.MergeSourceSetFolders;
import com.android.build.gradle.tasks.VerifyLibraryResourcesTask;
import com.android.build.gradle.tasks.ZipMergingTask;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.profile.Recorder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class LibraryTaskManager
extends TaskManager {
    public LibraryTaskManager(GlobalScope globalScope, Project project, ProjectOptions projectOptions, AndroidBuilder androidBuilder, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, SdkHandler sdkHandler, VariantFactory variantFactory, ToolingModelBuilderRegistry toolingRegistry, Recorder recorder) {
        super(globalScope, project, projectOptions, androidBuilder, dataBindingBuilder, extension, sdkHandler, variantFactory, toolingRegistry, recorder);
    }

    @Override
    public void createTasksForVariantScope(VariantScope variantScope) {
        GradleVariantConfiguration variantConfig = variantScope.getVariantConfiguration();
        GlobalScope globalScope = variantScope.getGlobalScope();
        this.createAnchorTasks(variantScope);
        this.createDependencyStreams(variantScope);
        this.createCheckManifestTask(variantScope);
        this.taskFactory.register(new BuildArtifactReportTask.BuildArtifactReportCreationAction(variantScope));
        this.createGenerateResValuesTask(variantScope);
        this.createMergeLibManifestsTask(variantScope);
        this.createRenderscriptTask(variantScope);
        this.createMergeResourcesTasks(variantScope);
        this.createShaderTask(variantScope);
        this.createMergeAssetsTask(variantScope);
        this.createLibraryAssetsTask(variantScope);
        this.createBuildConfigTask(variantScope);
        this.createProcessResTask(variantScope, new File(globalScope.getIntermediatesDir(), "symbols/" + variantScope.getVariantData().getVariantConfiguration().getDirName()), null, TaskManager.MergeType.PACKAGE, globalScope.getProjectBaseName());
        if (!((CoreBuildType)variantScope.getVariantConfiguration().getBuildType()).isDebuggable() && !variantScope.getGlobalScope().getExtension().getAaptOptions().getNamespaced()) {
            this.createVerifyLibraryResTask(variantScope);
        }
        this.createProcessJavaResTask(variantScope);
        this.createAidlTask(variantScope);
        this.createDataBindingTasksIfNecessary(variantScope, TaskManager.MergeType.PACKAGE);
        TaskProvider<? extends JavaCompile> javacTask = this.createJavacTask(variantScope);
        this.addJavacClassesStream(variantScope);
        TaskManager.setJavaCompilerTask(javacTask, variantScope);
        this.createNdkTasks(variantScope);
        this.createExternalNativeBuildJsonGenerators(variantScope);
        this.createExternalNativeBuildTasks(variantScope);
        this.createMergeJniLibFoldersTasks(variantScope);
        LibraryTaskManager.createStripNativeLibraryTask(this.taskFactory, variantScope);
        this.taskFactory.register(new PackageRenderscriptTask.CreationAction(variantScope));
        this.taskFactory.register(new MergeConsumerProguardFilesTask.CreationAction(variantScope));
        if (this.projectOptions.get(BooleanOption.ENABLE_EXTRACT_ANNOTATIONS)) {
            this.taskFactory.register(new ExtractAnnotations.CreationAction(this.extension, variantScope));
        }
        boolean instrumented = ((CoreBuildType)variantConfig.getBuildType()).isTestCoverageEnabled() && !variantScope.getInstantRunBuildContext().isInInstantRunMode();
        TransformManager transformManager = variantScope.getTransformManager();
        if (instrumented) {
            this.createJacocoTask(variantScope);
        }
        List<Transform> customTransforms = this.extension.getTransforms();
        List<List<Object>> customTransformsDependencies = this.extension.getTransformsDependencies();
        int count = customTransforms.size();
        for (int i = 0; i < count; ++i) {
            Transform transform2 = customTransforms.get(i);
            Sets.SetView difference = Sets.difference((Set)transform2.getScopes(), TransformManager.PROJECT_ONLY);
            if (!difference.isEmpty()) {
                String scopes = difference.toString();
                this.androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException(String.format("Transforms with scopes '%s' cannot be applied to library projects.", scopes)));
            }
            List<Object> deps = customTransformsDependencies.get(i);
            transformManager.addTransform(this.taskFactory, variantScope, transform2, null, task -> {
                if (!deps.isEmpty()) {
                    task.dependsOn(new Object[]{deps});
                }
            }, taskProvider -> {
                if (transform2.getScopes().isEmpty()) {
                    TaskFactoryUtils.dependsOn(variantScope.getTaskContainer().getAssembleTask(), taskProvider);
                }
            });
        }
        File jarOutputFolder = variantScope.getIntermediateJarOutputFolder();
        File mainClassJar = new File(jarOutputFolder, "classes.jar");
        File mainResJar = new File(jarOutputFolder, "res.jar");
        LibraryIntermediateJarsTransform intermediateTransform = new LibraryIntermediateJarsTransform(mainClassJar, mainResJar, variantConfig::getPackageFromManifest, this.extension.getPackageBuildConfig());
        this.excludeDataBindingClassesIfNecessary(variantScope, intermediateTransform);
        BuildArtifactsHolder artifacts = variantScope.getArtifacts();
        transformManager.addTransform(this.taskFactory, variantScope, intermediateTransform, taskName -> {
            artifacts.appendArtifact((ArtifactType)InternalArtifactType.LIBRARY_CLASSES, (Collection<? extends Object>)ImmutableList.of((Object)mainClassJar), taskName);
            artifacts.appendArtifact((ArtifactType)InternalArtifactType.LIBRARY_JAVA_RES, (Collection<? extends Object>)ImmutableList.of((Object)mainResJar), taskName);
        }, null, null);
        this.taskFactory.register(new ZipMergingTask.CreationAction(variantScope));
        File intermediateJniLibsFolder = new File(jarOutputFolder, "jni");
        LibraryJniLibsTransform intermediateJniTransform = new LibraryJniLibsTransform("intermediateJniLibs", intermediateJniLibsFolder, TransformManager.PROJECT_ONLY);
        transformManager.addTransform(this.taskFactory, variantScope, intermediateJniTransform, taskName -> variantScope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.LIBRARY_JNI, (Collection<? extends Object>)ImmutableList.of((Object)intermediateJniLibsFolder), taskName), null, null);
        this.createMergeJavaResTransform(variantScope);
        this.maybeCreateJavaCodeShrinkerTransform(variantScope);
        this.maybeCreateResourcesShrinkerTransform(variantScope);
        File classesJar = variantScope.getAarClassesJar();
        File libsDirectory = variantScope.getAarLibsDirectory();
        LibraryAarJarsTransform transform3 = new LibraryAarJarsTransform(classesJar, libsDirectory, artifacts.hasArtifact(InternalArtifactType.ANNOTATIONS_TYPEDEF_FILE) ? artifacts.getFinalArtifactFiles(InternalArtifactType.ANNOTATIONS_TYPEDEF_FILE) : null, variantConfig::getPackageFromManifest, this.extension.getPackageBuildConfig());
        this.excludeDataBindingClassesIfNecessary(variantScope, transform3);
        transformManager.addTransform(this.taskFactory, variantScope, transform3, taskName -> {
            variantScope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.AAR_MAIN_JAR, (Collection<? extends Object>)ImmutableList.of((Object)classesJar), taskName);
            variantScope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.AAR_LIBS_DIRECTORY, (Collection<? extends Object>)ImmutableList.of((Object)libsDirectory), taskName);
        }, null, null);
        File jniLibsFolder = variantScope.getIntermediateDir(InternalArtifactType.LIBRARY_AND_LOCAL_JARS_JNI);
        LibraryJniLibsTransform jniTransform = new LibraryJniLibsTransform("syncJniLibs", jniLibsFolder, TransformManager.SCOPE_FULL_LIBRARY_WITH_LOCAL_JARS);
        transformManager.addTransform(this.taskFactory, variantScope, jniTransform, taskName -> variantScope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.LIBRARY_AND_LOCAL_JARS_JNI, (Collection<? extends Object>)ImmutableList.of((Object)jniLibsFolder), taskName), null, null);
        this.createLintTasks(variantScope);
        this.createBundleTask(variantScope);
    }

    private void createBundleTask(VariantScope variantScope) {
        TaskProvider<BundleAar> bundle = this.taskFactory.register(new BundleAar.CreationAction(this.extension, variantScope));
        TaskFactoryUtils.dependsOn(variantScope.getTaskContainer().getAssembleTask(), bundle);
        if (this.extension.getDefaultPublishConfig().equals(variantScope.getVariantConfiguration().getFullName())) {
            VariantHelper.setupArchivesConfig(this.project, variantScope.getVariantDependencies().getRuntimeClasspath());
            this.project.getArtifacts().add("default", bundle);
        }
    }

    @Override
    protected void createDependencyStreams(VariantScope variantScope) {
        super.createDependencyStreams(variantScope);
        variantScope.getTransformManager().addStream(OriginalStream.builder(this.project, "local-deps-classes").addContentTypes(TransformManager.CONTENT_CLASS).addScope(InternalScope.LOCAL_DEPS).setFileCollection(variantScope.getLocalPackagedJars()).build());
        variantScope.getTransformManager().addStream(OriginalStream.builder(this.project, "local-deps-native").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.RESOURCES, ExtendedContentType.NATIVE_LIBS}).addScope(InternalScope.LOCAL_DEPS).setFileCollection(variantScope.getLocalPackagedJars()).build());
    }

    private void createMergeResourcesTasks(VariantScope variantScope) {
        ImmutableSet flags = variantScope.getGlobalScope().getExtension().getAaptOptions().getNamespaced() ? Sets.immutableEnumSet((Enum)MergeResources.Flag.REMOVE_RESOURCE_NAMESPACES, (Enum[])new MergeResources.Flag[]{MergeResources.Flag.PROCESS_VECTOR_DRAWABLES}) : Sets.immutableEnumSet((Enum)MergeResources.Flag.PROCESS_VECTOR_DRAWABLES, (Enum[])new MergeResources.Flag[0]);
        MergeResourceCallback callback = new MergeResourceCallback(variantScope);
        this.basicCreateMergeResourcesTask(variantScope, TaskManager.MergeType.PACKAGE, variantScope.getIntermediateDir(InternalArtifactType.PACKAGED_RES), false, false, false, (ImmutableSet<MergeResources.Flag>)flags, callback, callback);
        this.createMergeResourcesTask(variantScope, false, (ImmutableSet<MergeResources.Flag>)ImmutableSet.of());
    }

    @Override
    protected void postJavacCreation(VariantScope scope) {
        ConfigurableFileCollection files = scope.getGlobalScope().getProject().files(new Object[]{scope.getArtifacts().getArtifactFiles(InternalArtifactType.JAVAC), scope.getVariantData().getAllPreJavacGeneratedBytecode(), scope.getVariantData().getAllPostJavacGeneratedBytecode()});
        scope.getArtifacts().appendArtifact(AnchorOutputType.ALL_CLASSES, (FileCollection)files);
    }

    private void excludeDataBindingClassesIfNecessary(VariantScope variantScope, LibraryBaseTransform transform2) {
        if (!this.extension.getDataBinding().isEnabled()) {
            return;
        }
        transform2.addExcludeListProvider(() -> {
            File excludeFile = variantScope.getVariantData().getType().isExportDataBindingClassList() ? variantScope.getGeneratedClassListOutputFileForDataBinding() : null;
            File dependencyArtifactsDir = ((FileCollection)variantScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.DATA_BINDING_DEPENDENCY_ARTIFACTS).get()).getSingleFile();
            return this.dataBindingBuilder.getJarExcludeList(variantScope.getVariantData().getLayoutXmlProcessor(), excludeFile, dependencyArtifactsDir);
        });
    }

    public void createLibraryAssetsTask(VariantScope scope) {
        this.taskFactory.register(new MergeSourceSetFolders.LibraryAssetCreationAction(scope));
    }

    @Override
    protected Set<? super QualifiedContent.Scope> getResMergingScopes(VariantScope variantScope) {
        if (variantScope.getTestedVariantData() != null) {
            return TransformManager.SCOPE_FULL_PROJECT;
        }
        return TransformManager.PROJECT_ONLY;
    }

    @Override
    protected boolean isLibrary() {
        return true;
    }

    public void createVerifyLibraryResTask(VariantScope scope) {
        TaskProvider<VerifyLibraryResourcesTask> verifyLibraryResources = this.taskFactory.register(new VerifyLibraryResourcesTask.CreationAction(scope));
        TaskFactoryUtils.dependsOn(scope.getTaskContainer().getAssembleTask(), verifyLibraryResources);
    }

    private static class MergeResourceCallback
    implements PreConfigAction,
    TaskConfigAction<MergeResources> {
        private final VariantScope variantScope;
        private File publicFile;

        private MergeResourceCallback(VariantScope variantScope) {
            this.variantScope = variantScope;
        }

        @Override
        public void preConfigure(String taskName) {
            this.publicFile = this.variantScope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.PUBLIC_RES, taskName, "public.txt");
        }

        @Override
        public void configure(MergeResources task) {
            task.setPublicFile(this.publicFile);
        }
    }
}

