/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.SdkConstants;
import com.android.build.gradle.external.cmake.CmakeUtils;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.cxx.configure.CmakeLocatorKt;
import com.android.build.gradle.internal.cxx.configure.CmakeSearchContext;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.LoggerProgressIndicatorWrapper;
import com.android.utils.ILogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000\\\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a2\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u00aa\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00012\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\b0\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\b0\u00172\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\b0\u00172\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\b0\u00172\u0012\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u001d0\u001c2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00172\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001d0\u001c\u001a\u0012\u0010!\u001a\u0004\u0018\u00010\u00032\u0006\u0010\"\u001a\u00020\u000eH\u0002\u001a\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001dH\u0002\u001a\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020 0\u001d2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a4\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00010&2\u0006\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u0001H\u0002\u001a \u0010,\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0005\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0006\u001a\n \u0004*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"FORK_CMAKE_SDK_VERSION", "", "forkCmakeReportedVersion", "Lcom/android/repository/Revision;", "kotlin.jvm.PlatformType", "forkCmakeSdkVersionRevision", "newline", "errorReporter", "", "issueReporter", "Lcom/android/builder/errors/EvalIssueReporter;", "message", "variantName", "findCmakePath", "Ljava/io/File;", "cmakeVersionFromDsl", "sdkHandler", "Lcom/android/build/gradle/internal/SdkHandler;", "logger", "Lcom/android/utils/ILogger;", "findCmakePathLogic", "cmakePathFromLocalProperties", "error", "Lkotlin/Function1;", "warn", "info", "downloader", "environmentPaths", "Lkotlin/Function0;", "", "cmakeVersion", "repositoryPackages", "Lcom/android/repository/api/LocalPackage;", "getCmakeRevisionFromExecutable", "cmakeFolder", "getEnvironmentPaths", "getSdkCmakePackages", "tryAcceptCandidateVersionByParts", "Lkotlin/Pair;", "", "requestedCmakeVersion", "candidateVersion", "candidateCmakeInstallFolder", "locationTag", "warningReporter", "gradle"})
public final class CmakeLocatorKt {
    private static final String FORK_CMAKE_SDK_VERSION = "3.6.4111459";
    private static final Revision forkCmakeSdkVersionRevision = Revision.parseRevision((String)"3.6.4111459");
    private static final Revision forkCmakeReportedVersion = Revision.parseRevision((String)"3.6.0");
    private static final String newline = System.lineSeparator();

    /*
     * WARNING - void declaration
     */
    private static final Pair<Boolean, String> tryAcceptCandidateVersionByParts(Revision requestedCmakeVersion, Revision candidateVersion, File candidateCmakeInstallFolder, String locationTag) {
        int[] requestedParts = requestedCmakeVersion.toIntArray(true);
        int[] candidateParts = candidateVersion.toIntArray(true);
        if (candidateParts.length < requestedParts.length) {
            return candidateVersion.compareTo(requestedCmakeVersion) > 0 ? new Pair((Object)false, (Object)("CMake '" + candidateVersion + "' found at " + candidateCmakeInstallFolder.getParent() + " could not satisfy requested version " + '\'' + requestedCmakeVersion + "' because it was too high and " + '\'' + requestedCmakeVersion + "+' wasn't requested.")) : new Pair((Object)false, (Object)("CMake '" + candidateVersion + "' found at " + candidateCmakeInstallFolder.getParent() + " could not satisfy requested version " + '\'' + requestedCmakeVersion + "' because it didn't have enough precision."));
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)requestedParts, (String)"requestedParts");
        int[] nArray = requestedParts;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            void index;
            int requestedPart = nArray[n2];
            int candidatePart = candidateParts[index];
            if (requestedPart != candidatePart) {
                Revision.Precision segment = Revision.Precision.values()[index];
                return new Pair((Object)false, (Object)("CMake '" + candidateVersion + "' found " + locationTag + " did not satisfy requested version " + '\'' + requestedCmakeVersion + "' because " + segment + " value " + candidatePart + " wasn't " + "exactly " + requestedPart + '.'));
            }
            ++index;
        }
        return new Pair((Object)true, (Object)"");
    }

    private static final List<File> getEnvironmentPaths() {
        String it;
        Iterable $receiver$iv$iv;
        String string = System.getenv("PATH");
        if (string == null) {
            string = "";
        }
        String envPath = string;
        String string2 = System.getProperty("path.separator");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"System.getProperty(\"path.separator\")");
        CharSequence charSequence = string2;
        Regex pathSeparator = new Regex(charSequence);
        charSequence = envPath;
        int n = 0;
        Iterable $receiver$iv = pathSeparator.split(charSequence, n);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (String)element$iv$iv;
            CharSequence charSequence2 = it;
            if (!(charSequence2.length() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            File file = new File(it);
            collection.add(file);
        }
        return (List)destination$iv$iv;
    }

    private static final List<LocalPackage> getSdkCmakePackages(SdkHandler sdkHandler, ILogger logger) {
        RepoManager sdkManager;
        AndroidSdkHandler androidSdkHandler = AndroidSdkHandler.getInstance((File)sdkHandler.getSdkFolder());
        RepoManager repoManager = sdkManager = androidSdkHandler.getSdkManager((ProgressIndicator)new LoggerProgressIndicatorWrapper(logger));
        Intrinsics.checkExpressionValueIsNotNull((Object)repoManager, (String)"sdkManager");
        RepositoryPackages packages = repoManager.getPackages();
        Collection collection = packages.getLocalPackagesForPrefix("cmake");
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"packages.getLocalPackagesForPrefix(FD_CMAKE)");
        return CollectionsKt.toList((Iterable)collection);
    }

    private static final void errorReporter(EvalIssueReporter issueReporter, String message, String variantName) {
        issueReporter.reportError(EvalIssueReporter.Type.EXTERNAL_NATIVE_BUILD_CONFIGURATION, new EvalIssueException(message, variantName, null, 4, null));
    }

    private static final Revision getCmakeRevisionFromExecutable(File cmakeFolder) {
        if (!cmakeFolder.exists()) {
            return null;
        }
        String cmakeExecutableName = SdkConstants.CURRENT_PLATFORM == 2 ? "cmake.exe" : "cmake";
        File cmakeExecutable = new File(cmakeFolder, cmakeExecutableName);
        if (!cmakeExecutable.exists()) {
            return null;
        }
        return CmakeUtils.getVersion(cmakeFolder);
    }

    private static final void warningReporter(EvalIssueReporter issueReporter, String message, String variantName) {
        issueReporter.reportWarning(EvalIssueReporter.Type.EXTERNAL_NATIVE_BUILD_CONFIGURATION, message, variantName);
    }

    @Nullable
    public static final File findCmakePathLogic(@Nullable String cmakeVersionFromDsl, @Nullable File cmakePathFromLocalProperties, @NotNull Function1<? super String, Unit> error2, @NotNull Function1<? super String, Unit> warn, @NotNull Function1<? super String, Unit> info, @NotNull Function1<? super String, Unit> downloader, @NotNull Function0<? extends List<? extends File>> environmentPaths, @NotNull Function1<? super File, ? extends Revision> cmakeVersion, @NotNull Function0<? extends List<? extends LocalPackage>> repositoryPackages) {
        Intrinsics.checkParameterIsNotNull(error2, (String)"error");
        Intrinsics.checkParameterIsNotNull(warn, (String)"warn");
        Intrinsics.checkParameterIsNotNull(info, (String)"info");
        Intrinsics.checkParameterIsNotNull(downloader, (String)"downloader");
        Intrinsics.checkParameterIsNotNull(environmentPaths, (String)"environmentPaths");
        Intrinsics.checkParameterIsNotNull(cmakeVersion, (String)"cmakeVersion");
        Intrinsics.checkParameterIsNotNull(repositoryPackages, (String)"repositoryPackages");
        return new CmakeSearchContext(cmakeVersionFromDsl, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(error2){
            final /* synthetic */ Function1 $error;

            public final void invoke(@NotNull String message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                this.$error.invoke((Object)message);
            }
            {
                this.$error = function1;
                super(1);
            }
        }), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(warn){
            final /* synthetic */ Function1 $warn;

            public final void invoke(@NotNull String message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                this.$warn.invoke((Object)message);
            }
            {
                this.$warn = function1;
                super(1);
            }
        }), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(info){
            final /* synthetic */ Function1 $info;

            public final void invoke(@NotNull String message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                this.$info.invoke((Object)message);
            }
            {
                this.$info = function1;
                super(1);
            }
        })).useDefaultCmakeVersionIfNecessary$gradle().checkForCmakeVersionTooLow$gradle().tryPathFromLocalProperties$gradle(cmakeVersion, cmakePathFromLocalProperties).tryLocalRepositoryPackages$gradle(downloader, repositoryPackages).tryFindInPath$gradle(cmakeVersion, environmentPaths).issueVersionNotFoundError$gradle();
    }

    @Nullable
    public static final File findCmakePath(@Nullable String cmakeVersionFromDsl, @NotNull SdkHandler sdkHandler, @NotNull String variantName, @NotNull EvalIssueReporter issueReporter, @NotNull ILogger logger) {
        Intrinsics.checkParameterIsNotNull((Object)sdkHandler, (String)"sdkHandler");
        Intrinsics.checkParameterIsNotNull((Object)variantName, (String)"variantName");
        Intrinsics.checkParameterIsNotNull((Object)issueReporter, (String)"issueReporter");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        return CmakeLocatorKt.findCmakePathLogic(cmakeVersionFromDsl, sdkHandler.getCmakePathInLocalProp(), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(issueReporter, variantName){
            final /* synthetic */ EvalIssueReporter $issueReporter;
            final /* synthetic */ String $variantName;

            public final void invoke(@NotNull String message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                CmakeLocatorKt.access$errorReporter(this.$issueReporter, message, this.$variantName);
            }
            {
                this.$issueReporter = evalIssueReporter;
                this.$variantName = string;
                super(1);
            }
        }), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(issueReporter, variantName){
            final /* synthetic */ EvalIssueReporter $issueReporter;
            final /* synthetic */ String $variantName;

            public final void invoke(@NotNull String message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                CmakeLocatorKt.access$warningReporter(this.$issueReporter, message, this.$variantName);
            }
            {
                this.$issueReporter = evalIssueReporter;
                this.$variantName = string;
                super(1);
            }
        }), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(logger){
            final /* synthetic */ ILogger $logger;

            public final void invoke(@NotNull String message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                this.$logger.info(message, new Object[0]);
            }
            {
                this.$logger = iLogger;
                super(1);
            }
        }), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(sdkHandler){
            final /* synthetic */ SdkHandler $sdkHandler;

            public final void invoke(@NotNull String version) {
                Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
                this.$sdkHandler.installCMake(version);
            }
            {
                this.$sdkHandler = sdkHandler;
                super(1);
            }
        }), (Function0<? extends List<? extends File>>)((Function0)findCmakePath.5.INSTANCE), (Function1<? super File, ? extends Revision>)((Function1)findCmakePath.6.INSTANCE), (Function0<? extends List<? extends LocalPackage>>)((Function0)new Function0<List<? extends LocalPackage>>(sdkHandler, logger){
            final /* synthetic */ SdkHandler $sdkHandler;
            final /* synthetic */ ILogger $logger;

            @NotNull
            public final List<LocalPackage> invoke() {
                return CmakeLocatorKt.access$getSdkCmakePackages(this.$sdkHandler, this.$logger);
            }
            {
                this.$sdkHandler = sdkHandler;
                this.$logger = iLogger;
                super(0);
            }
        }));
    }

    @NotNull
    public static final /* synthetic */ Pair access$tryAcceptCandidateVersionByParts(@NotNull Revision requestedCmakeVersion, @NotNull Revision candidateVersion, @NotNull File candidateCmakeInstallFolder, @NotNull String locationTag) {
        return CmakeLocatorKt.tryAcceptCandidateVersionByParts(requestedCmakeVersion, candidateVersion, candidateCmakeInstallFolder, locationTag);
    }

    public static final /* synthetic */ Revision access$getForkCmakeReportedVersion$p() {
        return forkCmakeReportedVersion;
    }

    public static final /* synthetic */ Revision access$getForkCmakeSdkVersionRevision$p() {
        return forkCmakeSdkVersionRevision;
    }

    public static final /* synthetic */ String access$getNewline$p() {
        return newline;
    }

    public static final /* synthetic */ void access$errorReporter(@NotNull EvalIssueReporter issueReporter, @NotNull String message, @NotNull String variantName) {
        CmakeLocatorKt.errorReporter(issueReporter, message, variantName);
    }

    public static final /* synthetic */ void access$warningReporter(@NotNull EvalIssueReporter issueReporter, @NotNull String message, @NotNull String variantName) {
        CmakeLocatorKt.warningReporter(issueReporter, message, variantName);
    }

    @NotNull
    public static final /* synthetic */ List access$getEnvironmentPaths() {
        return CmakeLocatorKt.getEnvironmentPaths();
    }

    @Nullable
    public static final /* synthetic */ Revision access$getCmakeRevisionFromExecutable(@NotNull File cmakeFolder) {
        return CmakeLocatorKt.getCmakeRevisionFromExecutable(cmakeFolder);
    }

    @NotNull
    public static final /* synthetic */ List access$getSdkCmakePackages(@NotNull SdkHandler sdkHandler, @NotNull ILogger logger) {
        return CmakeLocatorKt.getSdkCmakePackages(sdkHandler, logger);
    }
}

