/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.builder.compiling.DependencyFileProcessor;
import com.android.builder.internal.compiler.AidlProcessor;
import com.android.builder.internal.compiler.DirectoryWalker;
import com.android.builder.internal.incremental.DependencyData;
import com.android.builder.sdk.TargetInfo;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;

@CacheableTask
public class AidlCompile
extends AndroidVariantTask {
    private static final PatternSet PATTERN_SET = new PatternSet().include(new String[]{"**/*.aidl"});
    private File sourceOutputDir;
    private File packagedDir;
    private Collection<String> packageWhitelist;
    private Supplier<Collection<File>> sourceDirs;
    private FileCollection importDirs;
    private TargetInfo targetInfo;
    private ProcessExecutor processExecutor;

    @Input
    public String getBuildToolsVersion() {
        return this.targetInfo.getBuildTools().getRevision().toString();
    }

    @InputFiles
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSourceFiles() {
        return this.getProject().files(new Object[]{this.sourceDirs.get()}).getAsFileTree().matching((PatternFilterable)PATTERN_SET);
    }

    @TaskAction
    public void doFullTaskAction() throws IOException {
        File destinationDir = this.getSourceOutputDir();
        File parcelableDir = this.getPackagedDir();
        FileUtils.cleanOutputDir((File)destinationDir);
        if (parcelableDir != null) {
            FileUtils.cleanOutputDir((File)parcelableDir);
        }
        try {
            IAndroidTarget target = this.targetInfo.getTarget();
            BuildToolInfo buildToolInfo = this.targetInfo.getBuildTools();
            String aidl = buildToolInfo.getPath(BuildToolInfo.PathId.AIDL);
            if (aidl == null || !new File(aidl).isFile()) {
                throw new IllegalStateException("aidl is missing from '" + aidl + "'");
            }
            Collection<File> sourceFolders = this.sourceDirs.get();
            Set importFolders = this.getImportDirs().getFiles();
            ArrayList fullImportList = Lists.newArrayListWithCapacity((int)(sourceFolders.size() + importFolders.size()));
            fullImportList.addAll(sourceFolders);
            fullImportList.addAll(importFolders);
            AidlProcessor processor = new AidlProcessor(aidl, target.getPath(2), (Iterable)fullImportList, this.sourceOutputDir, this.packagedDir, this.packageWhitelist, (DependencyFileProcessor)new DepFileProcessor(), this.processExecutor, (ProcessOutputHandler)new LoggedProcessOutputHandler((ILogger)new LoggerWrapper(this.getLogger())));
            for (File dir : sourceFolders) {
                DirectoryWalker.builder().root(dir.toPath()).extensions(new String[]{"aidl"}).action((DirectoryWalker.FileAction)processor).build().walk();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @OutputDirectory
    public File getSourceOutputDir() {
        return this.sourceOutputDir;
    }

    public void setSourceOutputDir(File sourceOutputDir) {
        this.sourceOutputDir = sourceOutputDir;
    }

    @OutputDirectory
    @Optional
    public File getPackagedDir() {
        return this.packagedDir;
    }

    public void setPackagedDir(File packagedDir) {
        this.packagedDir = packagedDir;
    }

    @Input
    @Optional
    public Collection<String> getPackageWhitelist() {
        return this.packageWhitelist;
    }

    public void setPackageWhitelist(Collection<String> packageWhitelist) {
        this.packageWhitelist = packageWhitelist;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getImportDirs() {
        return this.importDirs;
    }

    public static class CreationAction
    extends VariantTaskCreationAction<AidlCompile> {
        private File sourceOutputDir;
        private File packagedDir;

        public CreationAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("compile", "Aidl");
        }

        @Override
        public Class<AidlCompile> getType() {
            return AidlCompile.class;
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            this.sourceOutputDir = this.getVariantScope().getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.AIDL_SOURCE_OUTPUT_DIR, taskName, "out");
            if (this.getVariantScope().getVariantConfiguration().getType().isAar()) {
                this.packagedDir = this.getVariantScope().getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.AIDL_PARCELABLE, taskName, "out");
            }
        }

        @Override
        public void handleProvider(TaskProvider<? extends AidlCompile> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setAidlCompileTask(taskProvider);
        }

        @Override
        public void configure(AidlCompile compileTask) {
            super.configure(compileTask);
            VariantScope scope = this.getVariantScope();
            GradleVariantConfiguration variantConfiguration = scope.getVariantConfiguration();
            compileTask.targetInfo = scope.getGlobalScope().getTargetInfo();
            compileTask.processExecutor = scope.getGlobalScope().getProcessExecutor();
            compileTask.sourceDirs = variantConfiguration::getAidlSourceList;
            compileTask.importDirs = scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.AIDL);
            compileTask.setSourceOutputDir(this.sourceOutputDir);
            if (variantConfiguration.getType().isAar()) {
                compileTask.setPackagedDir(this.packagedDir);
                compileTask.setPackageWhitelist(scope.getGlobalScope().getExtension().getAidlPackageWhiteList());
            }
        }
    }

    private static class DepFileProcessor
    implements DependencyFileProcessor {
        private DepFileProcessor() {
        }

        public DependencyData processFile(File dependencyFile) throws IOException {
            return DependencyData.parseDependencyFile((File)dependencyFile);
        }
    }
}

