/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.SigningConfigMetadata;
import com.android.build.gradle.tasks.AnnotationProcessingTaskCreationAction;
import com.android.build.gradle.tasks.Initial;
import com.android.build.gradle.tasks.InternalID;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0007R2\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0007@@X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR*\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u000b8\u0007@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/SigningConfigWriterTask;", "Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "()V", "<set-?>", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "outputDirectory", "getOutputDirectory", "()Lorg/gradle/api/provider/Provider;", "setOutputDirectory$gradle", "(Lorg/gradle/api/provider/Provider;)V", "Lcom/android/build/gradle/internal/dsl/SigningConfig;", "signingConfig", "getSigningConfig", "()Lcom/android/build/gradle/internal/dsl/SigningConfig;", "setSigningConfig$gradle", "(Lcom/android/build/gradle/internal/dsl/SigningConfig;)V", "fullTaskAction", "", "CreationAction", "gradle"})
public class SigningConfigWriterTask
extends AndroidVariantTask {
    @NotNull
    public Provider<Directory> outputDirectory;
    @Nullable
    private SigningConfig signingConfig;

    @OutputDirectory
    @InternalID(value=InternalArtifactType.FEATURE_SIGNING_CONFIG)
    @Initial(out="")
    @NotNull
    public final Provider<Directory> getOutputDirectory() {
        Provider<Directory> provider = this.outputDirectory;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDirectory");
        }
        return provider;
    }

    public final void setOutputDirectory$gradle(@NotNull Provider<Directory> provider) {
        Intrinsics.checkParameterIsNotNull(provider, (String)"<set-?>");
        this.outputDirectory = provider;
    }

    @Input
    @Optional
    @Nullable
    public final SigningConfig getSigningConfig() {
        return this.signingConfig;
    }

    public final void setSigningConfig$gradle(@Nullable SigningConfig signingConfig) {
        this.signingConfig = signingConfig;
    }

    @TaskAction
    public final void fullTaskAction() throws IOException {
        Provider<Directory> provider = this.outputDirectory;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDirectory");
        }
        if (provider == null) {
            throw (Throwable)new RuntimeException("OutputDirectory not set.");
        }
        Provider<Directory> out = provider;
        Object object = out.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"out.get()");
        File file = ((Directory)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"out.get().asFile");
        SigningConfigMetadata.Companion.save(file, this.signingConfig);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/tasks/SigningConfigWriterTask$CreationAction;", "Lcom/android/build/gradle/tasks/AnnotationProcessingTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/SigningConfigWriterTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "configure", "", "task", "gradle"})
    public static final class CreationAction
    extends AnnotationProcessingTaskCreationAction<SigningConfigWriterTask> {
        @Override
        public void configure(@NotNull SigningConfigWriterTask task) {
            SigningConfig signingConfig;
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            SigningConfigWriterTask signingConfigWriterTask = task;
            GradleVariantConfiguration gradleVariantConfiguration = this.getVariantScope().getVariantConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"variantScope.variantConfiguration");
            CoreSigningConfig coreSigningConfig = gradleVariantConfiguration.getSigningConfig();
            if (coreSigningConfig != null) {
                CoreSigningConfig it;
                CoreSigningConfig coreSigningConfig2 = coreSigningConfig;
                SigningConfigWriterTask signingConfigWriterTask2 = signingConfigWriterTask;
                CoreSigningConfig coreSigningConfig3 = it = coreSigningConfig2;
                Intrinsics.checkExpressionValueIsNotNull((Object)coreSigningConfig3, (String)"it");
                SigningConfig signingConfig2 = new SigningConfig(coreSigningConfig3.getName()).initWith(it);
                signingConfigWriterTask = signingConfigWriterTask2;
                signingConfig = signingConfig2;
            } else {
                signingConfig = null;
            }
            signingConfigWriterTask.setSigningConfig$gradle(signingConfig);
        }

        public CreationAction(@NotNull VariantScope variantScope) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            String string = variantScope.getTaskName("signingConfigWriter");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName(\"signingConfigWriter\")");
            super(variantScope, string, SigningConfigWriterTask.class);
        }
    }
}

