/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.FilterData;
import com.android.build.VariantOutput;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.ide.FilterDataImpl;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.ide.common.build.ApkData;
import com.android.utils.Pair;
import com.android.utils.StringHelper;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class OutputFactory {
    static final String UNIVERSAL = "universal";
    private final String projectBaseName;
    private final GradleVariantConfiguration variantConfiguration;
    private final OutputScope outputScope;

    public OutputFactory(String projectBaseName, GradleVariantConfiguration variantConfiguration, OutputScope outputScope) {
        this.projectBaseName = projectBaseName;
        this.variantConfiguration = variantConfiguration;
        this.outputScope = outputScope;
    }

    private String getOutputFileName(String baseName) {
        String suffix = this.variantConfiguration.isSigningReady() || !this.variantConfiguration.getType().isBaseModule() ? ".apk" : "-unsigned.apk";
        return this.projectBaseName + "-" + baseName + suffix;
    }

    public ApkData addMainOutput(String defaultFilename) {
        String baseName = this.variantConfiguration.getBaseName();
        Main mainOutput = new Main(baseName, this.variantConfiguration.getFullName(), "", defaultFilename);
        this.checkNoDuplicate(mainOutput);
        this.outputScope.addSplit(mainOutput);
        return mainOutput;
    }

    public ApkData addMainApk() {
        return this.addMainOutput(this.getOutputFileName(this.variantConfiguration.getBaseName()));
    }

    public ApkData addUniversalApk() {
        String baseName = this.variantConfiguration.computeBaseNameWithSplits(UNIVERSAL);
        Universal mainApk = new Universal(baseName, this.variantConfiguration.computeFullNameWithSplits(UNIVERSAL), this.getOutputFileName(baseName));
        this.checkNoDuplicate(mainApk);
        this.outputScope.addSplit(mainApk);
        return mainApk;
    }

    private void checkNoDuplicate(ApkData newApkData) {
        List<ApkData> splitsByType = this.outputScope.getSplitsByType(VariantOutput.OutputType.MAIN);
        if (!splitsByType.isEmpty()) {
            throw new RuntimeException("Cannot add " + newApkData + " in a scope that already has " + Joiner.on((String)",").join(splitsByType));
        }
    }

    public ApkData addFullSplit(ImmutableList<Pair<VariantOutput.FilterType, String>> filters) {
        ImmutableList filtersList = ImmutableList.copyOf((Collection)filters.stream().map(filter -> new FilterDataImpl((VariantOutput.FilterType)filter.getFirst(), (String)filter.getSecond())).collect(Collectors.toList()));
        String filterName = FullSplit._getFilterName((ImmutableList<FilterData>)filtersList);
        String baseName = this.variantConfiguration.computeBaseNameWithSplits(filterName);
        FullSplit apkData = new FullSplit(filterName, baseName, this.variantConfiguration.computeFullNameWithSplits(filterName), this.getOutputFileName(baseName), filtersList);
        this.outputScope.addSplit(apkData);
        return apkData;
    }

    public ApkData addConfigurationSplit(VariantOutput.FilterType filterType, String filterValue, String fileName) {
        ImmutableList filtersList = ImmutableList.of((Object)new FilterDataImpl(filterType, filterValue));
        return this.addConfigurationSplit((ImmutableList<FilterData>)filtersList, fileName);
    }

    public ApkData addConfigurationSplit(VariantOutput.FilterType filterType, String filterValue, String fileName, String filterDisplayName) {
        ImmutableList filtersList = ImmutableList.of((Object)new FilterDataImpl(filterType, filterValue));
        return this.addConfigurationSplit((ImmutableList<FilterData>)filtersList, fileName, filterDisplayName);
    }

    public static String getFilterNameForSplits(Collection<FilterData> filters) {
        return Joiner.on((String)"-").join((Iterable)filters.stream().map(FilterData::getIdentifier).collect(Collectors.toList()));
    }

    private ApkData addConfigurationSplit(ImmutableList<FilterData> filtersList, String fileName) {
        String filterDisplayName = OutputFactory.getFilterNameForSplits(filtersList);
        return this.addConfigurationSplit(filtersList, fileName, filterDisplayName);
    }

    private ApkData addConfigurationSplit(ImmutableList<FilterData> filtersList, String fileName, String filterDisplayName) {
        ConfigurationSplitApkData apkData = new ConfigurationSplitApkData(filterDisplayName, this.variantConfiguration.computeBaseNameWithSplits(filterDisplayName), this.variantConfiguration.getFullName(), this.variantConfiguration.getDirName(), fileName, filtersList);
        this.outputScope.addSplit(apkData);
        return apkData;
    }

    public static class ConfigurationSplitApkData
    extends ApkData {
        private final String filterName;
        private final String baseName;
        private final String fullName;
        private final String dirName;
        private final ImmutableList<FilterData> filters;

        public ConfigurationSplitApkData(String filterName, String baseName, String fullName, String dirName, String fileName, ImmutableList<FilterData> filters) {
            this.filters = filters;
            this.filterName = filterName;
            this.baseName = baseName;
            this.fullName = fullName;
            this.dirName = dirName;
            this.setOutputFileName(fileName);
        }

        public VariantOutput.OutputType getType() {
            return VariantOutput.OutputType.SPLIT;
        }

        public boolean requiresAapt() {
            return false;
        }

        public String getFilterName() {
            return this.filterName;
        }

        public ImmutableList<FilterData> getFilters() {
            return this.filters;
        }

        public String getBaseName() {
            return this.baseName;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getDirName() {
            return this.dirName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ConfigurationSplitApkData that = (ConfigurationSplitApkData)((Object)o);
            return Objects.equals(this.baseName, that.baseName) && Objects.equals(this.fullName, that.fullName) && Objects.equals(this.dirName, that.dirName) && Objects.equals(this.filterName, that.filterName);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.baseName, this.fullName, this.dirName, this.filterName);
        }
    }

    static class FullSplit
    extends Universal {
        private final ImmutableList<FilterData> filters;
        private final String filterName;

        private FullSplit(String filterName, String baseName, String fullName, String fileName, ImmutableList<FilterData> filters) {
            super(baseName, fullName, fileName);
            this.filterName = filterName;
            this.filters = filters;
        }

        private static String _getFilterName(ImmutableList<FilterData> filters) {
            String abiFilter;
            StringBuilder sb = new StringBuilder();
            String densityFilter = ApkData.getFilter(filters, (VariantOutput.FilterType)VariantOutput.FilterType.DENSITY);
            if (densityFilter != null) {
                sb.append(densityFilter);
            }
            if ((abiFilter = FullSplit.getFilter(filters, (VariantOutput.FilterType)VariantOutput.FilterType.ABI)) != null) {
                StringHelper.appendCamelCase((StringBuilder)sb, (String)abiFilter);
            }
            return sb.toString();
        }

        @Override
        public VariantOutput.OutputType getType() {
            return VariantOutput.OutputType.FULL_SPLIT;
        }

        public ImmutableList<FilterData> getFilters() {
            return this.filters;
        }

        @Override
        public String getFilterName() {
            return this.filterName;
        }

        @Override
        public String getDirName() {
            StringBuilder sb = new StringBuilder();
            for (FilterData filter : this.getFilters()) {
                sb.append(filter.getIdentifier()).append(File.separatorChar);
            }
            return sb.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FullSplit that = (FullSplit)((Object)o);
            return Objects.equals(this.filterName, that.filterName) && Objects.equals(this.filters, that.filters);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.filterName, this.filters);
        }
    }

    private static class Universal
    extends ApkData {
        private final String baseName;
        private final String fullName;

        private Universal(String baseName, String fullName, String fileName) {
            this.baseName = baseName;
            this.fullName = fullName;
            this.setOutputFileName(fileName);
        }

        public VariantOutput.OutputType getType() {
            return VariantOutput.OutputType.FULL_SPLIT;
        }

        public String getFilterName() {
            return OutputFactory.UNIVERSAL;
        }

        public String getBaseName() {
            return this.baseName;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getDirName() {
            if (this.getFilters().isEmpty()) {
                return OutputFactory.UNIVERSAL;
            }
            StringBuilder sb = new StringBuilder();
            for (FilterData filter : this.getFilters()) {
                sb.append(filter.getIdentifier()).append(File.separatorChar);
            }
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Universal that = (Universal)((Object)o);
            return Objects.equals(this.baseName, that.baseName) && Objects.equals(this.fullName, that.fullName);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.baseName, this.fullName);
        }
    }

    private static final class Main
    extends ApkData {
        private final String baseName;
        private final String fullName;
        private final String dirName;

        private Main(String baseName, String fullName, String dirName, String fileName) {
            this.baseName = baseName;
            this.fullName = fullName;
            this.dirName = dirName;
            this.setOutputFileName(fileName);
        }

        public VariantOutput.OutputType getType() {
            return VariantOutput.OutputType.MAIN;
        }

        public String getFilterName() {
            return null;
        }

        public String getBaseName() {
            return this.baseName;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getDirName() {
            return this.dirName;
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.baseName, this.fullName, this.dirName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Main that = (Main)((Object)o);
            return Objects.equals(this.baseName, that.baseName) && Objects.equals(this.fullName, that.fullName) && Objects.equals(this.dirName, that.dirName);
        }
    }
}

