/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.TestAndroidConfig;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.variant.ApplicationVariantFactory;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.utils.StringHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;

public class TestVariantFactory
extends ApplicationVariantFactory {
    public TestVariantFactory(GlobalScope globalScope, AndroidConfig extension) {
        super(globalScope, extension);
    }

    @Override
    public boolean hasTestScope() {
        return false;
    }

    @Override
    public void preVariantWork(Project project) {
        super.preVariantWork(project);
        TestAndroidConfig testExtension = (TestAndroidConfig)this.extension;
        String path = testExtension.getTargetProjectPath();
        if (path == null) {
            throw new GradleException("targetProjectPath cannot be null in test project " + project.getName());
        }
        DependencyHandler handler = project.getDependencies();
        ImmutableMap projectNotation = ImmutableMap.of((Object)"path", (Object)path);
        handler.add("compileOnly", (Object)handler.project((Map)projectNotation));
        Configuration testedApks = (Configuration)project.getConfigurations().maybeCreate("testedApks");
        testedApks.setCanBeConsumed(false);
        testedApks.setCanBeResolved(false);
        handler.add("testedApks", (Object)handler.project((Map)projectNotation));
    }

    @Override
    public void createDefaultComponents(NamedDomainObjectContainer<BuildType> buildTypes, NamedDomainObjectContainer<ProductFlavor> productFlavors, NamedDomainObjectContainer<SigningConfig> signingConfigs) {
        signingConfigs.create("debug");
        buildTypes.create("debug");
    }

    public static String getTestedApksConfigurationName(String variantName) {
        return StringHelper.appendCapitalized((String)variantName, (String)"testedApks");
    }

    @Override
    public Collection<VariantType> getVariantConfigurationTypes() {
        return ImmutableList.of((Object)VariantTypeImpl.TEST_APK);
    }
}

