/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.pipeline.StreamFilter;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.tasks.ResourceUsageAnalyzer;
import com.android.ide.common.build.ApkData;
import com.android.ide.common.build.ApkInfo;
import com.android.utils.FileUtils;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0007R \u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0003\u001a\u0004\u0018\u00010\u000e8G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u000e8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R \u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u000e8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R \u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u000e8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R \u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u000e8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/android/build/gradle/internal/transforms/ShrinkBundleResourcesTask;", "Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "()V", "<set-?>", "Ljava/io/File;", "compressedResourceFile", "getCompressedResourceFile", "()Ljava/io/File;", "Lorg/gradle/api/file/FileCollection;", "dex", "getDex", "()Lorg/gradle/api/file/FileCollection;", "mainSplit", "Lcom/android/ide/common/build/ApkData;", "Lcom/android/build/api/artifact/BuildableArtifact;", "mappingFileSrc", "getMappingFileSrc", "()Lcom/android/build/api/artifact/BuildableArtifact;", "mergedManifests", "getMergedManifests", "resourceDir", "getResourceDir", "sourceDir", "getSourceDir", "uncompressedResources", "getUncompressedResources", "shrink", "", "Companion", "CreationAction", "gradle"})
public class ShrinkBundleResourcesTask
extends AndroidVariantTask {
    @NotNull
    private File compressedResourceFile;
    @NotNull
    private BuildableArtifact uncompressedResources;
    @NotNull
    private FileCollection dex;
    @NotNull
    private BuildableArtifact sourceDir;
    @NotNull
    private BuildableArtifact resourceDir;
    @Nullable
    private BuildableArtifact mappingFileSrc;
    @NotNull
    private BuildableArtifact mergedManifests;
    private ApkData mainSplit;
    public static final Companion Companion = new Companion(null);

    @OutputFile
    @NotNull
    public final File getCompressedResourceFile() {
        File file = this.compressedResourceFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"compressedResourceFile");
        }
        return file;
    }

    @InputFiles
    @NotNull
    public final BuildableArtifact getUncompressedResources() {
        BuildableArtifact buildableArtifact = this.uncompressedResources;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uncompressedResources");
        }
        return buildableArtifact;
    }

    @InputFiles
    @NotNull
    public final FileCollection getDex() {
        FileCollection fileCollection = this.dex;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dex");
        }
        return fileCollection;
    }

    @InputFiles
    @NotNull
    public final BuildableArtifact getSourceDir() {
        BuildableArtifact buildableArtifact = this.sourceDir;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sourceDir");
        }
        return buildableArtifact;
    }

    @InputFiles
    @NotNull
    public final BuildableArtifact getResourceDir() {
        BuildableArtifact buildableArtifact = this.resourceDir;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resourceDir");
        }
        return buildableArtifact;
    }

    @InputFiles
    @Optional
    @Nullable
    public final BuildableArtifact getMappingFileSrc() {
        return this.mappingFileSrc;
    }

    @InputFiles
    @NotNull
    public final BuildableArtifact getMergedManifests() {
        BuildableArtifact buildableArtifact = this.mergedManifests;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mergedManifests");
        }
        return buildableArtifact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void shrink() {
        Serializable serializable;
        File logDir;
        File mappingFile;
        BuildableArtifact buildableArtifact = this.uncompressedResources;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uncompressedResources");
        }
        File uncompressedResourceFile = BuildableArtifactUtil.singleFile(buildableArtifact);
        FileCollection fileCollection = this.dex;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dex");
        }
        Set classes = fileCollection.getFiles();
        File reportFile = null;
        BuildableArtifact buildableArtifact2 = this.mappingFileSrc;
        File file = mappingFile = buildableArtifact2 != null ? BuildableArtifactUtil.singleFile(buildableArtifact2) : null;
        if (mappingFile != null && (logDir = mappingFile.getParentFile()) != null) {
            reportFile = new File(logDir, "resources.txt");
        }
        File file2 = this.compressedResourceFile;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"compressedResourceFile");
        }
        FileUtils.mkdirs((File)file2.getParentFile());
        ArtifactType artifactType = InternalArtifactType.BUNDLE_MANIFEST;
        BuildableArtifact buildableArtifact3 = this.mergedManifests;
        if (buildableArtifact3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mergedManifests");
        }
        BuildElements buildElements = ExistingBuildElements.Companion.from(artifactType, buildableArtifact3);
        ApkData apkData = this.mainSplit;
        if (apkData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainSplit");
        }
        if ((serializable = buildElements.element((ApkInfo)apkData)) == null || (serializable = serializable.getOutputFile()) == null) {
            throw (Throwable)new RuntimeException("Cannot find merged manifest file");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)serializable, (String)"ExistingBuildElements.fr\u2026nd merged manifest file\")");
        Serializable manifestFile = serializable;
        BuildableArtifact buildableArtifact4 = this.sourceDir;
        if (buildableArtifact4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sourceDir");
        }
        File file3 = (File)Iterables.getOnlyElement((Iterable)buildableArtifact4.getFiles());
        Iterable iterable = classes;
        BuildableArtifact buildableArtifact5 = this.resourceDir;
        if (buildableArtifact5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resourceDir");
        }
        ResourceUsageAnalyzer analyzer = new ResourceUsageAnalyzer(file3, iterable, (File)manifestFile, mappingFile, BuildableArtifactUtil.singleFile(buildableArtifact5), reportFile, ResourceUsageAnalyzer.ApkFormat.PROTO);
        try {
            analyzer.setVerbose(this.getLogger().isEnabled(LogLevel.INFO));
            analyzer.setDebug(this.getLogger().isEnabled(LogLevel.DEBUG));
            try {
                analyzer.analyze();
            }
            catch (IOException e) {
                throw (Throwable)new RuntimeException(e);
            }
            catch (ParserConfigurationException e) {
                throw (Throwable)new RuntimeException(e);
            }
            catch (SAXException e) {
                throw (Throwable)new RuntimeException(e);
            }
            File file4 = this.compressedResourceFile;
            if (file4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"compressedResourceFile");
            }
            analyzer.rewriteResourceZip(uncompressedResourceFile, file4);
            int unused = analyzer.getUnusedResourceCount();
            if (unused > 0) {
                StringBuilder sb = new StringBuilder(200);
                sb.append("Removed unused resources");
                long before = uncompressedResourceFile.length();
                File file5 = this.compressedResourceFile;
                if (file5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"compressedResourceFile");
                }
                long after = file5.length();
                long percent = (int)((before - after) * (long)100 / before);
                sb.append(": Binary resource data reduced from ").append(ShrinkBundleResourcesTask.Companion.toKbString(before)).append("KB to ").append(ShrinkBundleResourcesTask.Companion.toKbString(after)).append("KB: Removed ").append(percent).append("%");
                String string = sb.toString();
                System.out.println((Object)string);
            }
        }
        finally {
            analyzer.dispose();
        }
    }

    public static final /* synthetic */ File access$getCompressedResourceFile$p(ShrinkBundleResourcesTask $this) {
        File file = $this.compressedResourceFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"compressedResourceFile");
        }
        return file;
    }

    public static final /* synthetic */ BuildableArtifact access$getUncompressedResources$p(ShrinkBundleResourcesTask $this) {
        BuildableArtifact buildableArtifact = $this.uncompressedResources;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uncompressedResources");
        }
        return buildableArtifact;
    }

    public static final /* synthetic */ ApkData access$getMainSplit$p(ShrinkBundleResourcesTask $this) {
        ApkData apkData = $this.mainSplit;
        if (apkData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainSplit");
        }
        return apkData;
    }

    public static final /* synthetic */ FileCollection access$getDex$p(ShrinkBundleResourcesTask $this) {
        FileCollection fileCollection = $this.dex;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dex");
        }
        return fileCollection;
    }

    public static final /* synthetic */ BuildableArtifact access$getSourceDir$p(ShrinkBundleResourcesTask $this) {
        BuildableArtifact buildableArtifact = $this.sourceDir;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sourceDir");
        }
        return buildableArtifact;
    }

    public static final /* synthetic */ BuildableArtifact access$getResourceDir$p(ShrinkBundleResourcesTask $this) {
        BuildableArtifact buildableArtifact = $this.resourceDir;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resourceDir");
        }
        return buildableArtifact;
    }

    public static final /* synthetic */ BuildableArtifact access$getMappingFileSrc$p(ShrinkBundleResourcesTask $this) {
        return $this.mappingFileSrc;
    }

    public static final /* synthetic */ BuildableArtifact access$getMergedManifests$p(ShrinkBundleResourcesTask $this) {
        BuildableArtifact buildableArtifact = $this.mergedManifests;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mergedManifests");
        }
        return buildableArtifact;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0007H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/transforms/ShrinkBundleResourcesTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/transforms/ShrinkBundleResourcesTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "name", "", "getName", "()Ljava/lang/String;", "outputLocation", "Ljava/io/File;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "preConfigure", "taskName", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<ShrinkBundleResourcesTask> {
        @NotNull
        private final String name;
        private File outputLocation;

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<ShrinkBundleResourcesTask> getType() {
            return ShrinkBundleResourcesTask.class;
        }

        @Override
        public void preConfigure(@NotNull String taskName) {
            Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
            this.outputLocation = this.getVariantScope().getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.SHRUNK_LINKED_RES_FOR_BUNDLE, taskName, "shrunk-bundled-res.ap_");
        }

        @Override
        public void configure(@NotNull ShrinkBundleResourcesTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            File file = this.outputLocation;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"outputLocation");
            }
            task.compressedResourceFile = file;
            task.uncompressedResources = this.getVariantScope().getArtifacts().getFinalArtifactFiles(InternalArtifactType.LINKED_RES_FOR_BUNDLE);
            BaseVariantData baseVariantData = this.getVariantScope().getVariantData();
            Intrinsics.checkExpressionValueIsNotNull((Object)baseVariantData, (String)"variantScope.variantData");
            OutputScope outputScope = baseVariantData.getOutputScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)outputScope, (String)"variantScope.variantData.outputScope");
            ApkData apkData = outputScope.getMainSplit();
            Intrinsics.checkExpressionValueIsNotNull((Object)apkData, (String)"variantScope.variantData.outputScope.mainSplit");
            task.mainSplit = apkData;
            FileCollection fileCollection = this.getVariantScope().getTransformManager().getPipelineOutputAsFileCollection(StreamFilter.DEX);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"variantScope.transformMa\u2026lection(StreamFilter.DEX)");
            task.dex = fileCollection;
            task.sourceDir = this.getVariantScope().getArtifacts().getFinalArtifactFiles(InternalArtifactType.NOT_NAMESPACED_R_CLASS_SOURCES);
            task.resourceDir = this.getVariantScope().getArtifacts().getFinalArtifactFiles(InternalArtifactType.MERGED_NOT_COMPILED_RES);
            task.mappingFileSrc = this.getVariantScope().getArtifacts().hasArtifact(InternalArtifactType.APK_MAPPING) ? this.getVariantScope().getArtifacts().getFinalArtifactFiles(InternalArtifactType.APK_MAPPING) : null;
            task.mergedManifests = this.getVariantScope().getArtifacts().getFinalArtifactFiles(InternalArtifactType.BUNDLE_MANIFEST);
        }

        public CreationAction(@NotNull VariantScope variantScope) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            super(variantScope);
            String string = variantScope.getTaskName("shrink", "Resources");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName(\"shrink\", \"Resources\")");
            this.name = string;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/transforms/ShrinkBundleResourcesTask$Companion;", "", "()V", "toKbString", "", "size", "", "gradle"})
    public static final class Companion {
        private final String toKbString(long size) {
            String string = Integer.toString((int)size / 1024);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Integer.toString(size.toInt() / 1024)");
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

