/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api.artifact;

import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.api.dsl.DslScope;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.TaskDependency;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/android/build/gradle/internal/api/artifact/BuildableArtifactImpl;", "Lcom/android/build/api/artifact/BuildableArtifact;", "fileCollection", "Lorg/gradle/api/file/FileCollection;", "dslScope", "Lcom/android/build/gradle/internal/api/dsl/DslScope;", "(Lorg/gradle/api/file/FileCollection;Lcom/android/build/gradle/internal/api/dsl/DslScope;)V", "asFileTree", "Lorg/gradle/api/file/FileTree;", "getAsFileTree", "()Lorg/gradle/api/file/FileTree;", "getFileCollection", "()Lorg/gradle/api/file/FileCollection;", "files", "", "Ljava/io/File;", "getFiles", "()Ljava/util/Set;", "checkResolvable", "", "get", "getBuildDependencies", "Lorg/gradle/api/tasks/TaskDependency;", "isEmpty", "", "iterator", "", "toString", "", "Companion", "gradle"})
public final class BuildableArtifactImpl
implements BuildableArtifact {
    @NotNull
    private final FileCollection fileCollection;
    private final DslScope dslScope;
    private static final AtomicBoolean resolvable;
    public static final Companion Companion;

    private final void checkResolvable() {
        if (!Companion.isResolvable()) {
            this.dslScope.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException("Resolving this BuildableArtifact can only done during task execution.", null, null, 6, null));
        }
    }

    @NotNull
    public FileCollection get() {
        return this.fileCollection;
    }

    @NotNull
    public Iterator<File> iterator() {
        return this.getFiles().iterator();
    }

    @NotNull
    public Set<File> getFiles() {
        this.checkResolvable();
        Set<File> set = Collections.unmodifiableSet(this.fileCollection.getFiles());
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"Collections.unmodifiableSet(fileCollection.files)");
        return set;
    }

    public boolean isEmpty() {
        this.checkResolvable();
        return this.fileCollection.isEmpty();
    }

    @NotNull
    public TaskDependency getBuildDependencies() {
        TaskDependency taskDependency = this.fileCollection.getBuildDependencies();
        Intrinsics.checkExpressionValueIsNotNull((Object)taskDependency, (String)"fileCollection.buildDependencies");
        return taskDependency;
    }

    @NotNull
    public final FileTree getAsFileTree() {
        this.checkResolvable();
        FileTree fileTree = this.fileCollection.getAsFileTree();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileTree, (String)"fileCollection.asFileTree");
        return fileTree;
    }

    @NotNull
    public String toString() {
        return Companion.isResolvable() ? "BuildableArtifactImpl (" + this.get() + ')' : "BuildableArtifactImpl (Not currently resolvable)";
    }

    @NotNull
    public final FileCollection getFileCollection() {
        return this.fileCollection;
    }

    public BuildableArtifactImpl(@NotNull FileCollection fileCollection, @NotNull DslScope dslScope) {
        Intrinsics.checkParameterIsNotNull((Object)fileCollection, (String)"fileCollection");
        Intrinsics.checkParameterIsNotNull((Object)dslScope, (String)"dslScope");
        this.fileCollection = fileCollection;
        this.dslScope = dslScope;
    }

    static {
        Companion = new Companion(null);
        resolvable = new AtomicBoolean(false);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\u0006J\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/api/artifact/BuildableArtifactImpl$Companion;", "", "()V", "resolvable", "Ljava/util/concurrent/atomic/AtomicBoolean;", "disableResolution", "", "enableResolution", "isResolvable", "", "gradle"})
    public static final class Companion {
        public final boolean isResolvable() {
            return resolvable.get();
        }

        public final void enableResolution() {
            resolvable.set(true);
        }

        public final void disableResolution() {
            resolvable.set(false);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

