/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.pipeline.IncrementalFileMergerTransformUtils$WhenMappings;
import com.android.builder.files.FileCacheByPath;
import com.android.builder.files.IncrementalRelativeFileSets;
import com.android.builder.files.RelativeFile;
import com.android.builder.files.RelativeFiles;
import com.android.builder.merge.IncrementalFileMergerInput;
import com.android.builder.merge.LazyIncrementalFileMergerInput;
import com.android.builder.merge.LazyIncrementalFileMergerInputs;
import com.android.ide.common.resources.FileStatus;
import com.android.tools.build.apkzlib.utils.CachedSupplier;
import com.android.tools.build.apkzlib.utils.IOExceptionRunnable;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a$\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00042\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012\u001a:\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012\u001a@\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012\u001aH\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012\u001a&\u0010 \u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0003\u001a\u00020\u00042\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012\u001a<\u0010 \u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012\u001a@\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012\u00a8\u0006!"}, d2={"computeFiles", "Lcom/google/common/collect/ImmutableSet;", "Lcom/android/builder/files/RelativeFile;", "directoryInput", "Lcom/android/build/api/transform/DirectoryInput;", "jarInput", "Lcom/android/build/api/transform/JarInput;", "computeUpdates", "Lcom/google/common/collect/ImmutableMap;", "Lcom/android/ide/common/resources/FileStatus;", "zipCache", "Lcom/android/builder/files/FileCacheByPath;", "mapStatus", "status", "Lcom/android/build/api/transform/Status;", "toIncrementalInput", "Lcom/android/builder/merge/IncrementalFileMergerInput;", "contentMap", "", "Lcom/android/build/api/transform/QualifiedContent;", "cacheUpdate", "", "Ljava/lang/Runnable;", "Lcom/google/common/collect/ImmutableList;", "transformInput", "Lcom/android/build/api/transform/TransformInput;", "cacheUpdates", "toInput", "transformInvocation", "Lcom/android/build/api/transform/TransformInvocation;", "full", "", "toNonIncrementalInput", "gradle"})
@JvmName(name="IncrementalFileMergerTransformUtils")
public final class IncrementalFileMergerTransformUtils {
    @NotNull
    public static final IncrementalFileMergerInput toIncrementalInput(@NotNull JarInput jarInput, @NotNull FileCacheByPath zipCache, @NotNull List<Runnable> cacheUpdate, @Nullable Map<IncrementalFileMergerInput, QualifiedContent> contentMap) {
        LazyIncrementalFileMergerInput input2;
        block2: {
            Map<IncrementalFileMergerInput, QualifiedContent> map;
            Map<IncrementalFileMergerInput, QualifiedContent> it;
            File jarFile;
            Intrinsics.checkParameterIsNotNull((Object)jarInput, (String)"jarInput");
            Intrinsics.checkParameterIsNotNull((Object)zipCache, (String)"zipCache");
            Intrinsics.checkParameterIsNotNull(cacheUpdate, (String)"cacheUpdate");
            File file = jarFile = jarInput.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"jarFile");
            if (file.isFile()) {
                Runnable runnable = IOExceptionRunnable.asRunnable((IOExceptionRunnable)new IOExceptionRunnable(zipCache, jarFile){
                    final /* synthetic */ FileCacheByPath $zipCache;
                    final /* synthetic */ File $jarFile;

                    public final void run() {
                        this.$zipCache.add(this.$jarFile);
                    }
                    {
                        this.$zipCache = fileCacheByPath;
                        this.$jarFile = file;
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)runnable, (String)"IOExceptionRunnable.asRu\u2026{ zipCache.add(jarFile) }");
                cacheUpdate.add(runnable);
            } else {
                Runnable runnable = IOExceptionRunnable.asRunnable((IOExceptionRunnable)new IOExceptionRunnable(zipCache, jarFile){
                    final /* synthetic */ FileCacheByPath $zipCache;
                    final /* synthetic */ File $jarFile;

                    public final void run() {
                        this.$zipCache.remove(this.$jarFile);
                    }
                    {
                        this.$zipCache = fileCacheByPath;
                        this.$jarFile = file;
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)runnable, (String)"IOExceptionRunnable.asRu\u2026ipCache.remove(jarFile) }");
                cacheUpdate.add(runnable);
            }
            input2 = new LazyIncrementalFileMergerInput(jarFile.getAbsolutePath(), new CachedSupplier(new Supplier<T>(jarInput, zipCache){
                final /* synthetic */ JarInput $jarInput;
                final /* synthetic */ FileCacheByPath $zipCache;

                @NotNull
                public final ImmutableMap<RelativeFile, FileStatus> get() {
                    return IncrementalFileMergerTransformUtils.access$computeUpdates(this.$jarInput, this.$zipCache);
                }
                {
                    this.$jarInput = jarInput;
                    this.$zipCache = fileCacheByPath;
                }
            }), new CachedSupplier(new Supplier<T>(jarInput){
                final /* synthetic */ JarInput $jarInput;

                @NotNull
                public final ImmutableSet<RelativeFile> get() {
                    return IncrementalFileMergerTransformUtils.access$computeFiles(this.$jarInput);
                }
                {
                    this.$jarInput = jarInput;
                }
            }));
            Map<IncrementalFileMergerInput, QualifiedContent> map2 = contentMap;
            if (map2 == null) break block2;
            Map<IncrementalFileMergerInput, QualifiedContent> map3 = it = (map = map2);
            LazyIncrementalFileMergerInput lazyIncrementalFileMergerInput = input2;
            JarInput jarInput2 = jarInput;
            map3.put((IncrementalFileMergerInput)lazyIncrementalFileMergerInput, (QualifiedContent)jarInput2);
        }
        return (IncrementalFileMergerInput)input2;
    }

    @NotNull
    public static final IncrementalFileMergerInput toIncrementalInput(@NotNull DirectoryInput directoryInput, @Nullable Map<IncrementalFileMergerInput, QualifiedContent> contentMap) {
        LazyIncrementalFileMergerInput input2;
        block0: {
            Map<IncrementalFileMergerInput, QualifiedContent> map;
            Map<IncrementalFileMergerInput, QualifiedContent> it;
            Intrinsics.checkParameterIsNotNull((Object)directoryInput, (String)"directoryInput");
            File file = directoryInput.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"directoryInput.file");
            input2 = new LazyIncrementalFileMergerInput(file.getAbsolutePath(), new CachedSupplier(new Supplier<T>(directoryInput){
                final /* synthetic */ DirectoryInput $directoryInput;

                @NotNull
                public final ImmutableMap<RelativeFile, FileStatus> get() {
                    return IncrementalFileMergerTransformUtils.access$computeUpdates(this.$directoryInput);
                }
                {
                    this.$directoryInput = directoryInput;
                }
            }), new CachedSupplier(new Supplier<T>(directoryInput){
                final /* synthetic */ DirectoryInput $directoryInput;

                @NotNull
                public final ImmutableSet<RelativeFile> get() {
                    return IncrementalFileMergerTransformUtils.access$computeFiles(this.$directoryInput);
                }
                {
                    this.$directoryInput = directoryInput;
                }
            }));
            Map<IncrementalFileMergerInput, QualifiedContent> map2 = contentMap;
            if (map2 == null) break block0;
            Map<IncrementalFileMergerInput, QualifiedContent> map3 = it = (map = map2);
            LazyIncrementalFileMergerInput lazyIncrementalFileMergerInput = input2;
            DirectoryInput directoryInput2 = directoryInput;
            map3.put((IncrementalFileMergerInput)lazyIncrementalFileMergerInput, (QualifiedContent)directoryInput2);
        }
        return (IncrementalFileMergerInput)input2;
    }

    @Nullable
    public static final IncrementalFileMergerInput toNonIncrementalInput(@NotNull JarInput jarInput, @NotNull FileCacheByPath zipCache, @NotNull List<Runnable> cacheUpdate, @Nullable Map<IncrementalFileMergerInput, QualifiedContent> contentMap) {
        LazyIncrementalFileMergerInput input2;
        block1: {
            Map<IncrementalFileMergerInput, QualifiedContent> map;
            Map<IncrementalFileMergerInput, QualifiedContent> it;
            File jarFile;
            Intrinsics.checkParameterIsNotNull((Object)jarInput, (String)"jarInput");
            Intrinsics.checkParameterIsNotNull((Object)zipCache, (String)"zipCache");
            Intrinsics.checkParameterIsNotNull(cacheUpdate, (String)"cacheUpdate");
            File file = jarFile = jarInput.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"jarFile");
            if (!file.isFile()) {
                return null;
            }
            Runnable runnable = IOExceptionRunnable.asRunnable((IOExceptionRunnable)new IOExceptionRunnable(zipCache, jarFile){
                final /* synthetic */ FileCacheByPath $zipCache;
                final /* synthetic */ File $jarFile;

                public final void run() {
                    this.$zipCache.add(this.$jarFile);
                }
                {
                    this.$zipCache = fileCacheByPath;
                    this.$jarFile = file;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)runnable, (String)"IOExceptionRunnable.asRu\u2026{ zipCache.add(jarFile) }");
            cacheUpdate.add(runnable);
            input2 = LazyIncrementalFileMergerInputs.fromNew((String)jarFile.getAbsolutePath(), (Set)((Set)ImmutableSet.of((Object)jarFile)));
            Map<IncrementalFileMergerInput, QualifiedContent> map2 = contentMap;
            if (map2 == null) break block1;
            Map<IncrementalFileMergerInput, QualifiedContent> map3 = it = (map = map2);
            LazyIncrementalFileMergerInput lazyIncrementalFileMergerInput = input2;
            Intrinsics.checkExpressionValueIsNotNull((Object)lazyIncrementalFileMergerInput, (String)"input");
            LazyIncrementalFileMergerInput lazyIncrementalFileMergerInput2 = lazyIncrementalFileMergerInput;
            JarInput jarInput2 = jarInput;
            map3.put((IncrementalFileMergerInput)lazyIncrementalFileMergerInput2, (QualifiedContent)jarInput2);
        }
        return (IncrementalFileMergerInput)input2;
    }

    @Nullable
    public static final IncrementalFileMergerInput toNonIncrementalInput(@NotNull DirectoryInput directoryInput, @Nullable Map<IncrementalFileMergerInput, QualifiedContent> contentMap) {
        LazyIncrementalFileMergerInput input2;
        block1: {
            Map<IncrementalFileMergerInput, QualifiedContent> map;
            Map<IncrementalFileMergerInput, QualifiedContent> it;
            File dirFile;
            Intrinsics.checkParameterIsNotNull((Object)directoryInput, (String)"directoryInput");
            File file = dirFile = directoryInput.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"dirFile");
            if (!file.isDirectory()) {
                return null;
            }
            input2 = LazyIncrementalFileMergerInputs.fromNew((String)dirFile.getAbsolutePath(), (Set)((Set)ImmutableSet.of((Object)dirFile)));
            Map<IncrementalFileMergerInput, QualifiedContent> map2 = contentMap;
            if (map2 == null) break block1;
            Map<IncrementalFileMergerInput, QualifiedContent> map3 = it = (map = map2);
            LazyIncrementalFileMergerInput lazyIncrementalFileMergerInput = input2;
            Intrinsics.checkExpressionValueIsNotNull((Object)lazyIncrementalFileMergerInput, (String)"input");
            LazyIncrementalFileMergerInput lazyIncrementalFileMergerInput2 = lazyIncrementalFileMergerInput;
            DirectoryInput directoryInput2 = directoryInput;
            map3.put((IncrementalFileMergerInput)lazyIncrementalFileMergerInput2, (QualifiedContent)directoryInput2);
        }
        return (IncrementalFileMergerInput)input2;
    }

    private static final ImmutableMap<RelativeFile, FileStatus> computeUpdates(JarInput jarInput, FileCacheByPath zipCache) {
        try {
            Status status = jarInput.getStatus();
            if (status != null) {
                switch (IncrementalFileMergerTransformUtils$WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                    case 1: {
                        ImmutableMap immutableMap = IncrementalRelativeFileSets.fromZip((File)jarInput.getFile(), (FileStatus)FileStatus.NEW);
                        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"IncrementalRelativeFileS\u2026eStatus.NEW\n            )");
                        return immutableMap;
                    }
                    case 2: {
                        File file = zipCache.get(jarInput.getFile());
                        if (file == null) {
                            throw (Throwable)new RuntimeException("File '" + jarInput.getFile() + "' was " + "deleted, but previous version not found in cache");
                        }
                        File cached = file;
                        ImmutableMap immutableMap = IncrementalRelativeFileSets.fromZip((File)cached, (FileStatus)FileStatus.REMOVED);
                        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"IncrementalRelativeFileS\u2026ched, FileStatus.REMOVED)");
                        return immutableMap;
                    }
                    case 3: {
                        ImmutableMap immutableMap = IncrementalRelativeFileSets.fromZip((File)jarInput.getFile(), (FileCacheByPath)zipCache, (Set)new HashSet());
                        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"IncrementalRelativeFileS\u2026  HashSet()\n            )");
                        return immutableMap;
                    }
                    case 4: {
                        ImmutableMap immutableMap = ImmutableMap.of();
                        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"ImmutableMap.of()");
                        return immutableMap;
                    }
                }
            }
            throw (Throwable)((Object)new AssertionError());
        }
        catch (IOException e) {
            throw (Throwable)new UncheckedIOException(e);
        }
    }

    private static final ImmutableSet<RelativeFile> computeFiles(JarInput jarInput) {
        File jar;
        File file = jar = jarInput.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"jar");
        boolean bl = file.isFile();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        try {
            ImmutableSet immutableSet = RelativeFiles.fromZip((File)jar);
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet, (String)"RelativeFiles.fromZip(jar)");
            return immutableSet;
        }
        catch (IOException e) {
            throw (Throwable)new UncheckedIOException(e);
        }
    }

    private static final ImmutableMap<RelativeFile, FileStatus> computeUpdates(DirectoryInput directoryInput) {
        Map changedFiles;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Map map = changedFiles = directoryInput.getChangedFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"changedFiles");
        Map map2 = map;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            File key = (File)entry2.getKey();
            entry2 = entry;
            Status value = (Status)entry2.getValue();
            RelativeFile rf = new RelativeFile(directoryInput.getFile(), key);
            Status status = value;
            Intrinsics.checkExpressionValueIsNotNull((Object)status, (String)"value");
            FileStatus status2 = IncrementalFileMergerTransformUtils.mapStatus(status);
            if (status2 == null || new File(rf.getBase(), rf.getRelativePath()).isDirectory()) continue;
            builder.put((Object)rf, (Object)status2);
        }
        ImmutableMap immutableMap = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"builder.build()");
        return immutableMap;
    }

    private static final ImmutableSet<RelativeFile> computeFiles(DirectoryInput directoryInput) {
        File dir;
        File file = dir = directoryInput.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"dir");
        boolean bl = file.isDirectory();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ImmutableSet immutableSet = RelativeFiles.fromDirectory((File)dir);
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet, (String)"RelativeFiles.fromDirectory(dir)");
        return immutableSet;
    }

    @NotNull
    public static final ImmutableList<IncrementalFileMergerInput> toIncrementalInput(@NotNull TransformInput transformInput, @NotNull FileCacheByPath zipCache, @NotNull List<Runnable> cacheUpdates, @Nullable Map<IncrementalFileMergerInput, QualifiedContent> contentMap) {
        Intrinsics.checkParameterIsNotNull((Object)transformInput, (String)"transformInput");
        Intrinsics.checkParameterIsNotNull((Object)zipCache, (String)"zipCache");
        Intrinsics.checkParameterIsNotNull(cacheUpdates, (String)"cacheUpdates");
        ImmutableList.Builder builder = ImmutableList.builder();
        Iterator iterator = transformInput.getJarInputs().iterator();
        while (iterator.hasNext()) {
            JarInput jarInput;
            JarInput jarInput2 = jarInput = (JarInput)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)jarInput2, (String)"jarInput");
            builder.add((Object)IncrementalFileMergerTransformUtils.toIncrementalInput(jarInput2, zipCache, cacheUpdates, contentMap));
        }
        iterator = transformInput.getDirectoryInputs().iterator();
        while (iterator.hasNext()) {
            DirectoryInput dirInput;
            DirectoryInput directoryInput = dirInput = (DirectoryInput)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)directoryInput, (String)"dirInput");
            builder.add((Object)IncrementalFileMergerTransformUtils.toIncrementalInput(directoryInput, contentMap));
        }
        ImmutableList immutableList = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"builder.build()");
        return immutableList;
    }

    @NotNull
    public static final ImmutableList<IncrementalFileMergerInput> toNonIncrementalInput(@NotNull TransformInput transformInput, @NotNull FileCacheByPath zipCache, @NotNull List<Runnable> cacheUpdates, @Nullable Map<IncrementalFileMergerInput, QualifiedContent> contentMap) {
        IncrementalFileMergerInput it;
        IncrementalFileMergerInput incrementalFileMergerInput;
        Intrinsics.checkParameterIsNotNull((Object)transformInput, (String)"transformInput");
        Intrinsics.checkParameterIsNotNull((Object)zipCache, (String)"zipCache");
        Intrinsics.checkParameterIsNotNull(cacheUpdates, (String)"cacheUpdates");
        ImmutableList.Builder builder = ImmutableList.builder();
        Collection collection = transformInput.getJarInputs();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"transformInput.jarInputs");
        Iterable $receiver$iv = collection;
        for (Object element$iv : $receiver$iv) {
            JarInput jarInput;
            JarInput jarInput2 = jarInput = (JarInput)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)jarInput2, (String)"jarInput");
            if (IncrementalFileMergerTransformUtils.toNonIncrementalInput(jarInput2, zipCache, cacheUpdates, contentMap) == null) continue;
            it = incrementalFileMergerInput;
            builder.add((Object)it);
        }
        Collection collection2 = transformInput.getDirectoryInputs();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"transformInput.directoryInputs");
        $receiver$iv = collection2;
        for (Object element$iv : $receiver$iv) {
            DirectoryInput dirInput;
            DirectoryInput directoryInput = dirInput = (DirectoryInput)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)directoryInput, (String)"dirInput");
            if (IncrementalFileMergerTransformUtils.toNonIncrementalInput(directoryInput, contentMap) == null) continue;
            it = incrementalFileMergerInput;
            builder.add((Object)it);
        }
        ImmutableList immutableList = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"builder.build()");
        return immutableList;
    }

    @NotNull
    public static final ImmutableList<IncrementalFileMergerInput> toInput(@NotNull TransformInvocation transformInvocation, @NotNull FileCacheByPath zipCache, @NotNull List<Runnable> cacheUpdates, boolean full, @Nullable Map<IncrementalFileMergerInput, QualifiedContent> contentMap) {
        Intrinsics.checkParameterIsNotNull((Object)transformInvocation, (String)"transformInvocation");
        Intrinsics.checkParameterIsNotNull((Object)zipCache, (String)"zipCache");
        Intrinsics.checkParameterIsNotNull(cacheUpdates, (String)"cacheUpdates");
        if (!full) {
            Preconditions.checkArgument((boolean)transformInvocation.isIncremental());
        }
        if (full) {
            Runnable runnable = IOExceptionRunnable.asRunnable((IOExceptionRunnable)new IOExceptionRunnable(zipCache){
                final /* synthetic */ FileCacheByPath $zipCache;

                public final void run() {
                    this.$zipCache.clear();
                }
                {
                    this.$zipCache = fileCacheByPath;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)runnable, (String)"IOExceptionRunnable.asRu\u2026able { zipCache.clear() }");
            cacheUpdates.add(runnable);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TransformInput input2 : transformInvocation.getInputs()) {
            if (full) {
                TransformInput transformInput = input2;
                Intrinsics.checkExpressionValueIsNotNull((Object)transformInput, (String)"input");
                builder.addAll((Iterable)IncrementalFileMergerTransformUtils.toNonIncrementalInput(transformInput, zipCache, cacheUpdates, contentMap));
                continue;
            }
            TransformInput transformInput = input2;
            Intrinsics.checkExpressionValueIsNotNull((Object)transformInput, (String)"input");
            builder.addAll((Iterable)IncrementalFileMergerTransformUtils.toIncrementalInput(transformInput, zipCache, cacheUpdates, contentMap));
        }
        ImmutableList immutableList = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"builder.build()");
        return immutableList;
    }

    private static final FileStatus mapStatus(Status status) {
        FileStatus fileStatus;
        switch (IncrementalFileMergerTransformUtils$WhenMappings.$EnumSwitchMapping$1[status.ordinal()]) {
            case 1: {
                fileStatus = FileStatus.NEW;
                break;
            }
            case 2: {
                fileStatus = FileStatus.CHANGED;
                break;
            }
            case 3: {
                fileStatus = null;
                break;
            }
            case 4: {
                fileStatus = FileStatus.REMOVED;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return fileStatus;
    }

    @NotNull
    public static final /* synthetic */ ImmutableMap access$computeUpdates(@NotNull JarInput jarInput, @NotNull FileCacheByPath zipCache) {
        return IncrementalFileMergerTransformUtils.computeUpdates(jarInput, zipCache);
    }

    @NotNull
    public static final /* synthetic */ ImmutableSet access$computeFiles(@NotNull JarInput jarInput) {
        return IncrementalFileMergerTransformUtils.computeFiles(jarInput);
    }

    @NotNull
    public static final /* synthetic */ ImmutableMap access$computeUpdates(@NotNull DirectoryInput directoryInput) {
        return IncrementalFileMergerTransformUtils.computeUpdates(directoryInput);
    }

    @NotNull
    public static final /* synthetic */ ImmutableSet access$computeFiles(@NotNull DirectoryInput directoryInput) {
        return IncrementalFileMergerTransformUtils.computeFiles(directoryInput);
    }
}

