/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.ide.common.build.ApkInfo;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import kotlin.jvm.functions.Function2;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.BuildException;
import org.gradle.workers.WorkerExecutor;

public class CopyOutputs
extends AndroidVariantTask {
    BuildableArtifact fullApks;
    BuildableArtifact abiSplits;
    BuildableArtifact resourcesSplits;
    File destinationDir;
    WorkerExecutorFacade workerExecutorFacade;

    @Inject
    public CopyOutputs(WorkerExecutor workerExecutor) {
        this.workerExecutorFacade = Workers.INSTANCE.getWorker(workerExecutor);
    }

    @OutputDirectory
    public File getDestinationDir() {
        return this.destinationDir;
    }

    @InputFiles
    public BuildableArtifact getFullApks() {
        return this.fullApks;
    }

    @InputFiles
    @Optional
    public BuildableArtifact getAbiSplits() {
        return this.abiSplits;
    }

    @InputFiles
    @Optional
    public BuildableArtifact getResourcesSplits() {
        return this.resourcesSplits;
    }

    @TaskAction
    protected void copy() throws IOException {
        FileUtils.cleanOutputDir((File)this.getDestinationDir());
        this.workerExecutorFacade.submit(CopyOutputsRunnable.class, (Serializable)new CopyOutputsParams(InternalArtifactType.FULL_APK, (FileCollection)this.fullApks.get(), this.getDestinationDir()));
        this.workerExecutorFacade.submit(CopyOutputsRunnable.class, (Serializable)new CopyOutputsParams(InternalArtifactType.ABI_PACKAGED_SPLIT, (FileCollection)this.abiSplits.get(), this.getDestinationDir()));
        this.workerExecutorFacade.submit(CopyOutputsRunnable.class, (Serializable)new CopyOutputsParams(InternalArtifactType.DENSITY_OR_LANGUAGE_PACKAGED_SPLIT, (FileCollection)this.resourcesSplits.get(), this.getDestinationDir()));
        this.workerExecutorFacade.close();
    }

    static class CopyOutputsParams
    implements Serializable {
        private final InternalArtifactType inputType;
        private final FileCollection inputs;
        private final File destinationDir;

        CopyOutputsParams(InternalArtifactType inputType, FileCollection inputs, File destinationDir) {
            this.inputType = inputType;
            this.inputs = inputs;
            this.destinationDir = destinationDir;
        }
    }

    static class CopyOutputsRunnable
    implements Runnable {
        private final CopyOutputsParams params;

        @Inject
        CopyOutputsRunnable(CopyOutputsParams params) {
            this.params = params;
        }

        private static synchronized void appendOutput(Collection<BuildOutput> outputs, File destinationDir) throws IOException {
            ArrayList<BuildOutput> buildOutputs = new ArrayList<BuildOutput>(outputs);
            buildOutputs.addAll(ExistingBuildElements.from(destinationDir).getElements());
            new BuildElements(buildOutputs).save(destinationDir);
        }

        @Override
        public void run() {
            try {
                CopyOutputsRunnable.appendOutput(CopyOutputsRunnable.copy(this.params.inputType, this.params.inputs, this.params.destinationDir).getElements(), this.params.destinationDir);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private static BuildElements copy(InternalArtifactType inputType, FileCollection inputs, File destinationDir) {
            return ExistingBuildElements.from((ArtifactType)inputType, inputs).transform((Function2<? super ApkInfo, ? super File, ? extends File>)((Function2)(apkInfo, inputFile) -> {
                File destination = new File(destinationDir, inputFile.getName());
                try {
                    FileUtils.copyFile((File)inputFile, (File)destination);
                }
                catch (IOException e) {
                    throw new BuildException(e.getMessage(), (Throwable)e);
                }
                return destination;
            })).into(InternalArtifactType.APK);
        }
    }

    public static class CreationAction
    extends VariantTaskCreationAction<CopyOutputs> {
        private final File destinationDir;

        public CreationAction(VariantScope variantScope, File destinationDir) {
            super(variantScope);
            this.destinationDir = destinationDir;
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("copyOutputs");
        }

        @Override
        public Class<CopyOutputs> getType() {
            return CopyOutputs.class;
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            this.getVariantScope().getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.APK, (Collection<? extends Object>)ImmutableList.of((Object)this.destinationDir), taskName);
        }

        @Override
        public void configure(CopyOutputs task) {
            super.configure(task);
            BuildArtifactsHolder artifacts = this.getVariantScope().getArtifacts();
            task.fullApks = artifacts.getFinalArtifactFiles(InternalArtifactType.FULL_APK);
            task.abiSplits = artifacts.getFinalArtifactFiles(InternalArtifactType.ABI_PACKAGED_SPLIT);
            task.resourcesSplits = artifacts.getFinalArtifactFiles(InternalArtifactType.DENSITY_OR_LANGUAGE_PACKAGED_SPLIT);
            task.destinationDir = this.destinationDir;
        }
    }
}

