/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.FeatureExtension;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.dsl.BaseAppModuleExtension;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.process.JarSigner;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.PackageBundleTaskKt;
import com.android.build.gradle.internal.tasks.SigningConfigMetadata;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.StringOption;
import com.android.builder.packaging.PackagingUtils;
import com.android.bundle.Config;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.tools.build.bundletool.commands.BuildBundleCommand;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001:\u0005<=>?@B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010:\u001a\u00020;H\u0007R2\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068G@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR&\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\r8G@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R&\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00168G@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8G\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR&\u0010!\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020 8G@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R&\u0010'\u001a\u00020&2\u0006\u0010\u0005\u001a\u00020&8G@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020\u00078G\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R*\u0010/\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\r8G@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0010\"\u0004\b1\u0010\u0012R*\u00102\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\r8G@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u0010\"\u0004\b4\u0010\u0012R*\u00105\u001a\u0004\u0018\u00010&2\b\u0010\u0005\u001a\u0004\u0018\u00010&8G@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010)\"\u0004\b7\u0010+R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageBundleTask;", "Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "<set-?>", "", "", "aaptOptionsNoCompress", "getAaptOptionsNoCompress", "()Ljava/util/Collection;", "setAaptOptionsNoCompress", "(Ljava/util/Collection;)V", "Lcom/android/build/api/artifact/BuildableArtifact;", "baseModuleZip", "getBaseModuleZip", "()Lcom/android/build/api/artifact/BuildableArtifact;", "setBaseModuleZip", "(Lcom/android/build/api/artifact/BuildableArtifact;)V", "bundleFile", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleFlags;", "bundleFlags", "getBundleFlags", "()Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleFlags;", "setBundleFlags", "(Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleFlags;)V", "bundleLocation", "Ljava/io/File;", "getBundleLocation", "()Ljava/io/File;", "Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleOptions;", "bundleOptions", "getBundleOptions", "()Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleOptions;", "setBundleOptions", "(Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleOptions;)V", "Lorg/gradle/api/file/FileCollection;", "featureZips", "getFeatureZips", "()Lorg/gradle/api/file/FileCollection;", "setFeatureZips", "(Lorg/gradle/api/file/FileCollection;)V", "fileName", "getFileName", "()Ljava/lang/String;", "mainDexList", "getMainDexList", "setMainDexList", "obsfuscationMappingFile", "getObsfuscationMappingFile", "setObsfuscationMappingFile", "signingConfig", "getSigningConfig", "setSigningConfig", "workers", "Lcom/android/ide/common/workers/WorkerExecutorFacade;", "bundleModules", "", "BundleFlags", "BundleOptions", "BundleToolRunnable", "CreationAction", "Params", "gradle"})
public class PackageBundleTask
extends AndroidVariantTask {
    private final WorkerExecutorFacade workers;
    @NotNull
    private BuildableArtifact baseModuleZip;
    @NotNull
    private FileCollection featureZips;
    @Nullable
    private BuildableArtifact mainDexList;
    @Nullable
    private BuildableArtifact obsfuscationMappingFile;
    @NotNull
    private Collection<String> aaptOptionsNoCompress;
    @NotNull
    private BundleOptions bundleOptions;
    @NotNull
    private BundleFlags bundleFlags;
    @Nullable
    private FileCollection signingConfig;
    private Provider<RegularFile> bundleFile;

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public final BuildableArtifact getBaseModuleZip() {
        BuildableArtifact buildableArtifact = this.baseModuleZip;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"baseModuleZip");
        }
        return buildableArtifact;
    }

    private final void setBaseModuleZip(BuildableArtifact buildableArtifact) {
        this.baseModuleZip = buildableArtifact;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public final FileCollection getFeatureZips() {
        FileCollection fileCollection = this.featureZips;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureZips");
        }
        return fileCollection;
    }

    private final void setFeatureZips(FileCollection fileCollection) {
        this.featureZips = fileCollection;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @Nullable
    public final BuildableArtifact getMainDexList() {
        return this.mainDexList;
    }

    private final void setMainDexList(BuildableArtifact buildableArtifact) {
        this.mainDexList = buildableArtifact;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @Nullable
    public final BuildableArtifact getObsfuscationMappingFile() {
        return this.obsfuscationMappingFile;
    }

    private final void setObsfuscationMappingFile(BuildableArtifact buildableArtifact) {
        this.obsfuscationMappingFile = buildableArtifact;
    }

    @Input
    @NotNull
    public final Collection<String> getAaptOptionsNoCompress() {
        Collection<String> collection = this.aaptOptionsNoCompress;
        if (collection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aaptOptionsNoCompress");
        }
        return collection;
    }

    private final void setAaptOptionsNoCompress(Collection<String> collection) {
        this.aaptOptionsNoCompress = collection;
    }

    @Nested
    @NotNull
    public final BundleOptions getBundleOptions() {
        BundleOptions bundleOptions = this.bundleOptions;
        if (bundleOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleOptions");
        }
        return bundleOptions;
    }

    private final void setBundleOptions(BundleOptions bundleOptions) {
        this.bundleOptions = bundleOptions;
    }

    @Nested
    @NotNull
    public final BundleFlags getBundleFlags() {
        BundleFlags bundleFlags = this.bundleFlags;
        if (bundleFlags == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFlags");
        }
        return bundleFlags;
    }

    private final void setBundleFlags(BundleFlags bundleFlags) {
        this.bundleFlags = bundleFlags;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @Optional
    @Nullable
    public final FileCollection getSigningConfig() {
        return this.signingConfig;
    }

    private final void setSigningConfig(FileCollection fileCollection) {
        this.signingConfig = fileCollection;
    }

    @OutputDirectory
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public final File getBundleLocation() {
        Provider<RegularFile> provider = this.bundleFile;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFile");
        }
        Object object = provider.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"bundleFile.get()");
        File file = ((RegularFile)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"bundleFile.get().asFile");
        File file2 = file.getParentFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"bundleFile.get().asFile.parentFile");
        return file2;
    }

    @Input
    @NotNull
    public final String getFileName() {
        Provider<RegularFile> provider = this.bundleFile;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFile");
        }
        Object object = provider.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"bundleFile.get()");
        File file = ((RegularFile)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"bundleFile.get().asFile");
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"bundleFile.get().asFile.name");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void bundleModules() {
        JarSigner.Signature signature;
        SigningConfig config2 = SigningConfigMetadata.Companion.load(this.signingConfig);
        if (config2 != null && config2.getStoreFile() != null) {
            File file = config2.getStoreFile();
            if (file == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"config.storeFile!!");
            signature = new JarSigner.Signature(file, config2.getStorePassword(), config2.getKeyAlias(), config2.getKeyPassword());
        } else {
            signature = null;
        }
        JarSigner.Signature signature2 = signature;
        Closeable closeable = (Closeable)this.workers;
        Throwable throwable = null;
        try {
            WorkerExecutorFacade it = (WorkerExecutorFacade)closeable;
            BuildableArtifact buildableArtifact = this.baseModuleZip;
            if (buildableArtifact == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"baseModuleZip");
            }
            File file = BuildableArtifactUtil.singleFile(buildableArtifact);
            FileCollection fileCollection = this.featureZips;
            if (fileCollection == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"featureZips");
            }
            Set set = fileCollection.getFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"featureZips.files");
            BuildableArtifact buildableArtifact2 = this.mainDexList;
            File file2 = buildableArtifact2 != null ? BuildableArtifactUtil.singleFile(buildableArtifact2) : null;
            BuildableArtifact buildableArtifact3 = this.obsfuscationMappingFile;
            File file3 = buildableArtifact3 != null ? BuildableArtifactUtil.singleFile(buildableArtifact3) : null;
            Collection<String> collection = this.aaptOptionsNoCompress;
            if (collection == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"aaptOptionsNoCompress");
            }
            BundleOptions bundleOptions = this.bundleOptions;
            if (bundleOptions == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bundleOptions");
            }
            BundleFlags bundleFlags = this.bundleFlags;
            if (bundleFlags == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFlags");
            }
            Provider<RegularFile> provider = this.bundleFile;
            if (provider == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFile");
            }
            Object object = provider.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"bundleFile.get()");
            File file4 = ((RegularFile)object).getAsFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"bundleFile.get().asFile");
            it.submit(BundleToolRunnable.class, (Serializable)new Params(file, set, file2, file3, collection, bundleOptions, bundleFlags, signature2, file4));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Inject
    public PackageBundleTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkParameterIsNotNull((Object)workerExecutor, (String)"workerExecutor");
        this.workers = Workers.getWorker$default(Workers.INSTANCE, workerExecutor, null, 2, null);
    }

    @NotNull
    public static final /* synthetic */ Provider access$getBundleFile$p(PackageBundleTask $this) {
        Provider<RegularFile> provider = $this.bundleFile;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFile");
        }
        return provider;
    }

    @NotNull
    public static final /* synthetic */ BuildableArtifact access$getBaseModuleZip$p(PackageBundleTask $this) {
        BuildableArtifact buildableArtifact = $this.baseModuleZip;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"baseModuleZip");
        }
        return buildableArtifact;
    }

    @NotNull
    public static final /* synthetic */ FileCollection access$getFeatureZips$p(PackageBundleTask $this) {
        FileCollection fileCollection = $this.featureZips;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureZips");
        }
        return fileCollection;
    }

    @NotNull
    public static final /* synthetic */ Collection access$getAaptOptionsNoCompress$p(PackageBundleTask $this) {
        Collection<String> collection = $this.aaptOptionsNoCompress;
        if (collection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aaptOptionsNoCompress");
        }
        return collection;
    }

    @NotNull
    public static final /* synthetic */ BundleOptions access$getBundleOptions$p(PackageBundleTask $this) {
        BundleOptions bundleOptions = $this.bundleOptions;
        if (bundleOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleOptions");
        }
        return bundleOptions;
    }

    @NotNull
    public static final /* synthetic */ BundleFlags access$getBundleFlags$p(PackageBundleTask $this) {
        BundleFlags bundleFlags = $this.bundleFlags;
        if (bundleFlags == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFlags");
        }
        return bundleFlags;
    }

    @Nullable
    public static final /* synthetic */ BuildableArtifact access$getMainDexList$p(PackageBundleTask $this) {
        return $this.mainDexList;
    }

    @Nullable
    public static final /* synthetic */ BuildableArtifact access$getObsfuscationMappingFile$p(PackageBundleTask $this) {
        return $this.obsfuscationMappingFile;
    }

    @Nullable
    public static final /* synthetic */ FileCollection access$getSigningConfig$p(PackageBundleTask $this) {
        return $this.signingConfig;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0012J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010&\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\t\u0010'\u001a\u00020\fH\u00c6\u0003J\t\u0010(\u001a\u00020\u000eH\u00c6\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003Ju\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/H\u00d6\u0003J\t\u00100\u001a\u000201H\u00d6\u0001J\t\u00102\u001a\u00020\nH\u00d6\u0001R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0016R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u00063"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageBundleTask$Params;", "Ljava/io/Serializable;", "baseModuleFile", "Ljava/io/File;", "featureFiles", "", "mainDexList", "obfuscationMappingFile", "aaptOptionsNoCompress", "", "", "bundleOptions", "Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleOptions;", "bundleFlags", "Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleFlags;", "signature", "Lcom/android/build/gradle/internal/process/JarSigner$Signature;", "bundleFile", "(Ljava/io/File;Ljava/util/Set;Ljava/io/File;Ljava/io/File;Ljava/util/Collection;Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleOptions;Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleFlags;Lcom/android/build/gradle/internal/process/JarSigner$Signature;Ljava/io/File;)V", "getAaptOptionsNoCompress", "()Ljava/util/Collection;", "getBaseModuleFile", "()Ljava/io/File;", "getBundleFile", "getBundleFlags", "()Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleFlags;", "getBundleOptions", "()Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleOptions;", "getFeatureFiles", "()Ljava/util/Set;", "getMainDexList", "getObfuscationMappingFile", "getSignature", "()Lcom/android/build/gradle/internal/process/JarSigner$Signature;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "", "hashCode", "", "toString", "gradle"})
    private static final class Params
    implements Serializable {
        @NotNull
        private final File baseModuleFile;
        @NotNull
        private final Set<File> featureFiles;
        @Nullable
        private final File mainDexList;
        @Nullable
        private final File obfuscationMappingFile;
        @NotNull
        private final Collection<String> aaptOptionsNoCompress;
        @NotNull
        private final BundleOptions bundleOptions;
        @NotNull
        private final BundleFlags bundleFlags;
        @Nullable
        private final JarSigner.Signature signature;
        @NotNull
        private final File bundleFile;

        @NotNull
        public final File getBaseModuleFile() {
            return this.baseModuleFile;
        }

        @NotNull
        public final Set<File> getFeatureFiles() {
            return this.featureFiles;
        }

        @Nullable
        public final File getMainDexList() {
            return this.mainDexList;
        }

        @Nullable
        public final File getObfuscationMappingFile() {
            return this.obfuscationMappingFile;
        }

        @NotNull
        public final Collection<String> getAaptOptionsNoCompress() {
            return this.aaptOptionsNoCompress;
        }

        @NotNull
        public final BundleOptions getBundleOptions() {
            return this.bundleOptions;
        }

        @NotNull
        public final BundleFlags getBundleFlags() {
            return this.bundleFlags;
        }

        @Nullable
        public final JarSigner.Signature getSignature() {
            return this.signature;
        }

        @NotNull
        public final File getBundleFile() {
            return this.bundleFile;
        }

        public Params(@NotNull File baseModuleFile, @NotNull Set<? extends File> featureFiles, @Nullable File mainDexList, @Nullable File obfuscationMappingFile, @NotNull Collection<String> aaptOptionsNoCompress, @NotNull BundleOptions bundleOptions, @NotNull BundleFlags bundleFlags, @Nullable JarSigner.Signature signature, @NotNull File bundleFile) {
            Intrinsics.checkParameterIsNotNull((Object)baseModuleFile, (String)"baseModuleFile");
            Intrinsics.checkParameterIsNotNull(featureFiles, (String)"featureFiles");
            Intrinsics.checkParameterIsNotNull(aaptOptionsNoCompress, (String)"aaptOptionsNoCompress");
            Intrinsics.checkParameterIsNotNull((Object)bundleOptions, (String)"bundleOptions");
            Intrinsics.checkParameterIsNotNull((Object)bundleFlags, (String)"bundleFlags");
            Intrinsics.checkParameterIsNotNull((Object)bundleFile, (String)"bundleFile");
            this.baseModuleFile = baseModuleFile;
            this.featureFiles = featureFiles;
            this.mainDexList = mainDexList;
            this.obfuscationMappingFile = obfuscationMappingFile;
            this.aaptOptionsNoCompress = aaptOptionsNoCompress;
            this.bundleOptions = bundleOptions;
            this.bundleFlags = bundleFlags;
            this.signature = signature;
            this.bundleFile = bundleFile;
        }

        @NotNull
        public final File component1() {
            return this.baseModuleFile;
        }

        @NotNull
        public final Set<File> component2() {
            return this.featureFiles;
        }

        @Nullable
        public final File component3() {
            return this.mainDexList;
        }

        @Nullable
        public final File component4() {
            return this.obfuscationMappingFile;
        }

        @NotNull
        public final Collection<String> component5() {
            return this.aaptOptionsNoCompress;
        }

        @NotNull
        public final BundleOptions component6() {
            return this.bundleOptions;
        }

        @NotNull
        public final BundleFlags component7() {
            return this.bundleFlags;
        }

        @Nullable
        public final JarSigner.Signature component8() {
            return this.signature;
        }

        @NotNull
        public final File component9() {
            return this.bundleFile;
        }

        @NotNull
        public final Params copy(@NotNull File baseModuleFile, @NotNull Set<? extends File> featureFiles, @Nullable File mainDexList, @Nullable File obfuscationMappingFile, @NotNull Collection<String> aaptOptionsNoCompress, @NotNull BundleOptions bundleOptions, @NotNull BundleFlags bundleFlags, @Nullable JarSigner.Signature signature, @NotNull File bundleFile) {
            Intrinsics.checkParameterIsNotNull((Object)baseModuleFile, (String)"baseModuleFile");
            Intrinsics.checkParameterIsNotNull(featureFiles, (String)"featureFiles");
            Intrinsics.checkParameterIsNotNull(aaptOptionsNoCompress, (String)"aaptOptionsNoCompress");
            Intrinsics.checkParameterIsNotNull((Object)bundleOptions, (String)"bundleOptions");
            Intrinsics.checkParameterIsNotNull((Object)bundleFlags, (String)"bundleFlags");
            Intrinsics.checkParameterIsNotNull((Object)bundleFile, (String)"bundleFile");
            return new Params(baseModuleFile, featureFiles, mainDexList, obfuscationMappingFile, aaptOptionsNoCompress, bundleOptions, bundleFlags, signature, bundleFile);
        }

        @NotNull
        public static /* synthetic */ Params copy$default(Params params, File file, Set set, File file2, File file3, Collection collection, BundleOptions bundleOptions, BundleFlags bundleFlags, JarSigner.Signature signature, File file4, int n, Object object) {
            if ((n & 1) != 0) {
                file = params.baseModuleFile;
            }
            if ((n & 2) != 0) {
                set = params.featureFiles;
            }
            if ((n & 4) != 0) {
                file2 = params.mainDexList;
            }
            if ((n & 8) != 0) {
                file3 = params.obfuscationMappingFile;
            }
            if ((n & 0x10) != 0) {
                collection = params.aaptOptionsNoCompress;
            }
            if ((n & 0x20) != 0) {
                bundleOptions = params.bundleOptions;
            }
            if ((n & 0x40) != 0) {
                bundleFlags = params.bundleFlags;
            }
            if ((n & 0x80) != 0) {
                signature = params.signature;
            }
            if ((n & 0x100) != 0) {
                file4 = params.bundleFile;
            }
            return params.copy(file, set, file2, file3, collection, bundleOptions, bundleFlags, signature, file4);
        }

        @NotNull
        public String toString() {
            return "Params(baseModuleFile=" + this.baseModuleFile + ", featureFiles=" + this.featureFiles + ", mainDexList=" + this.mainDexList + ", obfuscationMappingFile=" + this.obfuscationMappingFile + ", aaptOptionsNoCompress=" + this.aaptOptionsNoCompress + ", bundleOptions=" + this.bundleOptions + ", bundleFlags=" + this.bundleFlags + ", signature=" + this.signature + ", bundleFile=" + this.bundleFile + ")";
        }

        public int hashCode() {
            File file = this.baseModuleFile;
            Set<File> set = this.featureFiles;
            File file2 = this.mainDexList;
            File file3 = this.obfuscationMappingFile;
            Collection<String> collection = this.aaptOptionsNoCompress;
            BundleOptions bundleOptions = this.bundleOptions;
            BundleFlags bundleFlags = this.bundleFlags;
            JarSigner.Signature signature = this.signature;
            File file4 = this.bundleFile;
            return ((((((((file != null ? ((Object)file).hashCode() : 0) * 31 + (set != null ? ((Object)set).hashCode() : 0)) * 31 + (file2 != null ? ((Object)file2).hashCode() : 0)) * 31 + (file3 != null ? ((Object)file3).hashCode() : 0)) * 31 + (collection != null ? ((Object)collection).hashCode() : 0)) * 31 + (bundleOptions != null ? ((Object)bundleOptions).hashCode() : 0)) * 31 + (bundleFlags != null ? ((Object)bundleFlags).hashCode() : 0)) * 31 + (signature != null ? ((Object)signature).hashCode() : 0)) * 31 + (file4 != null ? ((Object)file4).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Params)) break block3;
                    Params params = (Params)object;
                    if (!Intrinsics.areEqual((Object)this.baseModuleFile, (Object)params.baseModuleFile) || !Intrinsics.areEqual(this.featureFiles, params.featureFiles) || !Intrinsics.areEqual((Object)this.mainDexList, (Object)params.mainDexList) || !Intrinsics.areEqual((Object)this.obfuscationMappingFile, (Object)params.obfuscationMappingFile) || !Intrinsics.areEqual(this.aaptOptionsNoCompress, params.aaptOptionsNoCompress) || !Intrinsics.areEqual((Object)this.bundleOptions, (Object)params.bundleOptions) || !Intrinsics.areEqual((Object)this.bundleFlags, (Object)params.bundleFlags) || !Intrinsics.areEqual((Object)this.signature, (Object)params.signature) || !Intrinsics.areEqual((Object)this.bundleFile, (Object)params.bundleFile)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleToolRunnable;", "Ljava/lang/Runnable;", "params", "Lcom/android/build/gradle/internal/tasks/PackageBundleTask$Params;", "(Lcom/android/build/gradle/internal/tasks/PackageBundleTask$Params;)V", "getBundlePath", "Ljava/nio/file/Path;", "folder", "Ljava/io/File;", "run", "", "gradle"})
    private static final class BundleToolRunnable
    implements Runnable {
        private final Params params;

        @Override
        public void run() {
            File it;
            File file;
            File bundleFile = this.params.getBundleFile();
            FileUtils.cleanOutputDir((File)bundleFile.getParentFile());
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)this.getBundlePath(this.params.getBaseModuleFile()));
            Iterable $receiver$iv = this.params.getFeatureFiles();
            for (Object element$iv : $receiver$iv) {
                File it2 = (File)element$iv;
                builder.add((Object)this.getBundlePath(it2));
            }
            List noCompressGlobsForBundle = PackagingUtils.getNoCompressGlobsForBundle(this.params.getAaptOptionsNoCompress());
            Config.SplitsConfig.Builder builder2 = Config.SplitsConfig.newBuilder();
            Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"Config.SplitsConfig.newBuilder()");
            Config.SplitsConfig.Builder splitsConfig = PackageBundleTaskKt.access$splitBy(PackageBundleTaskKt.access$splitBy(PackageBundleTaskKt.access$splitBy(builder2, Config.SplitDimension.Value.ABI, this.params.getBundleOptions().getEnableAbi()), Config.SplitDimension.Value.SCREEN_DENSITY, this.params.getBundleOptions().getEnableDensity()), Config.SplitDimension.Value.LANGUAGE, this.params.getBundleOptions().getEnableLanguage());
            Config.UncompressNativeLibraries.Builder uncompressNativeLibrariesConfig = Config.UncompressNativeLibraries.newBuilder().setEnabled(this.params.getBundleFlags().getEnableUncompressedNativeLibs());
            Config.BundleConfig.Builder bundleConfig = Config.BundleConfig.newBuilder().setCompression(Config.Compression.newBuilder().addAllUncompressedGlob((Iterable)noCompressGlobsForBundle)).setOptimizations(Config.Optimizations.newBuilder().setSplitsConfig(splitsConfig).setUncompressNativeLibraries(uncompressNativeLibrariesConfig));
            BuildBundleCommand.Builder command = BuildBundleCommand.builder().setBundleConfig(bundleConfig.build()).setOutputPath(bundleFile.toPath()).setModulesPaths(builder.build());
            File file2 = this.params.getMainDexList();
            if (file2 != null) {
                it = file = file2;
                command.setMainDexListFile(it.toPath());
            }
            File file3 = this.params.getObfuscationMappingFile();
            if (file3 != null) {
                it = file = file3;
                command.addMetadataFile("com.android.tools.build.obfuscation", "proguard.map", it.toPath());
            }
            command.build().execute();
            if (this.params.getSignature() != null) {
                new JarSigner().sign(bundleFile, this.params.getSignature());
            }
        }

        private final Path getBundlePath(File folder) {
            File[] children = folder.listFiles();
            Preconditions.checkNotNull((Object)children);
            Preconditions.checkState((children.length == 1 ? 1 : 0) != 0);
            Path path = children[0].toPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"children[0].toPath()");
            return path;
        }

        @Inject
        public BundleToolRunnable(@NotNull Params params) {
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            this.params = params;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ2\u0010\u000f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0017\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\n\u0010\bR\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleOptions;", "Ljava/io/Serializable;", "enableAbi", "", "enableDensity", "enableLanguage", "(Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;)V", "getEnableAbi", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getEnableDensity", "getEnableLanguage", "component1", "component2", "component3", "copy", "(Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;)Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleOptions;", "equals", "other", "", "hashCode", "", "toString", "", "gradle"})
    public static final class BundleOptions
    implements Serializable {
        @Nullable
        private final Boolean enableAbi;
        @Nullable
        private final Boolean enableDensity;
        @Nullable
        private final Boolean enableLanguage;

        @Input
        @Optional
        @Nullable
        public final Boolean getEnableAbi() {
            return this.enableAbi;
        }

        @Input
        @Optional
        @Nullable
        public final Boolean getEnableDensity() {
            return this.enableDensity;
        }

        @Input
        @Optional
        @Nullable
        public final Boolean getEnableLanguage() {
            return this.enableLanguage;
        }

        public BundleOptions(@Nullable Boolean enableAbi, @Nullable Boolean enableDensity, @Nullable Boolean enableLanguage) {
            this.enableAbi = enableAbi;
            this.enableDensity = enableDensity;
            this.enableLanguage = enableLanguage;
        }

        @Nullable
        public final Boolean component1() {
            return this.enableAbi;
        }

        @Nullable
        public final Boolean component2() {
            return this.enableDensity;
        }

        @Nullable
        public final Boolean component3() {
            return this.enableLanguage;
        }

        @NotNull
        public final BundleOptions copy(@Nullable Boolean enableAbi, @Nullable Boolean enableDensity, @Nullable Boolean enableLanguage) {
            return new BundleOptions(enableAbi, enableDensity, enableLanguage);
        }

        @NotNull
        public static /* synthetic */ BundleOptions copy$default(BundleOptions bundleOptions, Boolean bl, Boolean bl2, Boolean bl3, int n, Object object) {
            if ((n & 1) != 0) {
                bl = bundleOptions.enableAbi;
            }
            if ((n & 2) != 0) {
                bl2 = bundleOptions.enableDensity;
            }
            if ((n & 4) != 0) {
                bl3 = bundleOptions.enableLanguage;
            }
            return bundleOptions.copy(bl, bl2, bl3);
        }

        @NotNull
        public String toString() {
            return "BundleOptions(enableAbi=" + this.enableAbi + ", enableDensity=" + this.enableDensity + ", enableLanguage=" + this.enableLanguage + ")";
        }

        public int hashCode() {
            Boolean bl = this.enableAbi;
            Boolean bl2 = this.enableDensity;
            Boolean bl3 = this.enableLanguage;
            return ((bl != null ? ((Object)bl).hashCode() : 0) * 31 + (bl2 != null ? ((Object)bl2).hashCode() : 0)) * 31 + (bl3 != null ? ((Object)bl3).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BundleOptions)) break block3;
                    BundleOptions bundleOptions = (BundleOptions)object;
                    if (!Intrinsics.areEqual((Object)this.enableAbi, (Object)bundleOptions.enableAbi) || !Intrinsics.areEqual((Object)this.enableDensity, (Object)bundleOptions.enableDensity) || !Intrinsics.areEqual((Object)this.enableLanguage, (Object)bundleOptions.enableLanguage)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleFlags;", "Ljava/io/Serializable;", "enableUncompressedNativeLibs", "", "(Z)V", "getEnableUncompressedNativeLibs", "()Z", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "gradle"})
    public static final class BundleFlags
    implements Serializable {
        private final boolean enableUncompressedNativeLibs;

        @Input
        public final boolean getEnableUncompressedNativeLibs() {
            return this.enableUncompressedNativeLibs;
        }

        public BundleFlags(boolean enableUncompressedNativeLibs) {
            this.enableUncompressedNativeLibs = enableUncompressedNativeLibs;
        }

        public final boolean component1() {
            return this.enableUncompressedNativeLibs;
        }

        @NotNull
        public final BundleFlags copy(boolean enableUncompressedNativeLibs) {
            return new BundleFlags(enableUncompressedNativeLibs);
        }

        @NotNull
        public static /* synthetic */ BundleFlags copy$default(BundleFlags bundleFlags, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = bundleFlags.enableUncompressedNativeLibs;
            }
            return bundleFlags.copy(bl);
        }

        @NotNull
        public String toString() {
            return "BundleFlags(enableUncompressedNativeLibs=" + this.enableUncompressedNativeLibs + ")";
        }

        public int hashCode() {
            int n = this.enableUncompressedNativeLibs ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            return n;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BundleFlags)) break block3;
                    BundleFlags bundleFlags = (BundleFlags)object;
                    if (!(this.enableUncompressedNativeLibs == bundleFlags.enableUncompressedNativeLibs)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\nH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageBundleTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/PackageBundleTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "bundleFile", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "preConfigure", "taskName", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<PackageBundleTask> {
        private Provider<RegularFile> bundleFile;

        @Override
        @NotNull
        public String getName() {
            String string = this.getVariantScope().getTaskName("package", "Bundle");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName(\"package\", \"Bundle\")");
            return string;
        }

        @Override
        @NotNull
        public Class<PackageBundleTask> getType() {
            return PackageBundleTask.class;
        }

        @Override
        public void preConfigure(@NotNull String taskName) {
            Provider<RegularFile> provider;
            Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
            super.preConfigure(taskName);
            GlobalScope globalScope = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
            String apkLocationOverride = globalScope.getProjectOptions().get(StringOption.IDE_APK_LOCATION);
            StringBuilder stringBuilder = new StringBuilder();
            GlobalScope globalScope2 = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope2, (String)"variantScope.globalScope");
            String bundleName = stringBuilder.append(globalScope2.getProjectBaseName()).append(".aab").toString();
            if (apkLocationOverride == null) {
                provider = this.getVariantScope().getArtifacts().createArtifactFile((ArtifactType)InternalArtifactType.BUNDLE, BuildArtifactsHolder.OperationType.INITIAL, taskName, bundleName);
            } else {
                BuildArtifactsHolder buildArtifactsHolder = this.getVariantScope().getArtifacts();
                ArtifactType artifactType = InternalArtifactType.BUNDLE;
                GlobalScope globalScope3 = this.getVariantScope().getGlobalScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)globalScope3, (String)"variantScope.globalScope");
                File file = globalScope3.getProject().file((Object)apkLocationOverride);
                String[] stringArray = new String[2];
                GradleVariantConfiguration gradleVariantConfiguration = this.getVariantScope().getVariantConfiguration();
                Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"variantScope.variantConfiguration");
                stringArray[0] = gradleVariantConfiguration.getDirName();
                stringArray[1] = bundleName;
                File file2 = FileUtils.join((File)file, (String[])stringArray);
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"FileUtils.join(\n        \u2026              bundleName)");
                provider = buildArtifactsHolder.createArtifactFile(artifactType, BuildArtifactsHolder.OperationType.INITIAL, taskName, file2);
            }
            this.bundleFile = provider;
        }

        @Override
        public void configure(@NotNull PackageBundleTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            Provider<RegularFile> provider = this.bundleFile;
            if (provider == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFile");
            }
            task.bundleFile = provider;
            task.baseModuleZip = this.getVariantScope().getArtifacts().getFinalArtifactFiles(InternalArtifactType.MODULE_BUNDLE);
            FileCollection fileCollection = this.getVariantScope().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.METADATA_VALUES, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.MODULE_BUNDLE);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"variantScope.getArtifact\u2026DULE_BUNDLE\n            )");
            task.featureZips = fileCollection;
            PackageBundleTask packageBundleTask = task;
            GlobalScope globalScope = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
            AndroidConfig androidConfig = globalScope.getExtension();
            Intrinsics.checkExpressionValueIsNotNull((Object)androidConfig, (String)"variantScope.globalScope.extension");
            AaptOptions aaptOptions = androidConfig.getAaptOptions();
            Intrinsics.checkExpressionValueIsNotNull((Object)aaptOptions, (String)"variantScope.globalScope.extension.aaptOptions");
            Collection collection = aaptOptions.getNoCompress();
            if (collection == null) {
                PackageBundleTask packageBundleTask2 = packageBundleTask;
                List list = CollectionsKt.emptyList();
                packageBundleTask = packageBundleTask2;
                collection = list;
            }
            packageBundleTask.aaptOptionsNoCompress = collection;
            if (this.getVariantScope().getType().isHybrid()) {
                GlobalScope globalScope2 = this.getVariantScope().getGlobalScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)globalScope2, (String)"variantScope.globalScope");
                AndroidConfig androidConfig2 = globalScope2.getExtension();
                if (androidConfig2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.FeatureExtension");
                }
                com.android.build.gradle.internal.dsl.BundleOptions bundleOptions = ((FeatureExtension)androidConfig2).getBundle();
                Intrinsics.checkExpressionValueIsNotNull((Object)bundleOptions, (String)"((variantScope.globalSco\u2026FeatureExtension).bundle)");
                task.bundleOptions = PackageBundleTaskKt.access$convert(bundleOptions);
            } else {
                GlobalScope globalScope3 = this.getVariantScope().getGlobalScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)globalScope3, (String)"variantScope.globalScope");
                AndroidConfig androidConfig3 = globalScope3.getExtension();
                if (androidConfig3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.internal.dsl.BaseAppModuleExtension");
                }
                task.bundleOptions = PackageBundleTaskKt.access$convert(((BaseAppModuleExtension)androidConfig3).getBundle());
            }
            GlobalScope globalScope4 = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope4, (String)"variantScope.globalScope");
            task.bundleFlags = new BundleFlags(globalScope4.getProjectOptions().get(BooleanOption.ENABLE_UNCOMPRESSED_NATIVE_LIBS_IN_BUNDLE));
            if (this.getVariantScope().getNeedsMainDexListForBundle()) {
                task.mainDexList = this.getVariantScope().getArtifacts().getFinalArtifactFiles(InternalArtifactType.MAIN_DEX_LIST_FOR_BUNDLE);
            }
            if (this.getVariantScope().getArtifacts().hasArtifact(InternalArtifactType.APK_MAPPING)) {
                task.obsfuscationMappingFile = this.getVariantScope().getArtifacts().getFinalArtifactFiles(InternalArtifactType.APK_MAPPING);
            }
            GradleVariantConfiguration gradleVariantConfiguration = this.getVariantScope().getVariantConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"variantScope.variantConfiguration");
            CoreBuildType coreBuildType = (CoreBuildType)gradleVariantConfiguration.getBuildType();
            Intrinsics.checkExpressionValueIsNotNull((Object)coreBuildType, (String)"variantScope.variantConfiguration.buildType");
            if (!coreBuildType.isDebuggable()) {
                task.signingConfig = this.getVariantScope().getSigningConfigFileCollection();
            }
        }

        public CreationAction(@NotNull VariantScope variantScope) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            super(variantScope);
        }
    }
}

