/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.featuresplit;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.FileUtils;
import org.gradle.api.file.FileCollection;

public class FeatureSplitDeclaration {
    static final String PERSISTED_FILE_NAME = "feature-split.json";
    private final String modulePath;
    private final String applicationId;

    public FeatureSplitDeclaration(String modulePath, String applicationId) {
        this.modulePath = modulePath;
        this.applicationId = applicationId;
    }

    public String getModulePath() {
        return this.modulePath;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void save(File outputDirectory) throws IOException {
        File outputFile = new File(outputDirectory, PERSISTED_FILE_NAME);
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        FileUtils.write((File)outputFile, (CharSequence)gson.toJson((Object)this));
    }

    public static FeatureSplitDeclaration load(FileCollection input2) throws IOException {
        File persistedFile = FeatureSplitDeclaration.getOutputFile(input2);
        if (persistedFile == null) {
            throw new FileNotFoundException("No feature split declaration present");
        }
        return FeatureSplitDeclaration.load(persistedFile);
    }

    public static FeatureSplitDeclaration load(File input2) throws IOException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        try (FileReader fileReader = new FileReader(input2);){
            FeatureSplitDeclaration featureSplitDeclaration = (FeatureSplitDeclaration)gson.fromJson((Reader)fileReader, FeatureSplitDeclaration.class);
            return featureSplitDeclaration;
        }
    }

    private static File getOutputFile(FileCollection input2) {
        for (File file : input2.getAsFileTree().getFiles()) {
            if (!file.getName().equals(PERSISTED_FILE_NAME)) continue;
            return file;
        }
        return null;
    }

    public static File getOutputFile(File directory) {
        return new File(directory, PERSISTED_FILE_NAME);
    }
}

