/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res.namespaced;

import com.android.ide.common.resources.CompileResourceRequest;
import com.android.ide.common.resources.ResourceCompilationService;
import com.android.ide.common.xml.XmlFormatPreferences;
import com.android.ide.common.xml.XmlFormatStyle;
import com.android.ide.common.xml.XmlPrettyPrinter;
import com.android.utils.FileUtils;
import com.android.utils.PositionXmlParser;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\nJ\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/res/namespaced/NamespaceRemover;", "Lcom/android/ide/common/resources/ResourceCompilationService;", "()V", "close", "", "compileOutputFor", "Ljava/io/File;", "request", "Lcom/android/ide/common/resources/CompileResourceRequest;", "removeNamespace", "", "content", "removeNamespaces", "node", "Lorg/w3c/dom/Node;", "rewrite", "input", "Ljava/io/InputStream;", "lineSeparator", "Ljava/nio/file/Path;", "output", "submitCompile", "gradle"})
public final class NamespaceRemover
implements ResourceCompilationService {
    public static final NamespaceRemover INSTANCE;

    public void submitCompile(@NotNull CompileResourceRequest request2) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
        File input2 = request2.getInputFile();
        File output2 = this.compileOutputFor(request2);
        FileUtils.mkdirs((File)output2.getParentFile());
        String string = input2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"input.name");
        if (StringsKt.endsWith$default((String)string, (String)".xml", (boolean)false, (int)2, null)) {
            Path path = input2.toPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"input.toPath()");
            Path path2 = output2.toPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"output.toPath()");
            this.rewrite(path, path2);
        } else {
            FileUtils.copyFile((File)input2, (File)output2);
        }
    }

    @NotNull
    public File compileOutputFor(@NotNull CompileResourceRequest request2) {
        Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
        File parentDir = new File(request2.getOutputDirectory(), request2.getInputDirectoryName());
        return new File(parentDir, request2.getInputFile().getName());
    }

    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rewrite(Path input2, Path output2) throws IOException, ParserConfigurationException, SAXException {
        Closeable closeable = new BufferedInputStream(Files.newInputStream(input2, new OpenOption[0]));
        Throwable throwable = null;
        try {
            BufferedInputStream is = (BufferedInputStream)closeable;
            String string = NamespaceRemover.rewrite$default(INSTANCE, is, null, 2, null);
            Path path = output2;
            Charset charset = Charsets.UTF_8;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            Path path2 = Files.write(path, byArray2, new OpenOption[0]);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final String rewrite(@NotNull InputStream input2, @NotNull String lineSeparator) throws ParserConfigurationException, SAXException, IOException {
        Document doc;
        Intrinsics.checkParameterIsNotNull((Object)input2, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)lineSeparator, (String)"lineSeparator");
        Document document = doc = PositionXmlParser.parse((InputStream)input2);
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"doc");
        this.removeNamespaces(document);
        String string = XmlPrettyPrinter.prettyPrint((Node)doc, (XmlFormatPreferences)XmlFormatPreferences.defaults(), (XmlFormatStyle)XmlFormatStyle.get((Node)doc), (String)lineSeparator, (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"XmlPrettyPrinter.prettyP\u2026r,\n                false)");
        return string;
    }

    @NotNull
    public static /* synthetic */ String rewrite$default(NamespaceRemover namespaceRemover, InputStream inputStream, String string, int n, Object object) throws ParserConfigurationException, SAXException, IOException {
        if ((n & 2) != 0) {
            String string2 = System.lineSeparator();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"System.lineSeparator()");
            string = string2;
        }
        return namespaceRemover.rewrite(inputStream, string);
    }

    /*
     * WARNING - void declaration
     */
    private final void removeNamespaces(Node node) {
        Object uri;
        String prefix;
        if (node.getNodeType() == 3) {
            String content2;
            String string = content2 = node.getTextContent();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"content");
            String nonNamespacedContent = this.removeNamespace(string);
            if (Intrinsics.areEqual((Object)content2, (Object)nonNamespacedContent) ^ true) {
                node.setTextContent(nonNamespacedContent);
            }
        } else if (node.getNodeType() == 2 && (prefix = node.getPrefix()) != null && Intrinsics.areEqual((Object)prefix, (Object)"xmlns") && Intrinsics.areEqual((Object)(uri = node.getTextContent()), (Object)"http://schemas.android.com/apk/res/android") ^ true && Intrinsics.areEqual((Object)uri, (Object)"http://schemas.android.com/tools") ^ true && Intrinsics.areEqual((Object)uri, (Object)"http://schemas.android.com/aapt") ^ true) {
            node.setTextContent("http://schemas.android.com/apk/res-auto");
        }
        NamedNodeMap attributes2 = node.getAttributes();
        uri = this;
        NamespaceRemover $receiver22 = uri;
        for (int i = 0; attributes2 != null && i < attributes2.getLength(); ++i) {
            Node node2 = attributes2.item(i);
            Intrinsics.checkExpressionValueIsNotNull((Object)node2, (String)"attributes.item(i)");
            $receiver22.removeNamespaces(node2);
        }
        NodeList children = node.getChildNodes();
        int $receiver22 = 0;
        NodeList nodeList = children;
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeList, (String)"children");
        int n = nodeList.getLength();
        while ($receiver22 < n) {
            void i;
            Node node3 = children.item((int)i);
            Intrinsics.checkExpressionValueIsNotNull((Object)node3, (String)"children.item(i)");
            this.removeNamespaces(node3);
            ++i;
        }
    }

    private final String removeNamespace(String content2) {
        if (StringsKt.startsWith$default((String)content2, (String)"@", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)content2, (CharSequence)":", (boolean)false, (int)2, null)) {
            String string = content2;
            int n = 1;
            int n2 = StringsKt.indexOf$default((CharSequence)content2, (char)':', (int)0, (boolean)false, (int)6, null);
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String ns = string3;
            if (Intrinsics.areEqual((Object)ns, (Object)"android") ^ true && Intrinsics.areEqual((Object)ns, (Object)"tools") ^ true) {
                string = content2;
                n = StringsKt.indexOf$default((CharSequence)content2, (char)':', (int)0, (boolean)false, (int)6, null) + 1;
                StringBuilder stringBuilder = new StringBuilder().append("@");
                String string4 = string;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                String string6 = string5;
                return stringBuilder.append(string6).toString();
            }
        }
        return content2;
    }

    private NamespaceRemover() {
    }

    static {
        NamespaceRemover namespaceRemover;
        INSTANCE = namespaceRemover = new NamespaceRemover();
    }
}

