/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.incremental.FileType;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.tasks.PackageAndroidArtifact;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.builder.utils.FileCache;
import com.google.common.collect.ImmutableList;
import com.google.wireless.android.sdk.stats.GradleBuildProjectMetrics;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collection;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskProvider;

public class PackageApplication
extends PackageAndroidArtifact {
    InternalArtifactType expectedOutputType;

    @Override
    @Internal
    protected InternalArtifactType getInternalArtifactType() {
        return this.expectedOutputType;
    }

    @Override
    @Internal
    protected boolean isIncremental() {
        return true;
    }

    @Override
    void recordMetrics(File apkOutputFile, File resourcesApFile) {
        Long resourcesApSize;
        long metricsStartTime = System.nanoTime();
        GradleBuildProjectMetrics.Builder metrics = GradleBuildProjectMetrics.newBuilder();
        Long apkSize = PackageApplication.getSize(apkOutputFile);
        if (apkSize != null) {
            metrics.setApkSize(apkSize.longValue());
        }
        if ((resourcesApSize = PackageApplication.getSize(resourcesApFile)) != null) {
            metrics.setResourcesApSize(resourcesApSize.longValue());
        }
        metrics.setMetricsTimeNs(System.nanoTime() - metricsStartTime);
        ProcessProfileWriter.getProject((String)this.getProject().getPath()).setMetrics(metrics);
    }

    @Internal
    private static Long getSize(File file) {
        if (file == null) {
            return null;
        }
        try {
            return Files.size(file.toPath());
        }
        catch (IOException e) {
            return null;
        }
    }

    public static class InstantRunResourcesCreationAction
    extends PackageAndroidArtifact.CreationAction<PackageApplication> {
        private final File mOutputFile;

        public InstantRunResourcesCreationAction(File outputFile, VariantScope scope, InternalArtifactType inputResourceFilesType, Provider<Directory> manifests, InternalArtifactType manifestType, FileCache fileCache, OutputScope outputScope) {
            super(scope, outputFile.getParentFile(), inputResourceFilesType, manifests, manifestType, fileCache, outputScope);
            this.mOutputFile = outputFile;
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("packageInstantRunResources");
        }

        @Override
        public Class<PackageApplication> getType() {
            return PackageApplication.class;
        }

        @Override
        protected void finalConfigure(PackageApplication packageApplication) {
            packageApplication.expectedOutputType = InternalArtifactType.INSTANT_RUN_PACKAGED_RESOURCES;
            packageApplication.instantRunFileType = FileType.RESOURCES;
            ConfigurableFileCollection emptyCollection = this.getVariantScope().getGlobalScope().getProject().files(new Object[0]);
            packageApplication.dexFolders = emptyCollection;
            packageApplication.jniFolders = emptyCollection;
            packageApplication.javaResourceFiles = emptyCollection;
            packageApplication.apkList = this.getVariantScope().getArtifacts().getFinalArtifactFiles(InternalArtifactType.APK_LIST);
            packageApplication.setSigningConfig(null);
            packageApplication.outputFileProvider = split -> this.mOutputFile;
        }
    }

    public static class StandardCreationAction
    extends PackageAndroidArtifact.CreationAction<PackageApplication> {
        private final InternalArtifactType expectedOutputType;

        public StandardCreationAction(VariantScope packagingScope, File outputDirectory, InternalArtifactType inputResourceFilesType, Provider<Directory> manifests, InternalArtifactType manifestType, OutputScope outputScope, FileCache fileCache, InternalArtifactType expectedOutputType) {
            super(packagingScope, outputDirectory, inputResourceFilesType, manifests, manifestType, fileCache, outputScope);
            this.expectedOutputType = expectedOutputType;
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("package");
        }

        @Override
        public Class<PackageApplication> getType() {
            return PackageApplication.class;
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            this.getVariantScope().getArtifacts().appendArtifact((ArtifactType)this.expectedOutputType, (Collection<? extends Object>)ImmutableList.of((Object)this.outputDirectory), taskName);
        }

        @Override
        public void handleProvider(TaskProvider<? extends PackageApplication> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setPackageAndroidTask(taskProvider);
        }

        @Override
        protected void finalConfigure(PackageApplication task) {
            super.finalConfigure(task);
            task.expectedOutputType = this.expectedOutputType;
        }
    }
}

