/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.internal.InternalScope;
import com.android.build.gradle.internal.incremental.BuildInfoLoaderTask;
import com.android.build.gradle.internal.incremental.BuildInfoWriterTask;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunVerifierStatus;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.OriginalStream;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TransformVariantScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.factory.TaskFactory;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.internal.transforms.InstantRunDex;
import com.android.build.gradle.internal.transforms.InstantRunTransform;
import com.android.build.gradle.internal.transforms.InstantRunVerifierTransform;
import com.android.build.gradle.internal.transforms.NoChangesVerifierTransform;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.tasks.CheckManifestInInstantRunMode;
import com.android.build.gradle.tasks.PreColdSwapTask;
import com.android.build.gradle.tasks.ir.FastDeployRuntimeExtractorTask;
import com.android.build.gradle.tasks.ir.GenerateInstantRunAppInfoTask;
import com.android.build.gradle.tasks.ir.InstantRunMainApkResourcesBuilder;
import com.android.builder.model.OptionalCompilationStep;
import com.android.builder.profile.Recorder;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.internal.WaitableExecutor;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionAdapter;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.TaskState;

public class InstantRunTaskManager {
    private TaskProvider<TransformTask> verifierTask;
    private TaskProvider<TransformTask> reloadDexTask;
    private TaskProvider<BuildInfoLoaderTask> buildInfoLoaderTask;
    private final Logger logger;
    private final VariantScope variantScope;
    private final TransformManager transformManager;
    private final TaskFactory taskFactory;
    private final Recorder recorder;

    public InstantRunTaskManager(Logger logger, VariantScope instantRunVariantScope, TransformManager transformManager, TaskFactory taskFactory, Recorder recorder) {
        this.logger = logger;
        this.variantScope = instantRunVariantScope;
        this.transformManager = transformManager;
        this.taskFactory = taskFactory;
        this.recorder = recorder;
    }

    public TaskProvider<BuildInfoLoaderTask> createInstantRunAllTasks(TaskProvider<? extends Task> preTask, TaskProvider<? extends Task> anchorTask, Set<? super QualifiedContent.Scope> resMergingScopes, Provider<Directory> mergedManifests, Provider<Directory> instantRunMergedManifests, boolean addDependencyChangeChecker, int minSdkForDx, boolean enableDesugaring, FileCollection bootClasspath, MessageReceiver messageReceiver) {
        InternalArtifactType resourceFilesInputType;
        Project project = this.variantScope.getGlobalScope().getProject();
        TransformVariantScope transformVariantScope = this.variantScope.getTransformVariantScope();
        this.buildInfoLoaderTask = this.taskFactory.register(new BuildInfoLoaderTask.CreationAction(this.variantScope, this.logger));
        InstantRunVerifierTransform verifierTransform = new InstantRunVerifierTransform(this.variantScope, this.recorder);
        this.verifierTask = this.transformManager.addTransform(this.taskFactory, transformVariantScope, verifierTransform, null, task -> {
            if (preTask != null) {
                task.dependsOn(new Object[]{preTask});
            }
        }, null).orElse(null);
        NoChangesVerifierTransform javaResourcesVerifierTransform = new NoChangesVerifierTransform("javaResourcesVerifier", this.variantScope.getInstantRunBuildContext(), (Set<QualifiedContent.ContentType>)ImmutableSet.of((Object)QualifiedContent.DefaultContentType.RESOURCES, (Object)((Object)ExtendedContentType.NATIVE_LIBS)), resMergingScopes, InstantRunVerifierStatus.JAVA_RESOURCES_CHANGED);
        Optional<TaskProvider<TransformTask>> javaResourcesVerifierTask = this.transformManager.addTransform(this.taskFactory, transformVariantScope, javaResourcesVerifierTransform, null, task -> {
            if (this.verifierTask != null) {
                task.dependsOn(new Object[]{this.verifierTask});
            }
        }, null);
        TaskProvider<CheckManifestInInstantRunMode> checkManifestTask = this.taskFactory.register(new CheckManifestInInstantRunMode.CreationAction(this.variantScope));
        InstantRunTransform instantRunTransform = new InstantRunTransform(WaitableExecutor.useGlobalSharedThreadPool(), this.variantScope);
        Optional<TaskProvider<TransformTask>> instantRunTask = this.transformManager.addTransform(this.taskFactory, transformVariantScope, instantRunTransform, null, task -> task.dependsOn(new Object[]{this.buildInfoLoaderTask, this.verifierTask, javaResourcesVerifierTask.orElse(null), checkManifestTask}), null);
        InternalArtifactType internalArtifactType = resourceFilesInputType = this.variantScope.useResourceShrinker() ? InternalArtifactType.SHRUNK_PROCESSED_RES : InternalArtifactType.PROCESSED_RES;
        if (this.variantScope.getInstantRunBuildContext().useSeparateApkForResources()) {
            this.taskFactory.register(new InstantRunMainApkResourcesBuilder.CreationAction(this.variantScope, resourceFilesInputType));
        }
        if (addDependencyChangeChecker) {
            NoChangesVerifierTransform dependenciesVerifierTransform = new NoChangesVerifierTransform("dependencyChecker", this.variantScope.getInstantRunBuildContext(), (Set<QualifiedContent.ContentType>)ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES), (Set<? super QualifiedContent.Scope>)Sets.immutableEnumSet((Enum)QualifiedContent.Scope.EXTERNAL_LIBRARIES, (Enum[])new QualifiedContent.Scope[0]), InstantRunVerifierStatus.DEPENDENCY_CHANGED);
            Optional<TaskProvider<TransformTask>> dependenciesVerifierTask = this.transformManager.addTransform(this.taskFactory, transformVariantScope, dependenciesVerifierTransform);
            dependenciesVerifierTask.ifPresent(t -> {
                if (this.verifierTask != null) {
                    TaskFactoryUtils.dependsOn(t, this.verifierTask);
                }
            });
            instantRunTask.ifPresent(IRTask -> dependenciesVerifierTask.ifPresent(depVerifyTask -> TaskFactoryUtils.dependsOn(IRTask, depVerifyTask)));
        }
        TaskProvider<FastDeployRuntimeExtractorTask> extractorTask = this.taskFactory.register(new FastDeployRuntimeExtractorTask.CreationAction(this.variantScope, this.buildInfoLoaderTask));
        this.transformManager.addStream(OriginalStream.builder(project, "main-split-from-extractor").addContentTypes(TransformManager.CONTENT_CLASS).addScope(InternalScope.MAIN_SPLIT).setFileCollection((FileCollection)project.files(new Object[]{this.variantScope.getIncrementalRuntimeSupportJar()}).builtBy(new Object[]{extractorTask})).build());
        this.taskFactory.register(new GenerateInstantRunAppInfoTask.CreationAction(transformVariantScope, this.variantScope, mergedManifests, instantRunMergedManifests));
        this.transformManager.addStream(OriginalStream.builder(project, "main-split-from-injector").addContentTypes(TransformManager.CONTENT_CLASS).addScope(InternalScope.MAIN_SPLIT).setFileCollection((FileCollection)this.variantScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.INSTANT_RUN_APP_INFO_OUTPUT_FILE).get()).build());
        instantRunTask.ifPresent(provider -> TaskFactoryUtils.dependsOn(anchorTask, provider));
        InstantRunDex reloadDexTransform = new InstantRunDex(this.variantScope, minSdkForDx, enableDesugaring, bootClasspath, messageReceiver);
        this.reloadDexTask = this.transformManager.addTransform(this.taskFactory, transformVariantScope, reloadDexTransform).orElse(null);
        if (this.reloadDexTask != null) {
            TaskFactoryUtils.dependsOn(anchorTask, this.reloadDexTask);
        }
        return this.buildInfoLoaderTask;
    }

    public TaskProvider<PreColdSwapTask> createPreColdswapTask(ProjectOptions projectOptions) {
        TransformVariantScope transformVariantScope = this.variantScope.getTransformVariantScope();
        InstantRunBuildContext context = this.variantScope.getInstantRunBuildContext();
        if (transformVariantScope.getGlobalScope().isActive(OptionalCompilationStep.FULL_APK)) {
            context.setVerifierStatus(InstantRunVerifierStatus.FULL_BUILD_REQUESTED);
        } else if (transformVariantScope.getGlobalScope().isActive(OptionalCompilationStep.RESTART_ONLY)) {
            context.setVerifierStatus(InstantRunVerifierStatus.COLD_SWAP_REQUESTED);
        }
        return this.taskFactory.register(new PreColdSwapTask.CreationAction("preColdswap", transformVariantScope, this.variantScope, this.verifierTask));
    }

    public void configureBuildInfoWriterTask(TaskProvider<BuildInfoWriterTask> buildInfoWriterTask, Task ... dependencies) {
        Preconditions.checkNotNull(this.buildInfoLoaderTask, (Object)"createInstantRunAllTasks() should have been called first ");
        this.buildInfoLoaderTask.configure(t -> t.finalizedBy(new Object[]{buildInfoWriterTask}));
        buildInfoWriterTask.configure(t -> {
            if (this.reloadDexTask != null) {
                t.mustRunAfter(new Object[]{this.reloadDexTask});
            }
            if (dependencies != null) {
                for (Task dependency : dependencies) {
                    t.mustRunAfter(new Object[]{dependency});
                }
            }
        });
        this.variantScope.getGlobalScope().getProject().getGradle().getTaskGraph().addTaskExecutionListener((TaskExecutionListener)new TaskExecutionAdapter(){

            public void afterExecute(Task task, TaskState state) {
                if (state.getFailure() != null) {
                    InstantRunTaskManager.this.variantScope.getInstantRunBuildContext().setBuildHasFailed();
                }
            }
        });
    }
}

