/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import android.databinding.tool.util.Preconditions;
import com.android.build.gradle.internal.pipeline.IntermediateStream;
import com.android.build.gradle.internal.pipeline.TransformStream;
import com.android.build.gradle.internal.tasks.AndroidBuilderTask;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Collection;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitivity;

public abstract class StreamBasedTask
extends AndroidBuilderTask {
    protected Collection<TransformStream> consumedInputStreams;
    protected Collection<TransformStream> referencedInputStreams;
    protected IntermediateStream outputStream;

    @Optional
    @OutputDirectory
    public File getStreamOutputFolder() {
        if (this.outputStream != null) {
            return this.outputStream.getRootLocation();
        }
        return null;
    }

    protected void registerConsumedAndReferencedStreamInputs() {
        Preconditions.checkNotNull(this.consumedInputStreams, (String)"Consumed input streams not set.", (Object[])new Object[0]);
        Preconditions.checkNotNull(this.referencedInputStreams, (String)"Referenced input streams not set.", (Object[])new Object[0]);
        for (TransformStream stream : Iterables.concat(this.consumedInputStreams, this.referencedInputStreams)) {
            this.getInputs().files(new Object[]{stream.getAsFileTree()}).withPathSensitivity(PathSensitivity.ABSOLUTE);
        }
    }
}

