/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildElementsCopyParams;
import com.android.build.gradle.internal.scope.BuildElementsCopyRunnable;
import com.android.build.gradle.internal.scope.BuildElementsTransformParams;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.ide.common.build.ApkInfo;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import kotlin.jvm.functions.Function2;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkerExecutor;

public class CopyOutputs
extends AndroidVariantTask {
    private BuildableArtifact fullApks;
    private BuildableArtifact abiSplits;
    private BuildableArtifact resourcesSplits;
    private File destinationDir;
    private final WorkerExecutorFacade workers;

    @Inject
    public CopyOutputs(WorkerExecutor workerExecutor) {
        this.workers = Workers.INSTANCE.getWorker(workerExecutor);
    }

    @OutputDirectory
    public File getDestinationDir() {
        return this.destinationDir;
    }

    @InputFiles
    public BuildableArtifact getFullApks() {
        return this.fullApks;
    }

    @InputFiles
    @Optional
    public BuildableArtifact getAbiSplits() {
        return this.abiSplits;
    }

    @InputFiles
    @Optional
    public BuildableArtifact getResourcesSplits() {
        return this.resourcesSplits;
    }

    @TaskAction
    protected void copy() throws IOException, ExecutionException {
        FileUtils.cleanOutputDir((File)this.getDestinationDir());
        ArrayList<Callable<BuildElements>> buildElementsCallables = new ArrayList<Callable<BuildElements>>();
        buildElementsCallables.add(this.copy(InternalArtifactType.FULL_APK, (FileCollection)this.fullApks.get()));
        buildElementsCallables.add(this.copy(InternalArtifactType.ABI_PACKAGED_SPLIT, (FileCollection)this.abiSplits.get()));
        buildElementsCallables.add(this.copy(InternalArtifactType.DENSITY_OR_LANGUAGE_PACKAGED_SPLIT, (FileCollection)this.resourcesSplits.get()));
        ImmutableList.Builder buildOutputs = ImmutableList.builder();
        for (Callable callable : buildElementsCallables) {
            try {
                buildOutputs.addAll((Iterable)callable.call());
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }
        new BuildElements((Collection<BuildOutput>)buildOutputs.build()).save(this.getDestinationDir());
    }

    private Callable<BuildElements> copy(InternalArtifactType inputType, FileCollection inputs) {
        return ExistingBuildElements.from((ArtifactType)inputType, inputs).transform(this.workers, BuildElementsCopyRunnable.class, (Function2<? super ApkInfo, ? super File, ? extends BuildElementsTransformParams>)((Function2)(apkInfo, inputFile) -> new BuildElementsCopyParams((File)inputFile, new File(this.getDestinationDir(), inputFile.getName())))).intoCallable(InternalArtifactType.APK);
    }

    public static class CreationAction
    extends VariantTaskCreationAction<CopyOutputs> {
        private final File destinationDir;

        public CreationAction(VariantScope variantScope, File destinationDir) {
            super(variantScope);
            this.destinationDir = destinationDir;
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("copyOutputs");
        }

        @Override
        public Class<CopyOutputs> getType() {
            return CopyOutputs.class;
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            this.getVariantScope().getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.APK, (Collection<? extends Object>)ImmutableList.of((Object)this.destinationDir), taskName);
        }

        @Override
        public void configure(CopyOutputs task) {
            super.configure(task);
            BuildArtifactsHolder artifacts = this.getVariantScope().getArtifacts();
            task.fullApks = artifacts.getFinalArtifactFiles(InternalArtifactType.FULL_APK);
            task.abiSplits = artifacts.getFinalArtifactFiles(InternalArtifactType.ABI_PACKAGED_SPLIT);
            task.resourcesSplits = artifacts.getFinalArtifactFiles(InternalArtifactType.DENSITY_OR_LANGUAGE_PACKAGED_SPLIT);
            task.destinationDir = this.destinationDir;
        }
    }
}

