/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.tools.build.libraries.metadata.AppDependencies;
import com.android.tools.build.libraries.metadata.Library;
import com.android.tools.build.libraries.metadata.LibraryDependencies;
import com.android.tools.build.libraries.metadata.ModuleDependencies;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0007R&\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048G@@X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR&\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n8G@@X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR&\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00108G@@X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleReportDependenciesTask;", "Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "()V", "<set-?>", "Lcom/android/build/api/artifact/BuildableArtifact;", "baseDeps", "getBaseDeps", "()Lcom/android/build/api/artifact/BuildableArtifact;", "setBaseDeps$gradle", "(Lcom/android/build/api/artifact/BuildableArtifact;)V", "Ljava/io/File;", "dependenciesList", "getDependenciesList", "()Ljava/io/File;", "setDependenciesList$gradle", "(Ljava/io/File;)V", "Lorg/gradle/api/file/FileCollection;", "featureDeps", "getFeatureDeps", "()Lorg/gradle/api/file/FileCollection;", "setFeatureDeps$gradle", "(Lorg/gradle/api/file/FileCollection;)V", "writeFile", "", "CreationAction", "gradle"})
public class BundleReportDependenciesTask
extends AndroidVariantTask {
    @NotNull
    public BuildableArtifact baseDeps;
    @NotNull
    public FileCollection featureDeps;
    @NotNull
    public File dependenciesList;

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public final BuildableArtifact getBaseDeps() {
        BuildableArtifact buildableArtifact = this.baseDeps;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"baseDeps");
        }
        return buildableArtifact;
    }

    public final void setBaseDeps$gradle(@NotNull BuildableArtifact buildableArtifact) {
        Intrinsics.checkParameterIsNotNull((Object)buildableArtifact, (String)"<set-?>");
        this.baseDeps = buildableArtifact;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public final FileCollection getFeatureDeps() {
        FileCollection fileCollection = this.featureDeps;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureDeps");
        }
        return fileCollection;
    }

    public final void setFeatureDeps$gradle(@NotNull FileCollection fileCollection) {
        Intrinsics.checkParameterIsNotNull((Object)fileCollection, (String)"<set-?>");
        this.featureDeps = fileCollection;
    }

    @OutputFile
    @NotNull
    public final File getDependenciesList() {
        File file = this.dependenciesList;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dependenciesList");
        }
        return file;
    }

    public final void setDependenciesList$gradle(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.dependenciesList = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void writeFile() {
        BuildableArtifact buildableArtifact = this.baseDeps;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"baseDeps");
        }
        Closeable closeable = new BufferedInputStream(new FileInputStream(BuildableArtifactUtil.singleFile(buildableArtifact)));
        Throwable throwable = null;
        try {
            Iterator it = (BufferedInputStream)closeable;
            it = AppDependencies.parseDelimitedFrom((InputStream)((Object)it));
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Iterator baseAppDeps = it;
        LinkedList<AppDependencies> featureAppDeps = new LinkedList<AppDependencies>();
        FileCollection fileCollection = this.featureDeps;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureDeps");
        }
        Set set = fileCollection.getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"featureDeps.files");
        Iterable $receiver$iv = set;
        for (Object element$iv : $receiver$iv) {
            File it = (File)element$iv;
            featureAppDeps.add(AppDependencies.parseDelimitedFrom(new FileInputStream(it)));
        }
        HashMap<Library, Integer> libraryToIndexMap = new HashMap<Library, Integer>();
        Iterator iterator = baseAppDeps;
        Intrinsics.checkExpressionValueIsNotNull(iterator, (String)"baseAppDeps");
        LinkedList<Library> libraryList = new LinkedList<Library>((Collection)((AppDependencies)((Object)iterator)).getLibraryList());
        boolean element$iv = false;
        for (Library lib : (Iterable)libraryList) {
            void index;
            libraryToIndexMap.put(lib, new Integer((int)index));
            ++index;
        }
        LinkedList<LibraryDependencies> libraryDeps = new LinkedList<LibraryDependencies>((Collection)((AppDependencies)((Object)baseAppDeps)).getLibraryDependenciesList());
        LinkedList<ModuleDependencies> moduleDeps = new LinkedList<ModuleDependencies>((Collection)((AppDependencies)((Object)baseAppDeps)).getModuleDependenciesList());
        for (AppDependencies featureAppDep : featureAppDeps) {
            Integer depIndex;
            Iterator<Integer> iterator2;
            HashMap<Integer, Integer> libIndexDict = new HashMap<Integer, Integer>();
            AppDependencies appDependencies = featureAppDep;
            Intrinsics.checkExpressionValueIsNotNull((Object)appDependencies, (String)"featureAppDep");
            List<Library> featureLibraryDeps = appDependencies.getLibraryList();
            boolean bl = false;
            List<Library> list = featureLibraryDeps;
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"featureLibraryDeps");
            for (Library lib : (Iterable)list) {
                void origIndex;
                Integer newIndex = (Integer)libraryToIndexMap.get(lib);
                if (newIndex == null) {
                    newIndex = new Integer(libraryList.size());
                    libraryToIndexMap.put(lib, newIndex);
                    libraryList.add(lib);
                }
                libIndexDict.put(new Integer((int)origIndex), newIndex);
                ++origIndex;
            }
            for (LibraryDependencies libraryDep : featureAppDep.getLibraryDependenciesList()) {
                LibraryDependencies.Builder builder = LibraryDependencies.newBuilder();
                LibraryDependencies libraryDependencies = libraryDep;
                Intrinsics.checkExpressionValueIsNotNull((Object)libraryDependencies, (String)"libraryDep");
                Object v = libIndexDict.get(new Integer(libraryDependencies.getLibraryIndex()));
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                LibraryDependencies.Builder transformedDepBuilder = builder.setLibraryIndex((Integer)v);
                iterator2 = libraryDep.getLibraryDepIndexList().iterator();
                while (iterator2.hasNext()) {
                    Integer n = depIndex = iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"depIndex");
                    Object v2 = libIndexDict.get(new Integer(n));
                    if (v2 == null) {
                        Intrinsics.throwNpe();
                    }
                    transformedDepBuilder.addLibraryDepIndex((Integer)v2);
                }
                LibraryDependencies transformedDep = transformedDepBuilder.build();
                if (libraryDeps.contains(transformedDep)) continue;
                libraryDeps.add(transformedDep);
            }
            for (ModuleDependencies moduleDep : featureAppDep.getModuleDependenciesList()) {
                ModuleDependencies.Builder builder = ModuleDependencies.newBuilder();
                ModuleDependencies moduleDependencies = moduleDep;
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleDependencies, (String)"moduleDep");
                ModuleDependencies.Builder moduleDepBuilder = builder.setModuleName(moduleDependencies.getModuleName());
                iterator2 = moduleDep.getDependencyIndexList().iterator();
                while (iterator2.hasNext()) {
                    Integer n = depIndex = iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"depIndex");
                    Object v = libIndexDict.get(new Integer(n));
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    moduleDepBuilder.addDependencyIndex((Integer)v);
                }
                moduleDeps.add(moduleDepBuilder.build());
            }
        }
        AppDependencies appDeps = AppDependencies.newBuilder().addAllLibrary((Iterable<? extends Library>)libraryList).addAllLibraryDependencies((Iterable<? extends LibraryDependencies>)libraryDeps).addAllModuleDependencies((Iterable<? extends ModuleDependencies>)moduleDeps).build();
        File file = this.dependenciesList;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dependenciesList");
        }
        appDeps.writeDelimitedTo(new FileOutputStream(file));
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\nH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleReportDependenciesTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/BundleReportDependenciesTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "dependenciesList", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "preConfigure", "taskName", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<BundleReportDependenciesTask> {
        @NotNull
        private final String name;
        @NotNull
        private final Class<BundleReportDependenciesTask> type;
        private Provider<RegularFile> dependenciesList;

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<BundleReportDependenciesTask> getType() {
            return this.type;
        }

        @Override
        public void preConfigure(@NotNull String taskName) {
            Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
            super.preConfigure(taskName);
            this.dependenciesList = this.getVariantScope().getArtifacts().createArtifactFile((ArtifactType)InternalArtifactType.BUNDLE_DEPENDENCY_REPORT, BuildArtifactsHolder.OperationType.INITIAL, taskName, "dependencies.pb");
        }

        @Override
        public void configure(@NotNull BundleReportDependenciesTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            task.setBaseDeps$gradle(this.getVariantScope().getArtifacts().getFinalArtifactFiles(InternalArtifactType.METADATA_LIBRARY_DEPENDENCIES_REPORT));
            FileCollection fileCollection = this.getVariantScope().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.METADATA_VALUES, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.LIB_DEPENDENCIES);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"variantScope.getArtifact\u2026EPENDENCIES\n            )");
            task.setFeatureDeps$gradle(fileCollection);
            Provider<RegularFile> provider = this.dependenciesList;
            if (provider == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dependenciesList");
            }
            Object object = provider.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"dependenciesList.get()");
            File file = ((RegularFile)object).getAsFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"dependenciesList.get().asFile");
            task.setDependenciesList$gradle(file);
        }

        public CreationAction(@NotNull VariantScope variantScope) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            super(variantScope);
            String string = variantScope.getTaskName("configure", "Dependencies");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName\u2026nfigure\", \"Dependencies\")");
            this.name = string;
            this.type = BundleReportDependenciesTask.class;
        }
    }
}

