/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.build.gradle.internal.cxx.configure.CmakeCompilerCacheKey;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0006H\u0002R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/cxx/configure/CmakeCompilerSettingsCache;", "", "cacheRootFolder", "Ljava/io/File;", "hashAlgorithm", "Lkotlin/Function1;", "", "(Ljava/io/File;Lkotlin/jvm/functions/Function1;)V", "cacheFolder", "checksumFile", "hash", "keyFile", "saveKeyValue", "", "key", "Lcom/android/build/gradle/internal/cxx/configure/CmakeCompilerCacheKey;", "value", "tryGetValue", "valueFile", "Companion", "gradle"})
public final class CmakeCompilerSettingsCache {
    private final File cacheFolder;
    private final Function1<Object, String> hashAlgorithm;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final String tryGetValue(@NotNull CmakeCompilerCacheKey key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        try {
            String priorChecksum;
            String keyJson = key.toJsonString();
            String keyHash = (String)this.hashAlgorithm.invoke((Object)keyJson);
            File checksumFile = this.checksumFile(keyHash);
            File keyFile = this.keyFile(keyHash);
            File valueFile = this.valueFile(keyHash);
            if (!(checksumFile.isFile() && keyFile.isFile() && valueFile.isFile())) {
                return null;
            }
            String priorKeyJson = FilesKt.readText$default((File)keyFile, null, (int)1, null);
            if (Intrinsics.areEqual((Object)priorKeyJson, (Object)keyJson) ^ true) {
                return null;
            }
            String value = FilesKt.readText$default((File)valueFile, null, (int)1, null);
            String checksum = CmakeCompilerSettingsCache.Companion.hashCodeRadix36Hash(value);
            if (Intrinsics.areEqual((Object)checksum, (Object)(priorChecksum = FilesKt.readText$default((File)checksumFile, null, (int)1, null))) ^ true) {
                return null;
            }
            return value;
        }
        catch (IOException e) {
            return null;
        }
    }

    public final void saveKeyValue(@NotNull CmakeCompilerCacheKey key, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        try {
            String keyJson = key.toJsonString();
            String keyHash = (String)this.hashAlgorithm.invoke((Object)keyJson);
            File checksumFile = this.checksumFile(keyHash);
            File keyFile = this.keyFile(keyHash);
            File valueFile = this.valueFile(keyHash);
            this.cacheFolder.mkdirs();
            String valueChecksum = CmakeCompilerSettingsCache.Companion.hashCodeRadix36Hash(value);
            FilesKt.writeText$default((File)checksumFile, (String)valueChecksum, null, (int)2, null);
            FilesKt.writeText$default((File)keyFile, (String)keyJson, null, (int)2, null);
            FilesKt.writeText$default((File)valueFile, (String)value, null, (int)2, null);
        }
        catch (IOException e) {
            return;
        }
    }

    private final File keyFile(String hash) {
        return new File(this.cacheFolder, hash + "_key.json");
    }

    private final File valueFile(String hash) {
        return new File(this.cacheFolder, hash + "_value.cmake");
    }

    private final File checksumFile(String hash) {
        return new File(this.cacheFolder, hash + "_checksum.txt");
    }

    public CmakeCompilerSettingsCache(@NotNull File cacheRootFolder, @NotNull Function1<Object, String> hashAlgorithm) {
        Intrinsics.checkParameterIsNotNull((Object)cacheRootFolder, (String)"cacheRootFolder");
        Intrinsics.checkParameterIsNotNull(hashAlgorithm, (String)"hashAlgorithm");
        this.hashAlgorithm = hashAlgorithm;
        this.cacheFolder = new File(cacheRootFolder, "cmake-compiler-settings");
    }

    public /* synthetic */ CmakeCompilerSettingsCache(File file, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        this(file, (Function1<Object, String>)function1);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/cxx/configure/CmakeCompilerSettingsCache$Companion;", "", "()V", "hashCodeRadix36Hash", "", "key", "gradle"})
    public static final class Companion {
        private final String hashCodeRadix36Hash(Object key) {
            int n = key.hashCode();
            int n2 = 36;
            String string = Integer.toString(n, CharsKt.checkRadix((int)n2));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

