/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.SigningConfigMetadata;
import com.android.build.gradle.tasks.AnnotationProcessingTaskCreationAction;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0007R6\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00048G@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR*\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u000b8G@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/SigningConfigWriterTask;", "Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "()V", "<set-?>", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "outputDirectory", "getOutputDirectory", "()Lorg/gradle/api/provider/Provider;", "setOutputDirectory$gradle", "(Lorg/gradle/api/provider/Provider;)V", "Lcom/android/build/gradle/internal/dsl/SigningConfig;", "signingConfig", "getSigningConfig", "()Lcom/android/build/gradle/internal/dsl/SigningConfig;", "setSigningConfig$gradle", "(Lcom/android/build/gradle/internal/dsl/SigningConfig;)V", "fullTaskAction", "", "CreationAction", "gradle"})
public class SigningConfigWriterTask
extends AndroidVariantTask {
    @Nullable
    private Provider<Directory> outputDirectory;
    @Nullable
    private SigningConfig signingConfig;

    @OutputDirectory
    @Nullable
    public final Provider<Directory> getOutputDirectory() {
        return this.outputDirectory;
    }

    public final void setOutputDirectory$gradle(@Nullable Provider<Directory> provider) {
        this.outputDirectory = provider;
    }

    @Input
    @Optional
    @Nullable
    public final SigningConfig getSigningConfig() {
        return this.signingConfig;
    }

    public final void setSigningConfig$gradle(@Nullable SigningConfig signingConfig) {
        this.signingConfig = signingConfig;
    }

    @TaskAction
    public final void fullTaskAction() throws IOException {
        Provider<Directory> provider = this.outputDirectory;
        if (provider == null) {
            throw (Throwable)new RuntimeException("OutputDirectory not set.");
        }
        Provider<Directory> out = provider;
        Object object = out.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"out.get()");
        File file = ((Directory)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"out.get().asFile");
        SigningConfigMetadata.Companion.save(file, this.signingConfig);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0010\u0010\u0005\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/tasks/SigningConfigWriterTask$CreationAction;", "Lcom/android/build/gradle/tasks/AnnotationProcessingTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/SigningConfigWriterTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "validateSigningTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/gradle/api/Task;", "(Lcom/android/build/gradle/internal/scope/VariantScope;Lorg/gradle/api/tasks/TaskProvider;)V", "outputDirectory", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "configure", "", "task", "preConfigure", "taskName", "", "gradle"})
    public static final class CreationAction
    extends AnnotationProcessingTaskCreationAction<SigningConfigWriterTask> {
        private Provider<Directory> outputDirectory;
        private final TaskProvider<? extends Task> validateSigningTask;

        @Override
        public void preConfigure(@NotNull String taskName) {
            Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
            super.preConfigure(taskName);
            this.outputDirectory = BuildArtifactsHolder.createDirectory$default(this.getVariantScope().getArtifacts(), InternalArtifactType.SIGNING_CONFIG, taskName, null, 4, null);
        }

        @Override
        public void configure(@NotNull SigningConfigWriterTask task) {
            SigningConfig signingConfig;
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            task.setOutputDirectory$gradle(this.outputDirectory);
            SigningConfigWriterTask signingConfigWriterTask = task;
            GradleVariantConfiguration gradleVariantConfiguration = this.getVariantScope().getVariantConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"variantScope.variantConfiguration");
            CoreSigningConfig coreSigningConfig = gradleVariantConfiguration.getSigningConfig();
            if (coreSigningConfig != null) {
                CoreSigningConfig it;
                CoreSigningConfig coreSigningConfig2 = coreSigningConfig;
                SigningConfigWriterTask signingConfigWriterTask2 = signingConfigWriterTask;
                CoreSigningConfig coreSigningConfig3 = it = coreSigningConfig2;
                Intrinsics.checkExpressionValueIsNotNull((Object)coreSigningConfig3, (String)"it");
                SigningConfig signingConfig2 = new SigningConfig(coreSigningConfig3.getName()).initWith(it);
                signingConfigWriterTask = signingConfigWriterTask2;
                signingConfig = signingConfig2;
            } else {
                signingConfig = null;
            }
            signingConfigWriterTask.setSigningConfig$gradle(signingConfig);
            if (this.validateSigningTask != null) {
                task.dependsOn(new Object[]{this.validateSigningTask});
            }
        }

        public CreationAction(@NotNull VariantScope variantScope, @Nullable TaskProvider<? extends Task> validateSigningTask) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            String string = variantScope.getTaskName("signingConfigWriter");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName(\"signingConfigWriter\")");
            super(variantScope, string, SigningConfigWriterTask.class);
            this.validateSigningTask = validateSigningTask;
        }
    }
}

