/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.coverage;

import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.scope.AnchorOutputType;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.builder.model.Version;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closeables;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.WorkerExecutor;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.core.tools.ExecFileLoader;
import org.jacoco.report.DirectorySourceFileLocator;
import org.jacoco.report.FileMultiReportOutput;
import org.jacoco.report.IMultiReportOutput;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.MultiReportVisitor;
import org.jacoco.report.MultiSourceFileLocator;
import org.jacoco.report.html.HTMLFormatter;
import org.jacoco.report.xml.XMLFormatter;

public class JacocoReportTask
extends AndroidVariantTask {
    private FileCollection jacocoClasspath;
    private BuildableArtifact coverageDirectories;
    private BuildableArtifact classFileCollection;
    private Supplier<FileCollection> sourceFolders;
    private File reportDir;
    private String reportName;
    private int tabWidth = 4;
    private WorkerExecutor executor;

    @Inject
    public JacocoReportTask(WorkerExecutor executor) {
        this.executor = executor;
    }

    @Deprecated
    public void setCoverageFile(File coverageFile) {
        this.getLogger().info("JacocoReportTask.setCoverageDir is deprecated and has no effect.");
    }

    @InputFiles
    @Optional
    public BuildableArtifact getCoverageDirectories() {
        return this.coverageDirectories;
    }

    @OutputDirectory
    public File getReportDir() {
        return this.reportDir;
    }

    public void setReportDir(File reportDir) {
        this.reportDir = reportDir;
    }

    @InputFiles
    public BuildableArtifact getClassFileCollection() {
        return this.classFileCollection;
    }

    @InputFiles
    public FileCollection getSourceFolders() {
        return this.sourceFolders.get();
    }

    public String getReportName() {
        return this.reportName;
    }

    @Input
    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    @InputFiles
    public FileCollection getJacocoClasspath() {
        return this.jacocoClasspath;
    }

    public void setJacocoClasspath(FileCollection jacocoClasspath) {
        this.jacocoClasspath = jacocoClasspath;
    }

    @Input
    public int getTabWidth() {
        return this.tabWidth;
    }

    public void setTabWidth(int tabWidth) {
        this.tabWidth = tabWidth;
    }

    @TaskAction
    public void generateReport() throws IOException {
        Set coverageFiles = ((FileCollection)this.coverageDirectories.get()).getAsFileTree().getFiles().stream().filter(File::isFile).collect(Collectors.toSet());
        if (coverageFiles.isEmpty()) {
            throw new IOException(String.format("No coverage data to process in directories [%1$s]", this.coverageDirectories.getFiles()));
        }
        this.executor.submit(JacocoReportWorkerAction.class, workerConfiguration -> {
            workerConfiguration.setIsolationMode(IsolationMode.CLASSLOADER);
            workerConfiguration.classpath((Iterable)this.jacocoClasspath.getFiles());
            workerConfiguration.setParams(new Object[]{coverageFiles, this.getReportDir(), this.getClassFileCollection().getFiles(), this.getSourceFolders().getFiles(), this.getTabWidth(), this.getReportName()});
        });
    }

    static class JacocoReportWorkerAction
    implements Runnable {
        private static Logger logger = Logging.getLogger(JacocoReportWorkerAction.class);
        private Collection<File> coverageFiles;
        private File reportDir;
        private Collection<File> classFolders;
        private Collection<File> sourceFolders;
        private int tabWidth;
        String reportName;

        @Inject
        public JacocoReportWorkerAction(Collection<File> coverageFiles, File reportDir, Collection<File> classFolders, Collection<File> sourceFolders, int tabWidth, String reportName) {
            this.coverageFiles = coverageFiles;
            this.reportDir = reportDir;
            this.classFolders = classFolders;
            this.sourceFolders = sourceFolders;
            this.tabWidth = tabWidth;
            this.reportName = reportName;
        }

        @Override
        public void run() {
            try {
                JacocoReportWorkerAction.generateReport(this.coverageFiles, this.reportDir, this.classFolders, this.sourceFolders, this.tabWidth, this.reportName);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to generate Jacoco report", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void generateReport(Collection<File> coverageFiles, File reportDir, Collection<File> classFolders, Collection<File> sourceFolders, int tabWidth, String reportName) throws IOException {
            ExecFileLoader loader = new ExecFileLoader();
            for (File coverageFile : coverageFiles) {
                loader.load(coverageFile);
            }
            SessionInfoStore sessionInfoStore = loader.getSessionInfoStore();
            ExecutionDataStore executionDataStore = loader.getExecutionDataStore();
            HTMLFormatter htmlFormatter = new HTMLFormatter();
            htmlFormatter.setOutputEncoding("UTF-8");
            htmlFormatter.setLocale(Locale.US);
            htmlFormatter.setFooterText("Generated by the Android Gradle plugin " + Version.ANDROID_GRADLE_PLUGIN_VERSION);
            FileMultiReportOutput output2 = new FileMultiReportOutput(reportDir);
            IReportVisitor htmlReport = htmlFormatter.createVisitor((IMultiReportOutput)output2);
            XMLFormatter xmlFormatter = new XMLFormatter();
            xmlFormatter.setOutputEncoding("UTF-8");
            OutputStream xmlReportOutput = output2.createFile("report.xml");
            try {
                IReportVisitor xmlReport = xmlFormatter.createVisitor(xmlReportOutput);
                MultiReportVisitor visitor = new MultiReportVisitor((List)ImmutableList.of((Object)htmlReport, (Object)xmlReport));
                visitor.visitInfo(sessionInfoStore.getInfos(), executionDataStore.getContents());
                CoverageBuilder builder = new CoverageBuilder();
                Analyzer analyzer = new Analyzer(executionDataStore, (ICoverageVisitor)builder);
                JacocoReportWorkerAction.analyzeAll(analyzer, classFolders);
                MultiSourceFileLocator locator = new MultiSourceFileLocator(0);
                for (File folder : sourceFolders) {
                    locator.add((ISourceFileLocator)new DirectorySourceFileLocator(folder, "UTF-8", tabWidth));
                }
                IBundleCoverage bundle = builder.getBundle(reportName);
                visitor.visitBundle(bundle, (ISourceFileLocator)locator);
                visitor.visitEnd();
            }
            finally {
                try {
                    xmlReportOutput.close();
                }
                catch (IOException e) {
                    logger.error("Could not close xml report file", (Throwable)e);
                }
            }
        }

        private static void analyzeAll(Analyzer analyzer, Collection<File> classFolders) throws IOException {
            for (File folder : classFolders) {
                JacocoReportWorkerAction.analyze(analyzer, folder, classFolders);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void analyze(Analyzer analyzer, File file, Collection<File> originalClassFolders) throws IOException {
            block6: {
                block5: {
                    if (!file.isDirectory()) break block5;
                    File[] files2 = file.listFiles();
                    if (files2 == null) break block6;
                    for (File f : files2) {
                        if (originalClassFolders.contains(f)) continue;
                        JacocoReportWorkerAction.analyze(analyzer, f, originalClassFolders);
                    }
                    break block6;
                }
                String name = file.getName();
                if (!name.endsWith(".class") || name.equals("R.class") || name.startsWith("R$") || name.equals("Manifest.class") || name.startsWith("Manifest$") || name.equals("BuildConfig.class")) {
                    return;
                }
                FileInputStream in = new FileInputStream(file);
                try {
                    analyzer.analyzeClass((InputStream)in, file.getAbsolutePath());
                }
                finally {
                    Closeables.closeQuietly((InputStream)in);
                }
            }
        }
    }

    public static class CreationAction
    extends VariantTaskCreationAction<JacocoReportTask> {
        private final Configuration jacocoAntConfiguration;

        public CreationAction(VariantScope scope, Configuration jacocoAntConfiguration) {
            super(scope);
            this.jacocoAntConfiguration = jacocoAntConfiguration;
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("create", "CoverageReport");
        }

        @Override
        public Class<JacocoReportTask> getType() {
            return JacocoReportTask.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends JacocoReportTask> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setCoverageReportTask(taskProvider);
        }

        @Override
        public void configure(JacocoReportTask task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            task.setDescription("Creates JaCoCo test coverage report from data gathered on the device.");
            task.setReportName(scope.getVariantConfiguration().getFullName());
            Preconditions.checkNotNull((Object)scope.getTestedVariantData());
            VariantScope testedScope = scope.getTestedVariantData().getScope();
            task.jacocoClasspath = (FileCollection)this.jacocoAntConfiguration;
            task.coverageDirectories = scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.CODE_COVERAGE);
            task.classFileCollection = testedScope.getArtifacts().getFinalArtifactFiles(AnchorOutputType.ALL_CLASSES);
            task.sourceFolders = () -> testedScope.getVariantData().getJavaSourceFoldersForCoverage();
            task.setReportDir(testedScope.getCoverageReportDir());
        }
    }
}

