/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.tasks.InstantAppProvisioner;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.builder.sdk.SdkInfo;
import com.android.builder.testing.ConnectedDeviceProvider;
import com.android.builder.testing.api.DeviceException;
import com.android.builder.testing.api.DeviceProvider;
import com.android.instantapp.provision.ProvisionException;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.utils.ILogger;
import java.io.File;
import java.util.function.Supplier;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.TaskAction;

public class InstantAppProvisionTask
extends DefaultTask {
    private Supplier<File> instantAppSdk;
    private Supplier<File> adbExe;

    @TaskAction
    public void provisionDevices() throws ProvisionException, DeviceException {
        if (this.instantAppSdk.get() == null) {
            throw new GradleException("No Instant App Sdk found.");
        }
        if (this.adbExe.get() == null) {
            throw new GradleException("No adb file found.");
        }
        ConnectedDeviceProvider deviceProvider = new ConnectedDeviceProvider(this.adbExe.get(), 0, (ILogger)new LoggerWrapper(this.getLogger()));
        InstantAppProvisioner provisioner = new InstantAppProvisioner(this.instantAppSdk.get(), (DeviceProvider)deviceProvider, this.getLogger());
        provisioner.provisionDevices();
    }

    @InputFile
    public File getAdbExe() {
        return this.adbExe.get();
    }

    @InputDirectory
    public File getInstantAppSdk() {
        return this.instantAppSdk.get();
    }

    public static class CreationAction
    extends TaskCreationAction<InstantAppProvisionTask> {
        private final GlobalScope globalScope;

        public CreationAction(GlobalScope globalScope) {
            this.globalScope = globalScope;
        }

        @Override
        public String getName() {
            return "provisionInstantApp";
        }

        @Override
        public Class<InstantAppProvisionTask> getType() {
            return InstantAppProvisionTask.class;
        }

        @Override
        public void configure(InstantAppProvisionTask task) {
            task.setDescription("Provision all connected devices for Instant App.");
            task.adbExe = TaskInputHelper.memoize(() -> {
                SdkInfo sdkInfo = this.globalScope.getSdkHandler().getSdkInfo();
                return sdkInfo == null ? null : sdkInfo.getAdb();
            });
            task.instantAppSdk = TaskInputHelper.memoize(() -> {
                LocalPackage instantAppSdk;
                File sdkFolder = this.globalScope.getSdkHandler().getSdkFolder();
                if (sdkFolder != null && (instantAppSdk = AndroidSdkHandler.getInstance((File)sdkFolder).getLocalPackage("extras;google;instantapps", (ProgressIndicator)new ConsoleProgressIndicator())) != null) {
                    return instantAppSdk.getLocation();
                }
                return null;
            });
        }
    }
}

