/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunVerifierStatus;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;

public class NoChangesVerifierTransform
extends Transform {
    private final String transformName;
    private final InstantRunBuildContext buildContext;
    private final Set<QualifiedContent.ContentType> inputTypes;
    private final Set<? super QualifiedContent.Scope> mergeScopes;
    private final InstantRunVerifierStatus failureStatus;

    public NoChangesVerifierTransform(String transformName, InstantRunBuildContext buildContext, Set<QualifiedContent.ContentType> inputTypes, Set<? super QualifiedContent.Scope> mergeScopes, InstantRunVerifierStatus failureStatus) {
        this.transformName = transformName;
        this.buildContext = buildContext;
        this.inputTypes = inputTypes;
        this.mergeScopes = mergeScopes;
        this.failureStatus = failureStatus;
    }

    public String getName() {
        return this.transformName;
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return this.inputTypes;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return ImmutableSet.of();
    }

    public Set<? super QualifiedContent.Scope> getReferencedScopes() {
        return this.mergeScopes;
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(TransformInvocation transformInvocation) throws TransformException, InterruptedException, IOException {
        if (!transformInvocation.isIncremental() || this.hasChangedInputs(transformInvocation.getReferencedInputs())) {
            this.buildContext.setVerifierStatus(this.failureStatus);
        }
    }

    private boolean hasChangedInputs(Collection<TransformInput> inputs) {
        for (TransformInput input2 : inputs) {
            for (DirectoryInput directoryInput : input2.getDirectoryInputs()) {
                if (Sets.intersection((Set)directoryInput.getContentTypes(), this.inputTypes).isEmpty() || directoryInput.getChangedFiles().isEmpty()) continue;
                if (this.inputTypes.contains(QualifiedContent.DefaultContentType.CLASSES)) {
                    return true;
                }
                for (File file : directoryInput.getChangedFiles().keySet()) {
                    if (file.getPath().endsWith(".class")) continue;
                    return true;
                }
            }
            for (JarInput jarInput : input2.getJarInputs()) {
                if (Sets.intersection((Set)jarInput.getContentTypes(), this.inputTypes).isEmpty() || jarInput.getStatus() == Status.NOTCHANGED) continue;
                return true;
            }
        }
        return false;
    }
}

