/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.Context;
import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.res.namespaced.JarRequest;
import com.android.build.gradle.internal.res.namespaced.JarWorkerRunnable;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.transforms.MergeClassesTransform;
import com.android.ide.common.workers.WorkerExecutorFacade;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\n\u0012\u0006\b\u0000\u0012\u00020\f0\u000bH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/transforms/MergeClassesTransform;", "Lcom/android/build/api/transform/Transform;", "outputJarFile", "Ljava/io/File;", "(Ljava/io/File;)V", "getInputTypes", "", "Lcom/android/build/api/transform/QualifiedContent$ContentType;", "getName", "", "getReferencedScopes", "", "Lcom/android/build/api/transform/QualifiedContent$Scope;", "getScopes", "getSecondaryFileOutputs", "", "isIncremental", "", "transform", "", "invocation", "Lcom/android/build/api/transform/TransformInvocation;", "Companion", "gradle"})
public final class MergeClassesTransform
extends Transform {
    private final File outputJarFile;
    private static final Pattern CLASS_PATTERN;
    private static final Pattern KOTLIN_MODULE_PATTERN;
    public static final Companion Companion;

    @NotNull
    public String getName() {
        return "mergeClasses";
    }

    @NotNull
    public List<File> getSecondaryFileOutputs() {
        return CollectionsKt.listOf((Object)this.outputJarFile);
    }

    public boolean isIncremental() {
        return false;
    }

    @NotNull
    public Set<QualifiedContent.ContentType> getInputTypes() {
        Set<QualifiedContent.ContentType> set = TransformManager.CONTENT_CLASS;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"TransformManager.CONTENT_CLASS");
        return set;
    }

    @NotNull
    public Set<QualifiedContent.Scope> getScopes() {
        Set<QualifiedContent.Scope> set = TransformManager.EMPTY_SCOPES;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"TransformManager.EMPTY_SCOPES");
        return set;
    }

    @NotNull
    public Set<? super QualifiedContent.Scope> getReferencedScopes() {
        Set<QualifiedContent.Scope> set = TransformManager.SCOPE_FULL_PROJECT;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"TransformManager.SCOPE_FULL_PROJECT");
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(@NotNull TransformInvocation invocation) {
        Iterable $receiver$iv$iv;
        File file;
        Collection collection;
        TransformInput it;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)invocation, (String)"invocation");
        Collection collection2 = invocation.getReferencedInputs();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"invocation.referencedInputs");
        Iterable iterable = $receiver$iv = (Iterable)collection2;
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            it = (TransformInput)element$iv$iv;
            boolean bl = false;
            TransformInput transformInput = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)transformInput, (String)"it");
            Iterable list$iv$iv = transformInput.getJarInputs();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv2 = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            it = (JarInput)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            TransformInput transformInput = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)transformInput, (String)"it");
            file = transformInput.getFile();
            collection.add(file);
        }
        List fromJars = (List)destination$iv$iv;
        Collection collection3 = invocation.getReferencedInputs();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection3, (String)"invocation.referencedInputs");
        Iterable $receiver$iv2 = collection3;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            TransformInput it2 = (TransformInput)element$iv$iv;
            boolean bl = false;
            TransformInput transformInput = it2;
            Intrinsics.checkExpressionValueIsNotNull((Object)transformInput, (String)"it");
            Iterable list$iv$iv = transformInput.getDirectoryInputs();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $receiver$iv2 = (List)destination$iv$iv2;
        $receiver$iv$iv = $receiver$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            DirectoryInput it2 = (DirectoryInput)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            DirectoryInput directoryInput = it2;
            Intrinsics.checkExpressionValueIsNotNull((Object)directoryInput, (String)"it");
            file = directoryInput.getFile();
            collection.add(file);
        }
        List fromDirectories = (List)destination$iv$iv2;
        Function1 classFilter2 = transform.classFilter.1.INSTANCE;
        Context context = invocation.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"invocation.context");
        WorkerExecutor workerExecutor = context.getWorkerExecutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)workerExecutor, (String)"invocation.context.workerExecutor");
        WorkerExecutorFacade workers = Workers.getWorker$default(Workers.INSTANCE, workerExecutor, null, 2, null);
        Closeable closeable = (Closeable)workers;
        Object object = null;
        try {
            it = (WorkerExecutorFacade)closeable;
            boolean bl = false;
            Function1 function1 = classFilter2;
            Map map2 = null;
            Map map3 = null;
            List list = fromDirectories;
            List list2 = fromJars;
            it.submit(JarWorkerRunnable.class, (Serializable)new JarRequest(this.outputJarFile, list, list2, map3, map2, function1, 24, null));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }

    public MergeClassesTransform(@NotNull File outputJarFile) {
        Intrinsics.checkParameterIsNotNull((Object)outputJarFile, (String)"outputJarFile");
        this.outputJarFile = outputJarFile;
    }

    static {
        Companion = new Companion(null);
        CLASS_PATTERN = Pattern.compile(".*\\.class$");
        KOTLIN_MODULE_PATTERN = Pattern.compile("^META-INF/.*\\.kotlin_module$");
    }

    public static final /* synthetic */ Pattern access$getCLASS_PATTERN$cp() {
        return CLASS_PATTERN;
    }

    public static final /* synthetic */ Pattern access$getKOTLIN_MODULE_PATTERN$cp() {
        return KOTLIN_MODULE_PATTERN;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/transforms/MergeClassesTransform$Companion;", "", "()V", "CLASS_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "KOTLIN_MODULE_PATTERN", "gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

