/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.api.attributes.BuildTypeAttr;
import com.android.build.api.attributes.ProductFlavorAttr;
import com.android.build.api.attributes.VariantAttr;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dependency.AndroidTypeAttr;
import com.android.build.gradle.internal.dependency.ConstraintHandler;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.build.gradle.internal.errors.SyncIssueHandler;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.TestVariantFactory;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.core.VariantType;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.model.ObjectFactory;

public class VariantDependencies {
    public static final String CONFIG_NAME_COMPILE = "compile";
    public static final String CONFIG_NAME_PUBLISH = "publish";
    public static final String CONFIG_NAME_APK = "apk";
    public static final String CONFIG_NAME_PROVIDED = "provided";
    public static final String CONFIG_NAME_WEAR_APP = "wearApp";
    public static final String CONFIG_NAME_ANDROID_APIS = "androidApis";
    public static final String CONFIG_NAME_ANNOTATION_PROCESSOR = "annotationProcessor";
    public static final String CONFIG_NAME_API = "api";
    public static final String CONFIG_NAME_COMPILE_ONLY = "compileOnly";
    public static final String CONFIG_NAME_IMPLEMENTATION = "implementation";
    public static final String CONFIG_NAME_RUNTIME_ONLY = "runtimeOnly";
    @Deprecated
    public static final String CONFIG_NAME_FEATURE = "feature";
    public static final String CONFIG_NAME_APPLICATION = "application";
    public static final String CONFIG_NAME_LINTCHECKS = "lintChecks";
    public static final String CONFIG_NAME_LINTPUBLISH = "lintPublish";
    public static final String CONFIG_NAME_TESTED_APKS = "testedApks";
    public static final String USAGE_BUNDLE = "android-bundle";
    private final String variantName;
    private final Configuration compileClasspath;
    private final Configuration runtimeClasspath;
    private final Collection<Configuration> sourceSetRuntimeConfigurations;
    private final Collection<Configuration> sourceSetImplementationConfigurations;
    private final ImmutableMap<AndroidArtifacts.PublishedConfigType, Configuration> elements;
    private final Configuration annotationProcessorConfiguration;
    private final Configuration wearAppConfiguration;
    private final Configuration metadataValuesConfiguration;

    public static Builder builder(Project project, SyncIssueHandler errorReporter, GradleVariantConfiguration variantConfiguration) {
        return new Builder(project, errorReporter, variantConfiguration);
    }

    private VariantDependencies(String variantName, Configuration compileClasspath, Configuration runtimeClasspath, Collection<Configuration> sourceSetRuntimeConfigurations, Collection<Configuration> sourceSetImplementationConfigurations, Map<AndroidArtifacts.PublishedConfigType, Configuration> elements, Configuration annotationProcessorConfiguration, Configuration metadataValuesConfiguration, Configuration wearAppConfiguration) {
        this.variantName = variantName;
        this.compileClasspath = compileClasspath;
        this.runtimeClasspath = runtimeClasspath;
        this.sourceSetRuntimeConfigurations = sourceSetRuntimeConfigurations;
        this.sourceSetImplementationConfigurations = sourceSetImplementationConfigurations;
        this.elements = Maps.immutableEnumMap(elements);
        this.annotationProcessorConfiguration = annotationProcessorConfiguration;
        this.metadataValuesConfiguration = metadataValuesConfiguration;
        this.wearAppConfiguration = wearAppConfiguration;
    }

    public String getName() {
        return this.variantName;
    }

    public Configuration getCompileClasspath() {
        return this.compileClasspath;
    }

    public Configuration getRuntimeClasspath() {
        return this.runtimeClasspath;
    }

    public Collection<Dependency> getIncomingRuntimeDependencies() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Configuration classpath : this.sourceSetRuntimeConfigurations) {
            builder.addAll((Iterable)classpath.getIncoming().getDependencies());
        }
        return builder.build();
    }

    public Configuration getElements(AndroidArtifacts.PublishedConfigType configType) {
        return (Configuration)this.elements.get((Object)configType);
    }

    public Configuration getAnnotationProcessorConfiguration() {
        return this.annotationProcessorConfiguration;
    }

    public Configuration getWearAppConfiguration() {
        return this.wearAppConfiguration;
    }

    public Configuration getMetadataValuesConfiguration() {
        return this.metadataValuesConfiguration;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.variantName).toString();
    }

    public static final class Builder {
        private final Project project;
        private final SyncIssueHandler errorReporter;
        private final GradleVariantConfiguration variantConfiguration;
        private Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> flavorSelection;
        private AndroidTypeAttr consumeType;
        private AndroidTypeAttr publishType;
        private final Set<Configuration> compileClasspaths = Sets.newLinkedHashSet();
        private final Set<Configuration> apiClasspaths = Sets.newLinkedHashSet();
        private final Set<Configuration> implementationConfigurations = Sets.newLinkedHashSet();
        private final Set<Configuration> runtimeClasspaths = Sets.newLinkedHashSet();
        private final Set<Configuration> annotationConfigs = Sets.newLinkedHashSet();
        private final Set<Configuration> wearAppConfigs = Sets.newLinkedHashSet();
        private VariantScope testedVariantScope;
        private Set<String> featureList;

        protected Builder(Project project, SyncIssueHandler errorReporter, GradleVariantConfiguration variantConfiguration) {
            this.project = project;
            this.errorReporter = errorReporter;
            this.variantConfiguration = variantConfiguration;
        }

        public Builder setPublishType(AndroidTypeAttr publishType) {
            this.publishType = publishType;
            return this;
        }

        public Builder setConsumeType(AndroidTypeAttr consumeType) {
            this.consumeType = consumeType;
            return this;
        }

        public Builder addSourceSets(DefaultAndroidSourceSet ... sourceSets) {
            for (DefaultAndroidSourceSet sourceSet : sourceSets) {
                this.addSourceSet(sourceSet);
            }
            return this;
        }

        public Builder addSourceSets(Collection<DefaultAndroidSourceSet> sourceSets) {
            for (DefaultAndroidSourceSet sourceSet : sourceSets) {
                this.addSourceSet(sourceSet);
            }
            return this;
        }

        public Builder setTestedVariantScope(VariantScope testedVariantScope) {
            this.testedVariantScope = testedVariantScope;
            return this;
        }

        public Builder setFeatureList(Set<String> featureList) {
            this.featureList = featureList;
            return this;
        }

        public Builder addSourceSet(DefaultAndroidSourceSet sourceSet) {
            if (sourceSet != null) {
                ConfigurationContainer configs = this.project.getConfigurations();
                this.compileClasspaths.add(configs.getByName(sourceSet.getCompileOnlyConfigurationName()));
                this.runtimeClasspaths.add(configs.getByName(sourceSet.getRuntimeOnlyConfigurationName()));
                Configuration implementationConfig = configs.getByName(sourceSet.getImplementationConfigurationName());
                this.compileClasspaths.add(implementationConfig);
                this.runtimeClasspaths.add(implementationConfig);
                this.implementationConfigurations.add(implementationConfig);
                String apiConfigName = sourceSet.getApiConfigurationName();
                if (apiConfigName != null) {
                    this.apiClasspaths.add(configs.getByName(apiConfigName));
                }
                this.annotationConfigs.add(configs.getByName(sourceSet.getAnnotationProcessorConfigurationName()));
                this.wearAppConfigs.add(configs.getByName(sourceSet.getWearAppConfigurationName()));
            }
            return this;
        }

        public Builder setFlavorSelection(Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> flavorSelection) {
            this.flavorSelection = flavorSelection;
            return this;
        }

        public VariantDependencies build(VariantScope variantScope) {
            Preconditions.checkNotNull((Object)this.consumeType);
            ObjectFactory factory2 = this.project.getObjects();
            Usage apiUsage = (Usage)factory2.named(Usage.class, "java-api");
            Usage runtimeUsage = (Usage)factory2.named(Usage.class, "java-runtime");
            String variantName = this.variantConfiguration.getFullName();
            VariantType variantType = this.variantConfiguration.getType();
            String buildType = ((CoreBuildType)this.variantConfiguration.getBuildType()).getName();
            Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> consumptionFlavorMap = this.getFlavorAttributes(this.flavorSelection);
            ConfigurationContainer configurations = this.project.getConfigurations();
            String compileClasspathName = variantName + "CompileClasspath";
            Configuration compileClasspath = (Configuration)configurations.maybeCreate(compileClasspathName);
            compileClasspath.setVisible(false);
            compileClasspath.setDescription("Resolved configuration for compilation for variant: " + variantName);
            compileClasspath.setExtendsFrom(this.compileClasspaths);
            if (this.testedVariantScope != null) {
                for (Configuration configuration : this.testedVariantScope.getVariantDependencies().sourceSetImplementationConfigurations) {
                    compileClasspath.extendsFrom(new Configuration[]{configuration});
                }
            }
            compileClasspath.setCanBeConsumed(false);
            compileClasspath.getResolutionStrategy().sortArtifacts(ResolutionStrategy.SortOrder.CONSUMER_FIRST);
            AttributeContainer compileAttributes = compileClasspath.getAttributes();
            this.applyVariantAttributes(compileAttributes, buildType, consumptionFlavorMap);
            compileAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)apiUsage);
            compileAttributes.attribute(AndroidTypeAttr.ATTRIBUTE, (Object)this.consumeType);
            Configuration annotationProcessor = (Configuration)configurations.maybeCreate(variantName + "AnnotationProcessorClasspath");
            annotationProcessor.setVisible(false);
            annotationProcessor.setDescription("Resolved configuration for annotation-processor for variant: " + variantName);
            annotationProcessor.setExtendsFrom(this.annotationConfigs);
            annotationProcessor.setCanBeConsumed(false);
            AttributeContainer annotationAttributes = annotationProcessor.getAttributes();
            annotationAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
            this.applyVariantAttributes(annotationAttributes, buildType, consumptionFlavorMap);
            String runtimeClasspathName = variantName + "RuntimeClasspath";
            Configuration runtimeClasspath = (Configuration)configurations.maybeCreate(runtimeClasspathName);
            runtimeClasspath.setVisible(false);
            runtimeClasspath.setDescription("Resolved configuration for runtime for variant: " + variantName);
            runtimeClasspath.setExtendsFrom(this.runtimeClasspaths);
            if (this.testedVariantScope != null) {
                for (Configuration configuration : this.testedVariantScope.getVariantDependencies().sourceSetRuntimeConfigurations) {
                    runtimeClasspath.extendsFrom(new Configuration[]{configuration});
                }
            }
            runtimeClasspath.setCanBeConsumed(false);
            runtimeClasspath.getResolutionStrategy().sortArtifacts(ResolutionStrategy.SortOrder.CONSUMER_FIRST);
            AttributeContainer runtimeAttributes = runtimeClasspath.getAttributes();
            this.applyVariantAttributes(runtimeAttributes, buildType, consumptionFlavorMap);
            runtimeAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
            runtimeAttributes.attribute(AndroidTypeAttr.ATTRIBUTE, (Object)this.consumeType);
            if (variantScope.getGlobalScope().getProjectOptions().get(BooleanOption.USE_DEPENDENCY_CONSTRAINTS)) {
                compileClasspath.getIncoming().beforeResolve((Action)new ConstraintHandler(runtimeClasspath, this.project.getDependencies().getConstraints(), false));
                if (variantType.isApk() && this.testedVariantScope != null) {
                    Configuration testedRuntimeClasspath = this.testedVariantScope.getVariantDependencies().getRuntimeClasspath();
                    runtimeClasspath.getIncoming().beforeResolve((Action)new ConstraintHandler(testedRuntimeClasspath, this.project.getDependencies().getConstraints(), true));
                }
            }
            Configuration globalTestedApks = (Configuration)configurations.findByName(VariantDependencies.CONFIG_NAME_TESTED_APKS);
            if (variantType.isApk() && globalTestedApks != null) {
                Configuration testedApks = (Configuration)configurations.maybeCreate(TestVariantFactory.getTestedApksConfigurationName(variantName));
                testedApks.setVisible(false);
                testedApks.setDescription("Resolved configuration for tested apks for variant: " + variantName);
                testedApks.extendsFrom(new Configuration[]{globalTestedApks});
                AttributeContainer testedApksAttributes = testedApks.getAttributes();
                this.applyVariantAttributes(testedApksAttributes, buildType, consumptionFlavorMap);
                testedApksAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
                testedApksAttributes.attribute(AndroidTypeAttr.ATTRIBUTE, (Object)this.consumeType);
            }
            Configuration metadataValues = null;
            Configuration wearApp = null;
            EnumMap elements = Maps.newEnumMap(AndroidArtifacts.PublishedConfigType.class);
            if (this.publishType != null) {
                VariantAttr variantNameAttr;
                if (this.publishType.getName().equals("Apk")) {
                    wearApp = (Configuration)configurations.maybeCreate(variantName + "WearBundling");
                    wearApp.setDescription("Resolved Configuration for wear app bundling for variant: " + variantName);
                    wearApp.setExtendsFrom(this.wearAppConfigs);
                    wearApp.setCanBeConsumed(false);
                    AttributeContainer wearAttributes = wearApp.getAttributes();
                    this.applyVariantAttributes(wearAttributes, buildType, consumptionFlavorMap);
                    wearAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
                    wearAttributes.attribute(AndroidTypeAttr.ATTRIBUTE, (Object)factory2.named(AndroidTypeAttr.class, "Apk"));
                    Configuration bundleElements = (Configuration)configurations.maybeCreate(variantName + "BundleElements");
                    bundleElements.setDescription("Bundle elements for " + variantName);
                    bundleElements.setCanBeResolved(false);
                    AttributeContainer bundleElementsAttributes = bundleElements.getAttributes();
                    variantNameAttr = (VariantAttr)factory2.named(VariantAttr.class, variantName);
                    bundleElementsAttributes.attribute(VariantAttr.ATTRIBUTE, (Object)variantNameAttr);
                    bundleElementsAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)factory2.named(Usage.class, VariantDependencies.USAGE_BUNDLE));
                    elements.put(AndroidArtifacts.PublishedConfigType.BUNDLE_ELEMENTS, bundleElements);
                }
                Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> publicationFlavorMap = this.getFlavorAttributes(null);
                Configuration runtimeElements = (Configuration)configurations.maybeCreate(variantName + "RuntimeElements");
                runtimeElements.setDescription("Runtime elements for " + variantName);
                runtimeElements.setCanBeResolved(false);
                AttributeContainer runtimeElementsAttributes = runtimeElements.getAttributes();
                this.applyVariantAttributes(runtimeElementsAttributes, buildType, publicationFlavorMap);
                variantNameAttr = (VariantAttr)factory2.named(VariantAttr.class, variantName);
                runtimeElementsAttributes.attribute(VariantAttr.ATTRIBUTE, (Object)variantNameAttr);
                runtimeElementsAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
                runtimeElementsAttributes.attribute(AndroidTypeAttr.ATTRIBUTE, (Object)this.publishType);
                if (variantType.isAar()) {
                    runtimeElements.extendsFrom(new Configuration[]{runtimeClasspath});
                }
                elements.put(AndroidArtifacts.PublishedConfigType.RUNTIME_ELEMENTS, runtimeElements);
                Configuration apiElements = (Configuration)configurations.maybeCreate(variantName + "ApiElements");
                apiElements.setDescription("API elements for " + variantName);
                apiElements.setCanBeResolved(false);
                AttributeContainer apiElementsAttributes = apiElements.getAttributes();
                this.applyVariantAttributes(apiElementsAttributes, buildType, publicationFlavorMap);
                apiElementsAttributes.attribute(VariantAttr.ATTRIBUTE, (Object)variantNameAttr);
                apiElementsAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)apiUsage);
                apiElementsAttributes.attribute(AndroidTypeAttr.ATTRIBUTE, (Object)this.publishType);
                apiElements.setExtendsFrom(this.apiClasspaths);
                elements.put(AndroidArtifacts.PublishedConfigType.API_ELEMENTS, apiElements);
                if (variantType.getPublishToMetadata()) {
                    Configuration metadataElements = (Configuration)configurations.maybeCreate(variantName + "MetadataElements");
                    metadataElements.setCanBeResolved(false);
                    AttributeContainer metadataElementsAttributes = metadataElements.getAttributes();
                    this.applyVariantAttributes(metadataElementsAttributes, buildType, publicationFlavorMap);
                    metadataElementsAttributes.attribute(AndroidTypeAttr.ATTRIBUTE, (Object)factory2.named(AndroidTypeAttr.class, "Metadata"));
                    metadataElementsAttributes.attribute(VariantAttr.ATTRIBUTE, (Object)variantNameAttr);
                    elements.put(AndroidArtifacts.PublishedConfigType.METADATA_ELEMENTS, metadataElements);
                }
                if (variantType.isBaseModule()) {
                    String metadataValuesName = variantName + "MetadataValues";
                    metadataValues = (Configuration)configurations.maybeCreate(metadataValuesName);
                    if (this.featureList != null) {
                        DependencyHandler depHandler = this.project.getDependencies();
                        ArrayList<String> notFound = new ArrayList<String>();
                        for (String feature : this.featureList) {
                            Project p = this.project.findProject(feature);
                            if (p != null) {
                                depHandler.add(metadataValuesName, (Object)p);
                                continue;
                            }
                            notFound.add(feature);
                        }
                        if (!notFound.isEmpty()) {
                            this.errorReporter.reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException("Unable to find matching projects for Dynamic Features: " + notFound));
                        }
                    } else {
                        metadataValues.extendsFrom(new Configuration[]{configurations.getByName(VariantDependencies.CONFIG_NAME_FEATURE)});
                        if (variantType.isHybrid()) {
                            metadataValues.extendsFrom(new Configuration[]{configurations.getByName(VariantDependencies.CONFIG_NAME_APPLICATION)});
                        }
                    }
                    metadataValues.setDescription("Metadata Values dependencies for the base Split");
                    metadataValues.setCanBeConsumed(false);
                    AttributeContainer featureMetadataAttributes = metadataValues.getAttributes();
                    featureMetadataAttributes.attribute(AndroidTypeAttr.ATTRIBUTE, (Object)factory2.named(AndroidTypeAttr.class, "Metadata"));
                    this.applyVariantAttributes(featureMetadataAttributes, buildType, consumptionFlavorMap);
                }
            }
            Builder.checkOldConfigurations(configurations, "_" + variantName + "Compile", compileClasspathName);
            Builder.checkOldConfigurations(configurations, "_" + variantName + "Apk", runtimeClasspathName);
            Builder.checkOldConfigurations(configurations, "_" + variantName + "Publish", runtimeClasspathName);
            return new VariantDependencies(variantName, compileClasspath, runtimeClasspath, this.runtimeClasspaths, this.implementationConfigurations, elements, annotationProcessor, metadataValues, wearApp);
        }

        private static void checkOldConfigurations(ConfigurationContainer configurations, String oldConfigName, String newConfigName) {
            if (configurations.findByName(oldConfigName) != null) {
                throw new RuntimeException(String.format("Configuration with old name %s found. Use new name %s instead.", oldConfigName, newConfigName));
            }
        }

        private Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> getFlavorAttributes(Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> flavorSelection) {
            List productFlavors = this.variantConfiguration.getProductFlavors();
            HashMap map2 = Maps.newHashMapWithExpectedSize((int)productFlavors.size());
            if (this.errorReporter.hasSyncIssue(EvalIssueReporter.Type.UNNAMED_FLAVOR_DIMENSION)) {
                return map2;
            }
            ObjectFactory objectFactory = this.project.getObjects();
            for (CoreProductFlavor f : productFlavors) {
                assert (f.getDimension() != null);
                map2.put(Attribute.of((String)f.getDimension(), ProductFlavorAttr.class), objectFactory.named(ProductFlavorAttr.class, f.getName()));
            }
            if (flavorSelection != null) {
                map2.putAll(flavorSelection);
            }
            return map2;
        }

        private void applyVariantAttributes(AttributeContainer attributeContainer, String buildType, Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> flavorMap) {
            attributeContainer.attribute(BuildTypeAttr.ATTRIBUTE, (Object)this.project.getObjects().named(BuildTypeAttr.class, buildType));
            for (Map.Entry<Attribute<ProductFlavorAttr>, ProductFlavorAttr> entry : flavorMap.entrySet()) {
                attributeContainer.attribute(entry.getKey(), (Object)entry.getValue());
            }
        }
    }
}

