/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.gradle.internal.VariantManager;
import com.android.build.gradle.internal.cxx.configure.JsonGenerationAbiConfiguration;
import com.android.build.gradle.internal.ide.FailsafeModelBuilderParameter;
import com.android.build.gradle.internal.ide.NativeAndroidProjectBuilder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.builder.model.ModelBuilderParameter;
import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.NativeVariantAbi;
import com.android.builder.profile.ProcessProfileWriter;
import com.google.gson.stream.JsonReader;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.gradle.api.Project;
import org.gradle.tooling.provider.model.ParameterizedToolingModelBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\"\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020#H\u0016J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#H\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000eH\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010%2\u0006\u0010\"\u001a\u00020#H\u0002J \u0010,\u001a\u00020-2\u0006\u0010\"\u001a\u00020#2\u0006\u0010.\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\u0014H\u0002J\u0010\u00100\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u0014H\u0016J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020\u000202H\u0016J\b\u00103\u001a\u00020'H\u0002R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000bR\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/android/build/gradle/internal/ide/NativeModelBuilder;", "Lorg/gradle/tooling/provider/model/ParameterizedToolingModelBuilder;", "Lcom/android/builder/model/ModelBuilderParameter;", "globalScope", "Lcom/android/build/gradle/internal/scope/GlobalScope;", "variantManager", "Lcom/android/build/gradle/internal/VariantManager;", "(Lcom/android/build/gradle/internal/scope/GlobalScope;Lcom/android/build/gradle/internal/VariantManager;)V", "enableParallelNativeJsonGen", "", "getEnableParallelNativeJsonGen", "()Z", "generators", "", "Lcom/android/build/gradle/tasks/ExternalNativeJsonGenerator;", "getGenerators", "()Ljava/util/List;", "ideRefreshExternalNativeModel", "getIdeRefreshExternalNativeModel", "nativeAndroidProjectClass", "", "kotlin.jvm.PlatformType", "nativeVariantAbiClass", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "getProjectOptions", "()Lcom/android/build/gradle/options/ProjectOptions;", "scopes", "Lcom/android/build/gradle/internal/scope/VariantScope;", "getScopes", "buildAll", "", "modelName", "parameter", "project", "Lorg/gradle/api/Project;", "buildFullNativeAndroidProject", "Lcom/android/builder/model/NativeAndroidProject;", "buildInexpensiveNativeAndroidProjectInformation", "", "builder", "Lcom/android/build/gradle/internal/ide/NativeAndroidProjectBuilder;", "generator", "buildNativeAndroidProjectWithJustVariantInfos", "buildNativeVariantAbi", "Lcom/android/builder/model/NativeVariantAbi;", "variantName", "abiName", "canBuild", "getParameterType", "Ljava/lang/Class;", "regenerateNativeJson", "gradle"})
public final class NativeModelBuilder
implements ParameterizedToolingModelBuilder<ModelBuilderParameter> {
    private final String nativeAndroidProjectClass;
    private final String nativeVariantAbiClass;
    private final GlobalScope globalScope;
    private final VariantManager variantManager;

    private final ProjectOptions getProjectOptions() {
        ProjectOptions projectOptions = this.globalScope.getProjectOptions();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectOptions, (String)"globalScope.projectOptions");
        return projectOptions;
    }

    private final boolean getIdeRefreshExternalNativeModel() {
        return this.getProjectOptions().get(BooleanOption.IDE_REFRESH_EXTERNAL_NATIVE_MODEL);
    }

    private final boolean getEnableParallelNativeJsonGen() {
        return this.getProjectOptions().get(BooleanOption.ENABLE_PARALLEL_NATIVE_JSON_GEN);
    }

    /*
     * WARNING - void declaration
     */
    private final List<VariantScope> getScopes() {
        void $this$filterTo$iv$iv;
        List<VariantScope> list = this.variantManager.getVariantScopes();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"variantManager.variantScopes");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VariantScope it = (VariantScope)element$iv$iv;
            boolean bl = false;
            VariantScope variantScope = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)variantScope, (String)"it");
            if (!(variantScope.getTaskContainer().getExternalNativeJsonGenerator() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final List<ExternalNativeJsonGenerator> getGenerators() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getScopes();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ExternalNativeJsonGenerator externalNativeJsonGenerator;
            void it;
            VariantScope variantScope = (VariantScope)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (it.getTaskContainer().getExternalNativeJsonGenerator() == null) {
                Intrinsics.throwNpe();
            }
            collection.add(externalNativeJsonGenerator);
        }
        return (List)destination$iv$iv;
    }

    public boolean canBuild(@NotNull String modelName) {
        Intrinsics.checkParameterIsNotNull((Object)modelName, (String)"modelName");
        return Intrinsics.areEqual((Object)modelName, (Object)this.nativeAndroidProjectClass) || Intrinsics.areEqual((Object)modelName, (Object)this.nativeVariantAbiClass);
    }

    @Nullable
    public Object buildAll(@NotNull String modelName, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)modelName, (String)"modelName");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.buildFullNativeAndroidProject(project);
    }

    @Nullable
    public Object buildAll(@NotNull String modelName, @NotNull ModelBuilderParameter parameter, @NotNull Project project) {
        NativeAndroidProject nativeAndroidProject;
        Intrinsics.checkParameterIsNotNull((Object)modelName, (String)"modelName");
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        FailsafeModelBuilderParameter modelBuilderParameter = new FailsafeModelBuilderParameter(parameter);
        String string = modelName;
        if (Intrinsics.areEqual((Object)string, (Object)this.nativeAndroidProjectClass)) {
            nativeAndroidProject = modelBuilderParameter.getShouldBuildVariant() ? this.buildFullNativeAndroidProject(project) : this.buildNativeAndroidProjectWithJustVariantInfos(project);
        } else if (Intrinsics.areEqual((Object)string, (Object)this.nativeVariantAbiClass)) {
            String string2 = modelBuilderParameter.getVariantName();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"modelBuilderParameter.variantName!!");
            String string3 = modelBuilderParameter.getAbiName();
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"modelBuilderParameter.abiName!!");
            nativeAndroidProject = this.buildNativeVariantAbi(project, string2, string3);
        } else {
            throw (Throwable)new RuntimeException("Unexpected model " + modelName);
        }
        return nativeAndroidProject;
    }

    @NotNull
    public Class<ModelBuilderParameter> getParameterType() {
        return ModelBuilderParameter.class;
    }

    private final NativeAndroidProject buildNativeAndroidProjectWithJustVariantInfos(Project project) {
        NativeAndroidProjectBuilder builder = new NativeAndroidProjectBuilder(project.getName());
        Iterable $this$onEach$iv = this.getGenerators();
        boolean $i$f$onEach = false;
        Iterable iterable = $this$onEach$iv;
        boolean bl = false;
        boolean bl2 = false;
        Iterable $this$apply$iv = iterable;
        boolean bl3 = false;
        for (Object element$iv : $this$apply$iv) {
            ExternalNativeJsonGenerator generator = (ExternalNativeJsonGenerator)element$iv;
            boolean bl4 = false;
            this.buildInexpensiveNativeAndroidProjectInformation(builder, generator);
        }
        return builder.buildNativeAndroidProject();
    }

    /*
     * WARNING - void declaration
     */
    private final void buildInexpensiveNativeAndroidProjectInformation(NativeAndroidProjectBuilder builder, ExternalNativeJsonGenerator generator) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        builder.addBuildSystem(generator.getNativeBuildSystem().getName());
        Iterable iterable = generator.getConfig().abiConfigurations;
        String string = generator.getVariantName();
        NativeAndroidProjectBuilder nativeAndroidProjectBuilder = builder;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsonGenerationAbiConfiguration jsonGenerationAbiConfiguration = (JsonGenerationAbiConfiguration)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.getAbiName();
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        nativeAndroidProjectBuilder.addVariantInfo(string, CollectionsKt.distinct((Iterable)collection));
    }

    /*
     * WARNING - void declaration
     */
    private final NativeVariantAbi buildNativeVariantAbi(Project project, String variantName, String abiName) {
        void $this$filterTo$iv$iv;
        NativeAndroidProjectBuilder builder = new NativeAndroidProjectBuilder(project.getName(), abiName);
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        Iterable $this$filter$iv = this.getGenerators();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ExternalNativeJsonGenerator generator = (ExternalNativeJsonGenerator)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)generator.getVariantName(), (Object)variantName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$onEach$iv = (List)destination$iv$iv;
        boolean $i$f$onEach = false;
        iterable = $this$onEach$iv;
        boolean bl = false;
        boolean bl2 = false;
        Iterable $this$apply$iv = iterable;
        boolean bl3 = false;
        for (Object element$iv : $this$apply$iv) {
            void built;
            ExternalNativeJsonGenerator generator = (ExternalNativeJsonGenerator)element$iv;
            boolean bl4 = false;
            generator.buildForOneAbiName(this.getIdeRefreshExternalNativeModel(), abiName);
            this.buildInexpensiveNativeAndroidProjectInformation(builder, generator);
            void v0 = built;
            ++v0.element;
            int cfr_ignored_0 = v0.element;
            try {
                generator.forEachNativeBuildConfiguration(new Consumer<JsonReader>(generator, this, abiName, builder, (Ref.IntRef)built){
                    final /* synthetic */ ExternalNativeJsonGenerator $generator;
                    final /* synthetic */ NativeModelBuilder this$0;
                    final /* synthetic */ String $abiName$inlined;
                    final /* synthetic */ NativeAndroidProjectBuilder $builder$inlined;
                    final /* synthetic */ Ref.IntRef $built$inlined;
                    {
                        this.$generator = externalNativeJsonGenerator;
                        this.this$0 = nativeModelBuilder;
                        this.$abiName$inlined = string;
                        this.$builder$inlined = nativeAndroidProjectBuilder;
                        this.$built$inlined = intRef;
                    }

                    public final void accept(JsonReader jsonReader) {
                        try {
                            this.$builder$inlined.addJson(jsonReader, this.$generator.getVariantName());
                        }
                        catch (IOException e) {
                            throw (Throwable)new RuntimeException("Failed to read native JSON data", e);
                        }
                    }
                });
            }
            catch (IOException e) {
                throw (Throwable)new RuntimeException("Failed to read native JSON data", e);
            }
        }
        NativeVariantAbi nativeVariantAbi = builder.buildNativeVariantAbi(variantName);
        if (nativeVariantAbi == null) {
            Intrinsics.throwNpe();
        }
        return nativeVariantAbi;
    }

    private final NativeAndroidProject buildFullNativeAndroidProject(Project project) {
        this.regenerateNativeJson();
        NativeAndroidProjectBuilder builder = new NativeAndroidProjectBuilder(project.getName());
        Iterable $this$onEach$iv = this.getGenerators();
        boolean $i$f$onEach = false;
        Iterable iterable = $this$onEach$iv;
        boolean bl = false;
        boolean bl2 = false;
        Iterable $this$apply$iv = iterable;
        boolean bl3 = false;
        for (Object element$iv : $this$apply$iv) {
            ExternalNativeJsonGenerator generator = (ExternalNativeJsonGenerator)element$iv;
            boolean bl4 = false;
            this.buildInexpensiveNativeAndroidProjectInformation(builder, generator);
            GradleBuildVariant.Builder stats = ProcessProfileWriter.getOrCreateVariant((String)project.getPath(), (String)generator.getVariantName());
            GradleBuildVariant.NativeBuildConfigInfo.Builder config2 = GradleBuildVariant.NativeBuildConfigInfo.newBuilder();
            GradleBuildVariant.Builder builder2 = stats;
            Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"stats");
            if (builder2.getNativeBuildConfigCount() == 0) {
                stats.addNativeBuildConfig(config2);
            }
            try {
                generator.forEachNativeBuildConfiguration(new Consumer<JsonReader>(generator, config2, this, builder, project){
                    final /* synthetic */ ExternalNativeJsonGenerator $generator;
                    final /* synthetic */ GradleBuildVariant.NativeBuildConfigInfo.Builder $config;
                    final /* synthetic */ NativeModelBuilder this$0;
                    final /* synthetic */ NativeAndroidProjectBuilder $builder$inlined;
                    final /* synthetic */ Project $project$inlined;
                    {
                        this.$generator = externalNativeJsonGenerator;
                        this.$config = builder;
                        this.this$0 = nativeModelBuilder;
                        this.$builder$inlined = nativeAndroidProjectBuilder;
                        this.$project$inlined = project;
                    }

                    public final void accept(JsonReader jsonReader) {
                        try {
                            this.$builder$inlined.addJson(jsonReader, this.$generator.getVariantName(), this.$config);
                        }
                        catch (IOException e) {
                            throw (Throwable)new RuntimeException("Failed to read native JSON data", e);
                        }
                    }
                });
            }
            catch (IOException e) {
                throw (Throwable)new RuntimeException("Failed to read native JSON data", e);
            }
        }
        return builder.buildNativeAndroidProject();
    }

    private final void regenerateNativeJson() {
        if (this.getEnableParallelNativeJsonGen()) {
            int cpuCores = Runtime.getRuntime().availableProcessors();
            int threadNumber = Math.min(cpuCores, 8);
            ExecutorService nativeJsonGenExecutor = Executors.newFixedThreadPool(threadNumber);
            ArrayList buildSteps = new ArrayList();
            Iterator<VariantScope> iterator = this.variantManager.getVariantScopes().iterator();
            while (iterator.hasNext()) {
                VariantScope variantScope;
                VariantScope variantScope2 = variantScope = iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)variantScope2, (String)"variantScope");
                ExternalNativeJsonGenerator generator = variantScope2.getTaskContainer().getExternalNativeJsonGenerator();
                if (generator == null) continue;
                buildSteps.addAll(generator.parallelBuild(this.getIdeRefreshExternalNativeModel()));
            }
            try {
                nativeJsonGenExecutor.invokeAll(buildSteps);
            }
            catch (InterruptedException e) {
                throw (Throwable)new RuntimeException("Thread was interrupted while native build JSON generation was in progress.", e);
            }
        } else {
            for (ExternalNativeJsonGenerator generator : this.getGenerators()) {
                generator.build(this.getIdeRefreshExternalNativeModel());
            }
        }
    }

    public NativeModelBuilder(@NotNull GlobalScope globalScope, @NotNull VariantManager variantManager) {
        Intrinsics.checkParameterIsNotNull((Object)globalScope, (String)"globalScope");
        Intrinsics.checkParameterIsNotNull((Object)variantManager, (String)"variantManager");
        this.globalScope = globalScope;
        this.variantManager = variantManager;
        this.nativeAndroidProjectClass = NativeAndroidProject.class.getName();
        this.nativeVariantAbiClass = NativeVariantAbi.class.getName();
    }
}

