/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.external.gnumake;

import com.android.build.gradle.external.gnumake.CommandLine;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.List;

class BuildStepInfo {
    private final CommandLine command;
    private final List<String> inputs;
    private final List<String> outputs;
    private final boolean inputsAreSourceFiles;

    BuildStepInfo(CommandLine command, List<String> inputs, List<String> outputs) {
        this(command, inputs, outputs, false);
    }

    BuildStepInfo(CommandLine command, List<String> inputs, List<String> outputs, boolean inputsAreSourceFiles) {
        this.command = command;
        this.inputs = Lists.newArrayList(inputs);
        this.outputs = Lists.newArrayList(outputs);
        this.inputsAreSourceFiles = inputsAreSourceFiles;
        for (String input2 : inputs) {
            if (input2 != null) continue;
            throw new RuntimeException(String.format("GNUMAKE: Unexpected null input in %s", this));
        }
        if (this.inputsAreSourceFiles() && this.getInputs().size() != 1) {
            throw new RuntimeException(String.format("GNUMAKE: Expected exactly one source file in compile step: %s\nbut received: \n%s\nin command:\n%s\n", this, Joiner.on((String)"\n").join(this.getInputs()), command));
        }
    }

    String getOnlyInput() {
        if (this.getInputs().size() != 1) {
            throw new RuntimeException("Did not expect multiple inputs");
        }
        return this.getInputs().iterator().next();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BuildStepInfo)) {
            return false;
        }
        BuildStepInfo that = (BuildStepInfo)obj;
        return this.command.executable.equals(that.command.executable) && this.inputs.equals(that.getInputs()) && this.outputs.equals(that.getOutputs()) && this.inputsAreSourceFiles == that.inputsAreSourceFiles;
    }

    public String toString() {
        return this.command.executable + " in:[" + Joiner.on((char)' ').join(this.inputs) + "] out:[" + Joiner.on((char)' ').join(this.outputs) + "]" + (this.inputsAreSourceFiles ? "SOURCE" : "INTERMEDIATE");
    }

    CommandLine getCommand() {
        return this.command;
    }

    List<String> getInputs() {
        return this.inputs;
    }

    List<String> getOutputs() {
        return this.outputs;
    }

    boolean inputsAreSourceFiles() {
        return this.inputsAreSourceFiles;
    }
}

