/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test;

import com.android.build.VariantOutput;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.core.VariantConfiguration;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.ide.common.build.SplitOutputMatcher;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class TestDataImpl
extends AbstractTestDataImpl {
    private final TestVariantData testVariantData;
    private final VariantConfiguration testVariantConfig;

    public TestDataImpl(TestVariantData testVariantData, BuildableArtifact testApkDir, BuildableArtifact testedApksDir) {
        super(testVariantData.getVariantConfiguration(), testApkDir, testedApksDir);
        this.testVariantData = testVariantData;
        this.testVariantConfig = testVariantData.getVariantConfiguration();
        if (testVariantData.getOutputScope().getSplitsByType(VariantOutput.OutputType.FULL_SPLIT).size() > 1) {
            throw new RuntimeException("Multi-output in test variant not yet supported");
        }
    }

    public void loadFromMetadataFile(File metadataFile) throws ParserConfigurationException, SAXException, IOException {
    }

    public String getApplicationId() {
        return this.testVariantData.getApplicationId();
    }

    public String getTestedApplicationId() {
        return this.testVariantConfig.getTestedApplicationId();
    }

    public boolean isLibrary() {
        TestedVariantData testedVariantData = this.testVariantData.getTestedVariantData();
        BaseVariantData testedVariantData2 = (BaseVariantData)((Object)testedVariantData);
        return testedVariantData2.getVariantConfiguration().getType().isAar();
    }

    public ImmutableList<File> getTestedApks(ProcessExecutor processExecutor, File splitSelectExe, DeviceConfigProvider deviceConfigProvider, ILogger logger) throws ProcessException {
        BaseVariantData testedVariantData = (BaseVariantData)((Object)this.testVariantData.getTestedVariantData());
        ImmutableList.Builder apks = ImmutableList.builder();
        ImmutableList splitOutputs = ImmutableList.copyOf((Iterable)ExistingBuildElements.from((ArtifactType)InternalArtifactType.APK, testedVariantData.getScope().getArtifacts().getFinalArtifactFiles(InternalArtifactType.APK)));
        apks.addAll((Iterable)SplitOutputMatcher.computeBestOutput((ProcessExecutor)processExecutor, (File)splitSelectExe, (DeviceConfigProvider)deviceConfigProvider, (Collection)splitOutputs, testedVariantData.getVariantConfiguration().getSupportedAbis()));
        return apks.build();
    }
}

