/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.dependencies;

import com.android.build.gradle.internal.ide.dependencies.BuildMappingUtils;
import com.android.build.gradle.internal.ide.dependencies.LibraryUtils;
import com.android.build.gradle.internal.ide.dependencies.MavenCoordinatesUtils;
import com.android.builder.dependency.MavenCoordinatesImpl;
import com.android.builder.model.MavenCoordinates;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.internal.component.local.model.OpaqueComponentArtifactIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u00010B=\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fBM\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\u0013J\t\u0010 \u001a\u00020\u000eH\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\t\u0010\"\u001a\u00020\u0011H\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u0011H\u00c6\u0003J\t\u0010$\u001a\u00020\u0006H\u00c6\u0003J\t\u0010%\u001a\u00020\bH\u00c6\u0003J\u0015\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003J\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020\u000bJ_\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0001J\u0013\u0010+\u001a\u00020\b2\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010-\u001a\u00020.H\u00d6\u0001J\t\u0010/\u001a\u00020\u000bH\u00d6\u0001R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u001dR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00061"}, d2={"Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact;", "", "mainArtifactResult", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "secondaryArtifactResult", "dependencyType", "Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact$DependencyType;", "isWrappedModule", "", "buildMapping", "Lcom/google/common/collect/ImmutableMap;", "", "(Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact$DependencyType;ZLcom/google/common/collect/ImmutableMap;)V", "componentIdentifier", "Lorg/gradle/api/artifacts/component/ComponentIdentifier;", "variantName", "artifactFile", "Ljava/io/File;", "extractedFolder", "(Lorg/gradle/api/artifacts/component/ComponentIdentifier;Ljava/lang/String;Ljava/io/File;Ljava/io/File;Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact$DependencyType;ZLcom/google/common/collect/ImmutableMap;)V", "getArtifactFile", "()Ljava/io/File;", "getBuildMapping", "()Lcom/google/common/collect/ImmutableMap;", "getComponentIdentifier", "()Lorg/gradle/api/artifacts/component/ComponentIdentifier;", "getDependencyType", "()Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact$DependencyType;", "getExtractedFolder", "()Z", "getVariantName", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "computeMavenCoordinates", "Lcom/android/builder/model/MavenCoordinates;", "computeModelAddress", "copy", "equals", "other", "hashCode", "", "toString", "DependencyType", "gradle"})
public final class ResolvedArtifact {
    @NotNull
    private final ComponentIdentifier componentIdentifier;
    @Nullable
    private final String variantName;
    @NotNull
    private final File artifactFile;
    @Nullable
    private final File extractedFolder;
    @NotNull
    private final DependencyType dependencyType;
    private final boolean isWrappedModule;
    @NotNull
    private final ImmutableMap<String, String> buildMapping;

    @NotNull
    public final MavenCoordinates computeMavenCoordinates() {
        MavenCoordinates mavenCoordinates;
        ComponentIdentifier componentIdentifier = this.componentIdentifier;
        if (componentIdentifier instanceof ModuleComponentIdentifier) {
            String pattern;
            Pattern p;
            Matcher m;
            String module = ((ModuleComponentIdentifier)this.componentIdentifier).getModule();
            String version = ((ModuleComponentIdentifier)this.componentIdentifier).getVersion();
            String extension = this.dependencyType.getExtension();
            String classifier = null;
            if (!this.artifactFile.isDirectory() && (m = (p = Pattern.compile(pattern = '^' + module + '-' + version + "-(.+)\\." + extension + '$')).matcher(this.artifactFile.getName())).matches()) {
                classifier = m.group(1);
            }
            mavenCoordinates = (MavenCoordinates)new MavenCoordinatesImpl(((ModuleComponentIdentifier)this.componentIdentifier).getGroup(), module, version, extension, classifier);
        } else if (componentIdentifier instanceof ProjectComponentIdentifier) {
            mavenCoordinates = (MavenCoordinates)new MavenCoordinatesImpl("artifacts", ((ProjectComponentIdentifier)this.componentIdentifier).getProjectPath(), "unspecified");
        } else if (componentIdentifier instanceof OpaqueComponentArtifactIdentifier) {
            MavenCoordinatesImpl mavenCoordinatesImpl;
            if (this.dependencyType == DependencyType.JAVA) {
                mavenCoordinatesImpl = MavenCoordinatesUtils.getMavenCoordForLocalFile(this.artifactFile);
            } else {
                boolean bl = this.artifactFile.isDirectory();
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                mavenCoordinatesImpl = MavenCoordinatesUtils.getMavenCoordForLocalFile(this.artifactFile);
            }
            mavenCoordinates = (MavenCoordinates)mavenCoordinatesImpl;
        } else {
            throw (Throwable)new RuntimeException("Don't know how to compute maven coordinate for artifact '" + this.componentIdentifier.getDisplayName() + "' with component identifier of type '" + this.componentIdentifier.getClass() + "'.");
        }
        return mavenCoordinates;
    }

    @NotNull
    public final String computeModelAddress() {
        String string;
        ComponentIdentifier componentIdentifier = this.componentIdentifier;
        if (componentIdentifier instanceof ProjectComponentIdentifier) {
            CharSequence charSequence = new StringBuilder(100).append(BuildMappingUtils.getBuildId((ProjectComponentIdentifier)this.componentIdentifier, this.buildMapping)).append("@@").append(((ProjectComponentIdentifier)this.componentIdentifier).getProjectPath());
            StringBuilder sb = charSequence;
            String string2 = this.variantName;
            if (string2 != null) {
                String string3;
                String it = string3 = string2;
                sb.append("::").append(it);
            }
            String string4 = ((StringBuilder)charSequence).toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"StringBuilder(100)\n     \u2026              .toString()");
            CharSequence charSequence2 = charSequence = string4;
            if (charSequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = ((String)charSequence2).intern();
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).intern()");
        } else if (componentIdentifier instanceof ModuleComponentIdentifier || componentIdentifier instanceof OpaqueComponentArtifactIdentifier) {
            String string6;
            String string7 = string6 = MavenCoordinatesUtils.getMavenCoordinates(this).toString();
            if (string7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.intern();
            string = string8;
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).intern()");
        } else {
            throw (Throwable)new RuntimeException("Don't know how to handle ComponentIdentifier '" + this.componentIdentifier.getDisplayName() + "'of type " + this.componentIdentifier.getClass());
        }
        return string;
    }

    @NotNull
    public final ComponentIdentifier getComponentIdentifier() {
        return this.componentIdentifier;
    }

    @Nullable
    public final String getVariantName() {
        return this.variantName;
    }

    @NotNull
    public final File getArtifactFile() {
        return this.artifactFile;
    }

    @Nullable
    public final File getExtractedFolder() {
        return this.extractedFolder;
    }

    @NotNull
    public final DependencyType getDependencyType() {
        return this.dependencyType;
    }

    public final boolean isWrappedModule() {
        return this.isWrappedModule;
    }

    @NotNull
    public final ImmutableMap<String, String> getBuildMapping() {
        return this.buildMapping;
    }

    public ResolvedArtifact(@NotNull ComponentIdentifier componentIdentifier, @Nullable String variantName, @NotNull File artifactFile, @Nullable File extractedFolder, @NotNull DependencyType dependencyType, boolean isWrappedModule, @NotNull ImmutableMap<String, String> buildMapping) {
        Intrinsics.checkParameterIsNotNull((Object)componentIdentifier, (String)"componentIdentifier");
        Intrinsics.checkParameterIsNotNull((Object)artifactFile, (String)"artifactFile");
        Intrinsics.checkParameterIsNotNull((Object)((Object)dependencyType), (String)"dependencyType");
        Intrinsics.checkParameterIsNotNull(buildMapping, (String)"buildMapping");
        this.componentIdentifier = componentIdentifier;
        this.variantName = variantName;
        this.artifactFile = artifactFile;
        this.extractedFolder = extractedFolder;
        this.dependencyType = dependencyType;
        this.isWrappedModule = isWrappedModule;
        this.buildMapping = buildMapping;
    }

    public ResolvedArtifact(@NotNull ResolvedArtifactResult mainArtifactResult, @Nullable ResolvedArtifactResult secondaryArtifactResult, @NotNull DependencyType dependencyType, boolean isWrappedModule, @NotNull ImmutableMap<String, String> buildMapping) {
        Intrinsics.checkParameterIsNotNull((Object)mainArtifactResult, (String)"mainArtifactResult");
        Intrinsics.checkParameterIsNotNull((Object)((Object)dependencyType), (String)"dependencyType");
        Intrinsics.checkParameterIsNotNull(buildMapping, (String)"buildMapping");
        ComponentArtifactIdentifier componentArtifactIdentifier = mainArtifactResult.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier, (String)"mainArtifactResult.id");
        ComponentIdentifier componentIdentifier = componentArtifactIdentifier.getComponentIdentifier();
        Intrinsics.checkExpressionValueIsNotNull((Object)componentIdentifier, (String)"mainArtifactResult.id.componentIdentifier");
        String string = LibraryUtils.getVariantName(mainArtifactResult);
        File file = mainArtifactResult.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"mainArtifactResult.file");
        ResolvedArtifactResult resolvedArtifactResult = secondaryArtifactResult;
        this(componentIdentifier, string, file, resolvedArtifactResult != null ? resolvedArtifactResult.getFile() : null, dependencyType, isWrappedModule, buildMapping);
    }

    @NotNull
    public final ComponentIdentifier component1() {
        return this.componentIdentifier;
    }

    @Nullable
    public final String component2() {
        return this.variantName;
    }

    @NotNull
    public final File component3() {
        return this.artifactFile;
    }

    @Nullable
    public final File component4() {
        return this.extractedFolder;
    }

    @NotNull
    public final DependencyType component5() {
        return this.dependencyType;
    }

    public final boolean component6() {
        return this.isWrappedModule;
    }

    @NotNull
    public final ImmutableMap<String, String> component7() {
        return this.buildMapping;
    }

    @NotNull
    public final ResolvedArtifact copy(@NotNull ComponentIdentifier componentIdentifier, @Nullable String variantName, @NotNull File artifactFile, @Nullable File extractedFolder, @NotNull DependencyType dependencyType, boolean isWrappedModule, @NotNull ImmutableMap<String, String> buildMapping) {
        Intrinsics.checkParameterIsNotNull((Object)componentIdentifier, (String)"componentIdentifier");
        Intrinsics.checkParameterIsNotNull((Object)artifactFile, (String)"artifactFile");
        Intrinsics.checkParameterIsNotNull((Object)((Object)dependencyType), (String)"dependencyType");
        Intrinsics.checkParameterIsNotNull(buildMapping, (String)"buildMapping");
        return new ResolvedArtifact(componentIdentifier, variantName, artifactFile, extractedFolder, dependencyType, isWrappedModule, buildMapping);
    }

    @NotNull
    public static /* synthetic */ ResolvedArtifact copy$default(ResolvedArtifact resolvedArtifact, ComponentIdentifier componentIdentifier, String string, File file, File file2, DependencyType dependencyType, boolean bl, ImmutableMap immutableMap, int n, Object object) {
        if ((n & 1) != 0) {
            componentIdentifier = resolvedArtifact.componentIdentifier;
        }
        if ((n & 2) != 0) {
            string = resolvedArtifact.variantName;
        }
        if ((n & 4) != 0) {
            file = resolvedArtifact.artifactFile;
        }
        if ((n & 8) != 0) {
            file2 = resolvedArtifact.extractedFolder;
        }
        if ((n & 0x10) != 0) {
            dependencyType = resolvedArtifact.dependencyType;
        }
        if ((n & 0x20) != 0) {
            bl = resolvedArtifact.isWrappedModule;
        }
        if ((n & 0x40) != 0) {
            immutableMap = resolvedArtifact.buildMapping;
        }
        return resolvedArtifact.copy(componentIdentifier, string, file, file2, dependencyType, bl, immutableMap);
    }

    @NotNull
    public String toString() {
        return "ResolvedArtifact(componentIdentifier=" + this.componentIdentifier + ", variantName=" + this.variantName + ", artifactFile=" + this.artifactFile + ", extractedFolder=" + this.extractedFolder + ", dependencyType=" + (Object)((Object)this.dependencyType) + ", isWrappedModule=" + this.isWrappedModule + ", buildMapping=" + this.buildMapping + ")";
    }

    public int hashCode() {
        ComponentIdentifier componentIdentifier = this.componentIdentifier;
        String string = this.variantName;
        File file = this.artifactFile;
        File file2 = this.extractedFolder;
        DependencyType dependencyType = this.dependencyType;
        int n = (((((componentIdentifier != null ? componentIdentifier.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (file != null ? ((Object)file).hashCode() : 0)) * 31 + (file2 != null ? ((Object)file2).hashCode() : 0)) * 31 + (dependencyType != null ? ((Object)((Object)dependencyType)).hashCode() : 0)) * 31;
        int n2 = this.isWrappedModule ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        ImmutableMap<String, String> immutableMap = this.buildMapping;
        return (n + n2) * 31 + (immutableMap != null ? immutableMap.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ResolvedArtifact)) break block3;
                ResolvedArtifact resolvedArtifact = (ResolvedArtifact)object;
                if (!Intrinsics.areEqual((Object)this.componentIdentifier, (Object)resolvedArtifact.componentIdentifier) || !Intrinsics.areEqual((Object)this.variantName, (Object)resolvedArtifact.variantName) || !Intrinsics.areEqual((Object)this.artifactFile, (Object)resolvedArtifact.artifactFile) || !Intrinsics.areEqual((Object)this.extractedFolder, (Object)resolvedArtifact.extractedFolder) || !Intrinsics.areEqual((Object)((Object)this.dependencyType), (Object)((Object)resolvedArtifact.dependencyType)) || !(this.isWrappedModule == resolvedArtifact.isWrappedModule) || !Intrinsics.areEqual(this.buildMapping, resolvedArtifact.buildMapping)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact$DependencyType;", "", "extension", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getExtension", "()Ljava/lang/String;", "JAVA", "ANDROID", "gradle"})
    public static final class DependencyType
    extends Enum<DependencyType> {
        public static final /* enum */ DependencyType JAVA;
        public static final /* enum */ DependencyType ANDROID;
        private static final /* synthetic */ DependencyType[] $VALUES;
        @NotNull
        private final String extension;

        static {
            DependencyType[] dependencyTypeArray = new DependencyType[2];
            DependencyType[] dependencyTypeArray2 = dependencyTypeArray;
            dependencyTypeArray[0] = JAVA = new DependencyType("jar");
            dependencyTypeArray[1] = ANDROID = new DependencyType("aar");
            $VALUES = dependencyTypeArray;
        }

        @NotNull
        public final String getExtension() {
            return this.extension;
        }

        protected DependencyType(String extension) {
            Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
            this.extension = extension;
        }

        public static DependencyType[] values() {
            return (DependencyType[])$VALUES.clone();
        }

        public static DependencyType valueOf(String string) {
            return Enum.valueOf(DependencyType.class, string);
        }
    }
}

