/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.SdkConstants;
import com.android.build.gradle.external.cmake.CmakeUtils;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.model.CoreExternalNativeBuild;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.repository.Revision;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class ExternalNativeBuildTaskUtils {
    public static final String CUSTOM_FORK_CMAKE_VERSION = "3.6.0-rc2";

    public static boolean fileIsUpToDate(File source, File derived) throws IOException {
        long derivedTimestamp;
        if (!source.exists()) {
            return false;
        }
        if (!derived.exists()) {
            return false;
        }
        long sourceTimestamp = Files.getLastModifiedTime(source.toPath(), new LinkOption[0]).toMillis();
        return sourceTimestamp <= (derivedTimestamp = Files.getLastModifiedTime(derived.toPath(), new LinkOption[0]).toMillis());
    }

    public static File getJsonMiniConfigFile(File originalJson) {
        return new File(originalJson.getParent(), "android_gradle_build_mini.json");
    }

    static File getOutputFolder(File jsonFolder, String abi) {
        return new File(jsonFolder, abi);
    }

    public static File getOutputJson(File jsonFolder, String abi) {
        return new File(ExternalNativeBuildTaskUtils.getOutputFolder(jsonFolder, abi), "android_gradle_build.json");
    }

    public static File getCompileCommandsJson(File jsonFolder, String abi) {
        return new File(ExternalNativeBuildTaskUtils.getOutputFolder(jsonFolder, abi), "compile_commands.json");
    }

    public static List<File> getOutputJsons(File jsonFolder, Collection<String> abis) {
        ArrayList outputs = Lists.newArrayList();
        for (String abi : abis) {
            outputs.add(ExternalNativeBuildTaskUtils.getOutputJson(jsonFolder, abi));
        }
        return outputs;
    }

    public static boolean isExternalNativeBuildEnabled(CoreExternalNativeBuild config2) {
        return config2.getNdkBuild().getPath() != null || config2.getCmake().getPath() != null;
    }

    public static ExternalNativeBuildProjectPathResolution getProjectPath(CoreExternalNativeBuild config2) {
        Map<NativeBuildSystem, File> externalProjectPaths = ExternalNativeBuildTaskUtils.getExternalBuildExplicitPaths(config2);
        if (externalProjectPaths.size() > 1) {
            return new ExternalNativeBuildProjectPathResolution(null, null, null, "More than one externalNativeBuild path specified");
        }
        if (externalProjectPaths.isEmpty()) {
            return new ExternalNativeBuildProjectPathResolution(null, null, null, null);
        }
        NativeBuildSystem buildSystem = externalProjectPaths.keySet().iterator().next();
        return new ExternalNativeBuildProjectPathResolution(buildSystem, externalProjectPaths.get((Object)buildSystem), ExternalNativeBuildTaskUtils.getExternalNativeBuildPath(config2).get((Object)buildSystem), null);
    }

    private static Map<NativeBuildSystem, File> getExternalBuildExplicitPaths(CoreExternalNativeBuild config2) {
        EnumMap<NativeBuildSystem, File> map = new EnumMap<NativeBuildSystem, File>(NativeBuildSystem.class);
        File cmake = config2.getCmake().getPath();
        File ndkBuild = config2.getNdkBuild().getPath();
        if (cmake != null) {
            map.put(NativeBuildSystem.CMAKE, cmake);
        }
        if (ndkBuild != null) {
            map.put(NativeBuildSystem.NDK_BUILD, ndkBuild);
        }
        return map;
    }

    private static Map<NativeBuildSystem, File> getExternalNativeBuildPath(CoreExternalNativeBuild config2) {
        EnumMap<NativeBuildSystem, File> map = new EnumMap<NativeBuildSystem, File>(NativeBuildSystem.class);
        File cmake = config2.getCmake().getBuildStagingDirectory();
        File ndkBuild = config2.getNdkBuild().getBuildStagingDirectory();
        if (cmake != null) {
            map.put(NativeBuildSystem.CMAKE, cmake);
        }
        if (ndkBuild != null) {
            map.put(NativeBuildSystem.NDK_BUILD, ndkBuild);
        }
        return map;
    }

    public static File findCmakeExecutableFolder(String cmakeVersion, SdkHandler sdkHandler) {
        return ExternalNativeBuildTaskUtils.doFindCmakeExecutableFolder(cmakeVersion, sdkHandler, ExternalNativeBuildTaskUtils.getEnvironmentPathList());
    }

    private static List<File> getEnvironmentPathList() {
        ArrayList<File> fileList = new ArrayList<File>();
        String envPath = System.getenv("PATH");
        ArrayList<String> pathList = new ArrayList<String>();
        if (envPath != null) {
            pathList.addAll(Arrays.asList(envPath.split(System.getProperty("path.separator"))));
        }
        for (String path : pathList) {
            fileList.add(new File(path));
        }
        return fileList;
    }

    @VisibleForTesting
    static File doFindCmakeExecutableFolder(String cmakeVersion, SdkHandler sdkHandler, List<File> foldersToSearch) {
        if (sdkHandler.getCmakePathInLocalProp() != null) {
            return sdkHandler.getCmakePathInLocalProp();
        }
        if (cmakeVersion != null && !ExternalNativeBuildTaskUtils.isDefaultSdkCmakeVersion(cmakeVersion)) {
            File cmakeFolder = ExternalNativeBuildTaskUtils.getRequiredCmakeFromFolders(Revision.parseRevision((String)cmakeVersion), foldersToSearch);
            return new File(cmakeFolder.getParent());
        }
        return ExternalNativeBuildTaskUtils.getCmakeFolderFromSdkPackage(sdkHandler);
    }

    private static boolean isDefaultSdkCmakeVersion(String cmakeVersion) {
        return cmakeVersion.equals(CUSTOM_FORK_CMAKE_VERSION);
    }

    private static File getRequiredCmakeFromFolders(Revision cmakeVersion, List<File> foldersToSearch) {
        ArrayList<File> foldersWithErrors = new ArrayList<File>();
        for (File cmakeFolder : foldersToSearch) {
            File cmakeBin = SdkConstants.CURRENT_PLATFORM == 2 ? new File(cmakeFolder, "cmake.exe") : new File(cmakeFolder, "cmake");
            if (!cmakeBin.exists()) continue;
            try {
                Revision version = CmakeUtils.getVersion(cmakeFolder);
                if (!cmakeVersion.equals((Object)version)) continue;
                return cmakeFolder;
            }
            catch (IOException e) {
                foldersWithErrors.add(cmakeFolder);
            }
        }
        StringBuilder errorMsg = new StringBuilder(String.format("Unable to find CMake with version: %s within folder: %s\n.", cmakeVersion, foldersToSearch.toString()));
        if (!foldersWithErrors.isEmpty()) {
            errorMsg.append(String.format("Folders have inaccessible/corrupt CMake: %s", ((Object)foldersWithErrors).toString()));
        }
        errorMsg.append("Please make sure the folder with the CMake binary is added to the PATH environment variable.");
        throw new RuntimeException(errorMsg.toString());
    }

    private static File getCmakeFolderFromSdkPackage(SdkHandler sdkHandler) {
        ConsoleProgressIndicator progress = new ConsoleProgressIndicator();
        AndroidSdkHandler sdk = AndroidSdkHandler.getInstance((File)sdkHandler.getSdkFolder());
        LocalPackage cmakePackage = sdk.getLatestLocalPackageForPrefix("cmake", null, true, (ProgressIndicator)progress);
        if (cmakePackage != null) {
            return cmakePackage.getLocation();
        }
        sdkHandler.installCMake("3.6.4111459");
        cmakePackage = sdk.getLatestLocalPackageForPrefix("cmake", null, true, (ProgressIndicator)progress);
        if (cmakePackage != null) {
            return cmakePackage.getLocation();
        }
        return new File(sdkHandler.getSdkFolder(), "cmake");
    }

    public static class ExternalNativeBuildProjectPathResolution {
        public final String errorText;
        public final NativeBuildSystem buildSystem;
        public final File makeFile;
        public final File cxxBuildDir;

        private ExternalNativeBuildProjectPathResolution(NativeBuildSystem buildSystem, File makeFile, File cxxBuildDir, String errorText) {
            Preconditions.checkArgument((makeFile == null || buildSystem != null ? 1 : 0) != 0, (Object)"Expected path and buildSystem together, no taskClass");
            Preconditions.checkArgument((makeFile != null || buildSystem == null ? 1 : 0) != 0, (Object)"Expected path and buildSystem together, no path");
            Preconditions.checkArgument((makeFile == null || errorText == null ? 1 : 0) != 0, (Object)"Expected path or error but both existed");
            this.buildSystem = buildSystem;
            this.makeFile = makeFile;
            this.cxxBuildDir = cxxBuildDir;
            this.errorText = errorText;
        }
    }
}

