/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.AnchorOutputType;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.VariantAwareTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.options.BooleanOption;
import java.io.File;
import java.util.Objects;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.testing.JUnitXmlReport;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestTaskReports;

@CacheableTask
public class AndroidUnitTest
extends Test
implements VariantAwareTask {
    private Integer sdkApiLevel;
    private Provider<Directory> mergedManifest;
    private BuildableArtifact resCollection;
    private BuildableArtifact assetsCollection;
    private String variantName;

    @Override
    @Internal
    public String getVariantName() {
        return this.variantName;
    }

    @Override
    public void setVariantName(String name) {
        this.variantName = name;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public BuildableArtifact getResCollection() {
        return this.resCollection;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public BuildableArtifact getAssetsCollection() {
        return this.assetsCollection;
    }

    @Input
    public Integer getSdkApiLevel() {
        return this.sdkApiLevel;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public Provider<Directory> getMergedManifest() {
        return this.mergedManifest;
    }

    public static class CreationAction
    extends VariantTaskCreationAction<AndroidUnitTest> {
        public CreationAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("test");
        }

        @Override
        public Class<AndroidUnitTest> getType() {
            return AndroidUnitTest.class;
        }

        @Override
        public void configure(AndroidUnitTest task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            TestVariantData variantData = (TestVariantData)scope.getVariantData();
            BaseVariantData testedVariantData = (BaseVariantData)((Object)variantData.getTestedVariantData());
            task.systemProperty("java.awt.headless", "true");
            task.setGroup("verification");
            task.setDescription("Run unit tests for the " + testedVariantData.getVariantConfiguration().getFullName() + " build.");
            task.setTestClassesDirs((FileCollection)scope.getArtifacts().getFinalArtifactFiles(AnchorOutputType.ALL_CLASSES).get());
            boolean includeAndroidResources = scope.getGlobalScope().getExtension().getTestOptions().getUnitTests().isIncludeAndroidResources();
            task.setClasspath((FileCollection)this.computeClasspath(includeAndroidResources));
            task.sdkApiLevel = scope.getGlobalScope().getAndroidBuilder().getTarget().getVersion().getFeatureLevel();
            VariantScope testedScope = testedVariantData.getScope();
            if (includeAndroidResources) {
                task.assetsCollection = testedScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.MERGED_ASSETS);
                boolean enableBinaryResources = scope.getGlobalScope().getProjectOptions().get(BooleanOption.ENABLE_UNIT_TEST_BINARY_RESOURCES);
                if (enableBinaryResources) {
                    task.resCollection = scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.APK_FOR_LOCAL_TEST);
                } else {
                    task.resCollection = scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.MERGED_RES);
                }
            }
            task.mergedManifest = testedScope.getArtifacts().getFinalProduct(InternalArtifactType.MERGED_MANIFESTS);
            TestTaskReports testTaskReports = task.getReports();
            JUnitXmlReport xmlReport = testTaskReports.getJunitXml();
            xmlReport.setDestination(new File(scope.getGlobalScope().getTestResultsFolder(), task.getName()));
            DirectoryReport htmlReport = testTaskReports.getHtml();
            htmlReport.setDestination(new File(scope.getGlobalScope().getTestReportFolder(), task.getName()));
            scope.getGlobalScope().getExtension().getTestOptions().getUnitTests().applyConfiguration(task);
            task.getOutputs().doNotCacheIf("AndroidUnitTest task is not yet cacheable when includeAndroidResources=true", thisTask -> includeAndroidResources);
        }

        private ConfigurableFileCollection computeClasspath(boolean includeAndroidResources) {
            VariantScope scope = this.getVariantScope();
            ConfigurableFileCollection collection = scope.getGlobalScope().getProject().files(new Object[0]);
            BuildArtifactsHolder artifacts = scope.getArtifacts();
            if (includeAndroidResources) {
                collection.from(new Object[]{artifacts.getFinalArtifactFiles(InternalArtifactType.UNIT_TEST_CONFIG_DIRECTORY)});
            }
            collection.from(new Object[]{artifacts.getFinalArtifactFiles(AnchorOutputType.ALL_CLASSES).get()});
            collection.from(new Object[]{artifacts.getFinalArtifactFiles(InternalArtifactType.JAVA_RES)});
            collection.from(new Object[]{scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CLASSES)});
            collection.from(new Object[]{scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.JAVA_RES)});
            VariantScope testedScope = Objects.requireNonNull(scope.getTestedVariantData()).getScope();
            if (testedScope.getArtifacts().hasArtifact(InternalArtifactType.COMPILE_ONLY_NOT_NAMESPACED_R_CLASS_JAR)) {
                collection.from(new Object[]{testedScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.COMPILE_ONLY_NOT_NAMESPACED_R_CLASS_JAR)});
            }
            collection.from(new Object[]{scope.getGlobalScope().getProject().files(new Object[]{scope.getGlobalScope().getAndroidBuilder().computeAdditionalAndRequestedOptionalLibraries()})});
            collection.from(new Object[]{scope.getGlobalScope().getMockableJarArtifact()});
            return collection;
        }
    }
}

