/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.FeatureTaskManager;
import com.android.build.gradle.internal.LibraryTaskManager;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.scope.AnchorOutputType;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.builder.profile.Recorder;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class MultiTypeTaskManager
extends TaskManager {
    Map<VariantType, TaskManager> delegates;

    public MultiTypeTaskManager(GlobalScope globalScope, Project project, ProjectOptions projectOptions, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, SdkHandler sdkHandler, VariantFactory variantFactory, ToolingModelBuilderRegistry toolingRegistry, Recorder recorder) {
        super(globalScope, project, projectOptions, dataBindingBuilder, extension, sdkHandler, variantFactory, toolingRegistry, recorder);
        FeatureTaskManager featureTaskManager = new FeatureTaskManager(globalScope, project, projectOptions, dataBindingBuilder, extension, sdkHandler, variantFactory, toolingRegistry, recorder);
        this.delegates = ImmutableMap.of((Object)VariantTypeImpl.FEATURE, (Object)featureTaskManager, (Object)VariantTypeImpl.BASE_FEATURE, (Object)featureTaskManager, (Object)VariantTypeImpl.LIBRARY, (Object)new LibraryTaskManager(globalScope, project, projectOptions, dataBindingBuilder, extension, sdkHandler, variantFactory, toolingRegistry, recorder));
    }

    @Override
    public void createTasksForVariantScope(VariantScope variantScope) {
        this.delegates.get(variantScope.getType()).createTasksForVariantScope(variantScope);
    }

    @Override
    protected Set<QualifiedContent.ScopeType> getResMergingScopes(VariantScope variantScope) {
        VariantType variantType = variantScope.getType();
        if (variantType.isTestComponent()) {
            variantType = variantScope.getTestedVariantData().getType();
        }
        return this.delegates.get(variantType).getResMergingScopes(variantScope);
    }

    @Override
    protected void postJavacCreation(VariantScope scope) {
        ConfigurableFileCollection files2 = scope.getGlobalScope().getProject().files(new Object[]{scope.getArtifacts().getArtifactFiles(InternalArtifactType.JAVAC), scope.getVariantData().getAllPreJavacGeneratedBytecode(), scope.getVariantData().getAllPostJavacGeneratedBytecode()});
        scope.getArtifacts().appendArtifact(AnchorOutputType.ALL_CLASSES, (FileCollection)files2);
    }
}

