/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.dependencies;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.invocation.Gradle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0003j\u0002`\u0004*\u00020\u0005\u001a$\u0010\u0006\u001a\u0004\u0018\u00010\u0001*\u00020\u00072\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0003j\u0002`\u0004\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000*\"\u0010\t\"\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00032\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0003\u00a8\u0006\n"}, d2={"CURRENT_BUILD_NAME", "", "computeBuildMapping", "Lcom/google/common/collect/ImmutableMap;", "Lcom/android/build/gradle/internal/ide/dependencies/BuildMapping;", "Lorg/gradle/api/invocation/Gradle;", "getBuildId", "Lorg/gradle/api/artifacts/component/ProjectComponentIdentifier;", "mapping", "BuildMapping", "gradle"})
@JvmName(name="BuildMappingUtils")
public final class BuildMappingUtils {
    private static final String CURRENT_BUILD_NAME = "__current_build__";

    @Nullable
    public static final String getBuildId(@NotNull ProjectComponentIdentifier $receiver, @NotNull ImmutableMap<String, String> mapping) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(mapping, (String)"mapping");
        BuildIdentifier buildIdentifier = $receiver.getBuild();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildIdentifier, (String)"build");
        if (buildIdentifier.isCurrentBuild()) {
            string = CURRENT_BUILD_NAME;
        } else {
            BuildIdentifier buildIdentifier2 = $receiver.getBuild();
            Intrinsics.checkExpressionValueIsNotNull((Object)buildIdentifier2, (String)"build");
            string = buildIdentifier2.getName();
        }
        return (String)mapping.get((Object)string);
    }

    @NotNull
    public static final ImmutableMap<String, String> computeBuildMapping(@NotNull Gradle $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Project project = $receiver.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"rootProject");
        File file = project.getProjectDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"rootProject.projectDir");
        String currentBuildPath = file.getAbsolutePath();
        builder.put((Object)CURRENT_BUILD_NAME, (Object)currentBuildPath);
        Gradle rootGradleProject = $receiver;
        while (true) {
            Gradle gradle = rootGradleProject;
            if (gradle == null) {
                Intrinsics.throwNpe();
            }
            if (gradle.getParent() == null) break;
            rootGradleProject = rootGradleProject.getParent();
        }
        if (rootGradleProject != $receiver) {
            Project project2 = rootGradleProject.getRootProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"rootGradleProject.rootProject");
            String string = project2.getName();
            Project project3 = rootGradleProject.getRootProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"rootGradleProject.rootProject");
            File file2 = project3.getProjectDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"rootGradleProject.rootProject.projectDir");
            builder.put((Object)string, (Object)file2.getAbsolutePath());
        }
        Iterator iterator = rootGradleProject.getIncludedBuilds().iterator();
        while (iterator.hasNext()) {
            IncludedBuild includedBuild;
            IncludedBuild includedBuild2 = includedBuild = (IncludedBuild)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)includedBuild2, (String)"includedBuild");
            File file3 = includedBuild2.getProjectDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"includedBuild.projectDir");
            String includedBuildPath = file3.getAbsolutePath();
            if (!(Intrinsics.areEqual((Object)includedBuildPath, (Object)currentBuildPath) ^ true)) continue;
            builder.put((Object)includedBuild.getName(), (Object)includedBuildPath);
        }
        ImmutableMap immutableMap = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"builder.build()");
        return immutableMap;
    }
}

