/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.VariantOutput;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.dsl.LintOptions;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.AnchorOutputType;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.builder.model.Version;
import com.android.repository.Revision;
import com.android.tools.lint.gradle.api.LintExecutionRequest;
import com.android.tools.lint.gradle.api.ReflectiveLintRunner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public abstract class LintBaseTask
extends DefaultTask {
    public static final String LINT_CLASS_PATH = "lintClassPath";
    protected static final Logger LOG = Logging.getLogger(LintBaseTask.class);
    FileCollection lintClassPath;
    protected Provider<Revision> buildToolsRevisionProvider;
    protected LintOptions lintOptions;
    protected File sdkHome;
    protected ToolingModelBuilderRegistry toolingRegistry;
    protected File reportsDir;

    @InputFiles
    public FileCollection getLintClassPath() {
        return this.lintClassPath;
    }

    public LintOptions getLintOptions() {
        return this.lintOptions;
    }

    protected void runLint(LintBaseTaskDescriptor descriptor) {
        FileCollection lintClassPath = this.getLintClassPath();
        if (lintClassPath != null) {
            new ReflectiveLintRunner().runLint(this.getProject().getGradle(), (LintExecutionRequest)descriptor, lintClassPath.getFiles());
        }
    }

    @Internal(value="No influence on output, this is to give access to the build tools version")
    private Revision getBuildToolsRevision() {
        return (Revision)this.buildToolsRevisionProvider.get();
    }

    public static abstract class BaseCreationAction<T extends LintBaseTask>
    extends TaskCreationAction<T> {
        private final GlobalScope globalScope;

        public BaseCreationAction(GlobalScope globalScope) {
            this.globalScope = globalScope;
        }

        protected GlobalScope getGlobalScope() {
            return this.globalScope;
        }

        @Override
        public void configure(T lintTask) {
            lintTask.setGroup("verification");
            ((LintBaseTask)((Object)lintTask)).lintOptions = this.globalScope.getExtension().getLintOptions();
            File sdkFolder = this.globalScope.getSdkComponents().getSdkFolder();
            if (sdkFolder != null) {
                ((LintBaseTask)((Object)lintTask)).sdkHome = sdkFolder;
            }
            ((LintBaseTask)((Object)lintTask)).toolingRegistry = this.globalScope.getToolingRegistry();
            ((LintBaseTask)((Object)lintTask)).reportsDir = this.globalScope.getReportsDir();
            ((LintBaseTask)((Object)lintTask)).buildToolsRevisionProvider = this.globalScope.getSdkComponents().getBuildToolsRevisionProvider();
            ((LintBaseTask)((Object)lintTask)).lintClassPath = this.globalScope.getProject().getConfigurations().getByName(LintBaseTask.LINT_CLASS_PATH);
        }
    }

    public static class VariantInputs
    implements com.android.tools.lint.gradle.api.VariantInputs {
        private final String name;
        private final BuildableArtifact localLintJarCollection;
        private final FileCollection dependencyLintJarCollection;
        private final Provider<? extends FileSystemLocation> mergedManifest;
        private final BuildableArtifact mergedManifestReport;
        private List<File> lintRuleJars;
        private final ConfigurableFileCollection allInputs;

        public VariantInputs(VariantScope variantScope) {
            this.name = variantScope.getFullVariantName();
            this.allInputs = variantScope.getGlobalScope().getProject().files(new Object[0]);
            Object[] objectArray = new Object[1];
            this.localLintJarCollection = variantScope.getGlobalScope().getArtifacts().getFinalArtifactFiles(InternalArtifactType.LINT_JAR);
            objectArray[0] = this.localLintJarCollection;
            this.allInputs.from(objectArray);
            Object[] objectArray2 = new Object[1];
            this.dependencyLintJarCollection = variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.LINT);
            objectArray2[0] = this.dependencyLintJarCollection;
            this.allInputs.from(objectArray2);
            BuildArtifactsHolder artifacts = variantScope.getArtifacts();
            Provider tmpMergedManifest = artifacts.getFinalProduct(InternalArtifactType.MERGED_MANIFESTS);
            if (!tmpMergedManifest.isPresent()) {
                tmpMergedManifest = artifacts.getFinalProduct(InternalArtifactType.LIBRARY_MANIFEST);
            }
            if (!tmpMergedManifest.isPresent()) {
                throw new RuntimeException("VariantInputs initialized with no merged manifest on: " + variantScope.getVariantConfiguration().getType());
            }
            this.mergedManifest = tmpMergedManifest;
            this.allInputs.from(new Object[]{this.mergedManifest});
            if (!artifacts.hasArtifact(InternalArtifactType.MANIFEST_MERGE_REPORT)) {
                throw new RuntimeException("VariantInputs initialized with no merged manifest report on: " + variantScope.getVariantConfiguration().getType());
            }
            Object[] objectArray3 = new Object[1];
            this.mergedManifestReport = artifacts.getFinalArtifactFiles(InternalArtifactType.MANIFEST_MERGE_REPORT);
            objectArray3[0] = this.mergedManifestReport;
            this.allInputs.from(objectArray3);
            this.allInputs.from(new Object[]{artifacts.getFinalArtifactFiles(AnchorOutputType.ALL_CLASSES)});
        }

        public FileCollection getAllInputs() {
            return this.allInputs;
        }

        public String getName() {
            return this.name;
        }

        public List<File> getRuleJars() {
            if (this.lintRuleJars == null) {
                this.lintRuleJars = Streams.concat((Stream[])new Stream[]{this.dependencyLintJarCollection.getFiles().stream(), this.localLintJarCollection.getFiles().stream()}).filter(File::isFile).collect(Collectors.toList());
            }
            return this.lintRuleJars;
        }

        public File getMergedManifest() {
            File file = ((FileSystemLocation)this.mergedManifest.get()).getAsFile();
            if (file.isFile()) {
                return file;
            }
            BuildElements manifests = ExistingBuildElements.from((ArtifactType)InternalArtifactType.MERGED_MANIFESTS, file);
            if (manifests.isEmpty()) {
                throw new RuntimeException("Can't find any manifest in folder: " + file);
            }
            Optional<File> mainManifest = manifests.stream().filter(buildOutput -> buildOutput.getApkData().getType() == VariantOutput.OutputType.MAIN).map(BuildOutput::getOutputFile).findFirst();
            if (mainManifest.isPresent()) {
                return mainManifest.get();
            }
            Optional<File> universalSplit = manifests.stream().filter(output2 -> output2.getApkData().getType() == VariantOutput.OutputType.FULL_SPLIT && output2.getFilters().isEmpty()).map(BuildOutput::getOutputFile).findFirst();
            return universalSplit.orElseGet(() -> manifests.iterator().next().getOutputFile());
        }

        public File getManifestMergeReport() {
            if (this.mergedManifestReport == null) {
                return null;
            }
            return (File)Iterables.getOnlyElement((Iterable)this.mergedManifestReport);
        }
    }

    protected abstract class LintBaseTaskDescriptor
    extends LintExecutionRequest {
        protected LintBaseTaskDescriptor() {
        }

        public File getSdkHome() {
            return LintBaseTask.this.sdkHome;
        }

        public ToolingModelBuilderRegistry getToolingRegistry() {
            return LintBaseTask.this.toolingRegistry;
        }

        public LintOptions getLintOptions() {
            return LintBaseTask.this.lintOptions;
        }

        public File getReportsDir() {
            return LintBaseTask.this.reportsDir;
        }

        public Project getProject() {
            return LintBaseTask.this.getProject();
        }

        public Revision getBuildToolsRevision() {
            return LintBaseTask.this.getBuildToolsRevision();
        }

        public void warn(String message, Object ... args2) {
            LOG.warn(message, args2);
        }

        public String getGradlePluginVersion() {
            return Version.ANDROID_GRADLE_PLUGIN_VERSION;
        }
    }
}

