/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.core.VariantConfiguration;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.builder.model.SourceProvider;
import com.android.builder.testing.TestData;
import com.android.sdklib.AndroidVersion;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.gradle.api.file.FileCollection;

public abstract class AbstractTestDataImpl
implements TestData {
    private final VariantConfiguration<?, ?, ?> testVariantConfig;
    private Map<String, String> extraInstrumentationTestRunnerArgs;
    private boolean animationsDisabled;
    protected final BuildableArtifact testApkDir;
    protected final BuildableArtifact testedApksDir;

    public AbstractTestDataImpl(VariantConfiguration<?, ?, ?> testVariantConfig, BuildableArtifact testApkDir, BuildableArtifact testedApksDir) {
        this.testVariantConfig = (VariantConfiguration)Preconditions.checkNotNull(testVariantConfig);
        this.extraInstrumentationTestRunnerArgs = Maps.newHashMap();
        this.testApkDir = testApkDir;
        this.testedApksDir = testedApksDir;
    }

    public String getInstrumentationRunner() {
        return this.testVariantConfig.getInstrumentationRunner();
    }

    public Map<String, String> getInstrumentationRunnerArguments() {
        return ImmutableMap.builder().putAll(this.testVariantConfig.getInstrumentationRunnerArguments()).putAll(this.extraInstrumentationTestRunnerArgs).build();
    }

    public void setExtraInstrumentationTestRunnerArgs(Map<String, String> extraInstrumentationTestRunnerArgs) {
        this.extraInstrumentationTestRunnerArgs = ImmutableMap.copyOf(extraInstrumentationTestRunnerArgs);
    }

    public boolean getAnimationsDisabled() {
        return this.animationsDisabled;
    }

    public void setAnimationsDisabled(boolean animationsDisabled) {
        this.animationsDisabled = animationsDisabled;
    }

    public boolean isTestCoverageEnabled() {
        return this.testVariantConfig.isTestCoverageEnabled();
    }

    public AndroidVersion getMinSdkVersion() {
        return this.testVariantConfig.getMinSdkVersion();
    }

    public String getFlavorName() {
        return this.testVariantConfig.getFlavorName().toUpperCase(Locale.getDefault());
    }

    public BuildableArtifact getTestApkDir() {
        return this.testApkDir;
    }

    public BuildableArtifact getTestedApksDir() {
        return this.testedApksDir;
    }

    public FileCollection getTestedApksFromBundle() {
        return null;
    }

    public final List<File> getTestDirectories() {
        ImmutableList.Builder javaDirectories = ImmutableList.builder();
        for (SourceProvider sourceProvider : this.testVariantConfig.getSortedSourceProviders()) {
            javaDirectories.addAll((Iterable)sourceProvider.getJavaDirectories());
        }
        return javaDirectories.build();
    }

    public File getTestApk() {
        BuildElements testApkOutputs = ExistingBuildElements.from((ArtifactType)InternalArtifactType.APK, this.testApkDir);
        if (testApkOutputs.size() != 1) {
            throw new RuntimeException("Unexpected number of main APKs, expected 1, got  " + testApkOutputs.size() + ":" + Joiner.on((String)",").join((Iterable)testApkOutputs));
        }
        return testApkOutputs.iterator().next().getOutputFile();
    }
}

